/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.Constants;
import org.intellij.terraform.config.model.BackendType;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.EphemeralType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.NamedType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ProvisionerType;
import org.intellij.terraform.config.model.ReferenceHint;
import org.intellij.terraform.config.model.ResourceOrDataSourceType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.SimpleValueHint;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.TfTypeModelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.local.LocalProviderNamesService;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.opentofu.model.EncryptionBlockType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u0087\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J;\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%*\b\u0012\u0004\u0012\u0002H%0\u00032\u0006\u0010&\u001a\u00020\u001b2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u001b0(H\u0002\u00a2\u0006\u0002\u0010)J4\u0010*\u001a\u00020+\"\u0004\b\u0000\u0010%*\b\u0012\u0004\u0012\u0002H%0\u00032\u0006\u0010&\u001a\u00020\u001b2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u001b0(H\u0002J\u001c\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010\u001b2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001c\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J\u001c\u00103\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J\u001c\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u00102\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/JS\u00105\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u0002062\u0006\u00102\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010/2\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0\u00030\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H%09H\u0002\u00a2\u0006\u0002\u0010:J\u001c\u0010;\u001a\u0004\u0018\u00010\b2\u0006\u00102\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J\u0010\u0010<\u001a\u0004\u0018\u00010\n2\u0006\u00102\u001a\u00020\u001bJ\u0010\u0010=\u001a\u0004\u0018\u00010\f2\u0006\u00102\u001a\u00020\u001bJ\u0010\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u00020\u001bJ\u0018\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001bJ\u001c\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020\u001b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J \u0010E\u001a\u0004\u0018\u00010C2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000409J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000609J\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\b09J\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001109R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR#\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR#\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001d\u00a8\u0006N"}, d2={"Lorg/intellij/terraform/config/model/TfTypeModel;", "", "resources", "", "Lorg/intellij/terraform/config/model/ResourceType;", "dataSources", "Lorg/intellij/terraform/config/model/DataSourceType;", "providers", "Lorg/intellij/terraform/config/model/ProviderType;", "provisioners", "Lorg/intellij/terraform/config/model/ProvisionerType;", "backends", "Lorg/intellij/terraform/config/model/BackendType;", "functions", "Lorg/intellij/terraform/config/model/TfFunction;", "providerDefinedFunctions", "ephemeralResources", "Lorg/intellij/terraform/config/model/EphemeralType;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProvisioners", "()Ljava/util/List;", "getBackends", "getFunctions", "getProviderDefinedFunctions", "providersByFullName", "", "", "getProvidersByFullName", "()Ljava/util/Map;", "resourcesByProvider", "getResourcesByProvider", "dataSourcesByProvider", "getDataSourcesByProvider", "ephemeralByProvider", "getEphemeralByProvider", "findBinary", "T", "elt", "k", "Lkotlin/Function1;", "(Ljava/util/List;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "findIndexBinary", "", "getProviderNameForIdentifier", "identifier", "psiElement", "Lcom/intellij/psi/PsiElement;", "isProviderTypeDefined", "getResourceType", "name", "getDataSourceType", "getEphemeralType", "lookupType", "Lorg/intellij/terraform/config/model/ResourceOrDataSourceType;", "typesMap", "allTypes", "Lkotlin/sequences/Sequence;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/Map;Lkotlin/sequences/Sequence;)Lorg/intellij/terraform/config/model/ResourceOrDataSourceType;", "getProviderType", "getProvisionerType", "getBackendType", "getFunction", "getProviderFunction", "provider", "functionName", "getByFQN", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "fqn", "find", "block", "Lorg/intellij/terraform/config/model/BlockType;", "parts", "allResources", "allDataSources", "allProviders", "allEphemeralResources", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfTypeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfTypeModel.kt\norg/intellij/terraform/config/model/TfTypeModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,473:1\n1056#2:474\n1056#2:475\n1056#2:476\n1056#2:477\n1491#2:478\n1516#2,3:479\n1519#2,3:489\n1252#2,2:494\n2393#2,14:496\n1255#2:510\n774#2:511\n865#2,2:512\n1491#2:514\n1516#2,3:515\n1519#2,3:525\n774#2:528\n865#2,2:529\n1491#2:531\n1516#2,3:532\n1519#2,3:542\n774#2:545\n865#2,2:546\n1491#2:548\n1516#2,3:549\n1519#2,3:559\n1563#2:563\n1634#2,3:564\n295#2,2:567\n295#2,2:570\n1208#2,2:572\n1236#2,4:574\n382#3,7:482\n463#3:492\n413#3:493\n382#3,7:518\n382#3,7:535\n382#3,7:552\n1#4:562\n455#5:569\n*S KotlinDebug\n*F\n+ 1 TfTypeModel.kt\norg/intellij/terraform/config/model/TfTypeModel\n*L\n75#1:474\n76#1:475\n77#1:476\n78#1:477\n81#1:478\n81#1:479,3\n81#1:489,3\n82#1:494,2\n82#1:496,14\n82#1:510\n91#1:511\n91#1:512,2\n91#1:514\n91#1:515,3\n91#1:525,3\n92#1:528\n92#1:529,2\n92#1:531\n92#1:532,3\n92#1:542,3\n93#1:545\n93#1:546,2\n93#1:548\n93#1:549,3\n93#1:559,3\n362#1:563\n362#1:564,3\n362#1:567,2\n402#1:570,2\n303#1:572,2\n303#1:574,4\n81#1:482,7\n82#1:492\n82#1:493\n91#1:518,7\n92#1:535,7\n93#1:552,7\n371#1:569\n*E\n"})
public final class TfTypeModel {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<ProvisionerType> provisioners;
    @NotNull
    private final List<BackendType> backends;
    @NotNull
    private final List<TfFunction> functions;
    @NotNull
    private final List<TfFunction> providerDefinedFunctions;
    @NotNull
    private final Map<String, ProviderType> providersByFullName;
    @NotNull
    private final Map<String, List<ResourceType>> resourcesByProvider;
    @NotNull
    private final Map<String, List<DataSourceType>> dataSourcesByProvider;
    @NotNull
    private final Map<String, List<EphemeralType>> ephemeralByProvider;
    @NotNull
    private static final PropertyType VersionProperty;
    @NotNull
    private static final PropertyType TerraformRequiredVersion;
    @NotNull
    private static final PropertyType DependsOnProperty;
    @NotNull
    private static final PropertyType CountProperty;
    @NotNull
    private static final PropertyType ForEachProperty;
    @NotNull
    private static final PropertyType ProviderProperty;
    @NotNull
    private static final PropertyType DescriptionProperty;
    @NotNull
    private static final PropertyType SensitiveProperty;
    @NotNull
    private static final PropertyType NullableProperty;
    @NotNull
    private static final BlockType Atlas;
    @NotNull
    private static final BlockType Module;
    @NotNull
    private static final PropertyType ErrorMessageProperty;
    @NotNull
    private static final PropertyType ConditionProperty;
    @NotNull
    private static final PropertyType VariableType;
    @NotNull
    private static final PropertyType VariableDefault;
    @NotNull
    private static final BlockType VariableValidation;
    @NotNull
    private static final PropertyType EphemeralProperty;
    @NotNull
    private static final BlockType Variable;
    @NotNull
    private static final BlockType Connection;
    @NotNull
    private static final Map<String, PropertyOrBlockType> ConnectionPropertiesSSH;
    @NotNull
    private static final Map<String, PropertyOrBlockType> ConnectionPropertiesWinRM;
    @NotNull
    private static final BlockType PreconditionBlock;
    @NotNull
    private static final BlockType PostconditionBlock;
    @NotNull
    private static final PropertyType ValueProperty;
    @NotNull
    private static final BlockType Output;
    @NotNull
    private static final BlockType ResourceLifecycle;
    @NotNull
    private static final BlockType AbstractResourceProvisioner;
    @NotNull
    private static final BlockType AbstractResourceDynamicContent;
    @NotNull
    private static final BlockType ResourceDynamic;
    @JvmField
    @NotNull
    public static final BlockType AbstractResource;
    @NotNull
    private static final BlockType AbstractEphemeralResource;
    @JvmField
    @NotNull
    public static final BlockType AbstractDataSource;
    @JvmField
    @NotNull
    public static final BlockType AbstractProvider;
    @NotNull
    private static final BlockType AbstractBackend;
    @NotNull
    private static final PropertyType FromProperty;
    @NotNull
    private static final PropertyType ToProperty;
    @NotNull
    private static final BlockType Moved;
    @NotNull
    private static final BlockType Cloud;
    @NotNull
    private static final BlockType Terraform;
    @NotNull
    private static final BlockType Locals;
    @NotNull
    private static final BlockType Import;
    @NotNull
    private static final BlockType AssertBlock;
    @NotNull
    private static final BlockType CheckBlock;
    @NotNull
    private static final BlockType RemovedBlock;
    @NotNull
    private static final List<BlockType> RootBlocks;
    @NotNull
    private static final Map<String, BlockType> RootBlocksMap;

    /*
     * WARNING - void declaration
     */
    public TfTypeModel(@NotNull List<ResourceType> resources, @NotNull List<DataSourceType> dataSources, @NotNull List<ProviderType> providers, @NotNull List<ProvisionerType> provisioners, @NotNull List<BackendType> backends, @NotNull List<TfFunction> functions, @NotNull List<TfFunction> providerDefinedFunctions, @NotNull List<EphemeralType> ephemeralResources) {
        List list$iv$iv;
        List answer$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        String key$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        BlockType it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Map.Entry $this$getOrPut$iv$iv$iv2;
        Object key$iv$iv$iv;
        void $this$groupByTo$iv$iv2;
        Map $this$groupBy$iv2;
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter(provisioners, (String)"provisioners");
        Intrinsics.checkNotNullParameter(backends, (String)"backends");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(providerDefinedFunctions, (String)"providerDefinedFunctions");
        Intrinsics.checkNotNullParameter(ephemeralResources, (String)"ephemeralResources");
        Iterable $this$sortedBy$iv = provisioners;
        boolean $i$f$sortedBy = false;
        this.provisioners = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProvisionerType it = (ProvisionerType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getType());
                it = (ProvisionerType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
            }
        });
        $this$sortedBy$iv = backends;
        $i$f$sortedBy = false;
        this.backends = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BackendType it = (BackendType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getType());
                it = (BackendType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
            }
        });
        $this$sortedBy$iv = functions;
        $i$f$sortedBy = false;
        this.functions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TfFunction it = (TfFunction)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (TfFunction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        $this$sortedBy$iv = providerDefinedFunctions;
        $i$f$sortedBy = false;
        this.providerDefinedFunctions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TfFunction it = (TfFunction)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (TfFunction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        $this$sortedBy$iv = providers;
        TfTypeModel tfTypeModel = this;
        boolean $i$f$groupBy = false;
        void var11_13 = $this$groupBy$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            String key$iv$iv2;
            ProviderType it2 = (ProviderType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getFullName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Map map = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv2 = new ArrayList();
                $this$getOrPut$iv$iv$iv2.put(key$iv$iv$iv, answer$iv$iv$iv2);
                object = answer$iv$iv$iv2;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv2 = (List)object;
            list$iv$iv2.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv;
        boolean $i$f$mapValues22 = false;
        $this$groupByTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object t;
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv2 = (Map.Entry)element$iv$iv$iv;
            key$iv$iv$iv = destination$iv$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = key$iv$iv$iv;
            boolean bl3 = false;
            List values = (List)value$iv$iv$iv.getValue();
            Iterable $this$minBy$iv = values;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                ProviderType it3 = (ProviderType)minElem$iv;
                boolean bl4 = false;
                Comparable minValue$iv = (Comparable)((Object)it3.getTier());
                do {
                    Object e$iv = iterator$iv.next();
                    ProviderType it4 = (ProviderType)e$iv;
                    $i$a$-minByOrThrow-TfTypeModel$providersByFullName$2$1 = false;
                    Comparable v$iv = (Comparable)((Object)it4.getTier());
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            ProviderType providerType = (ProviderType)t;
            object.put(k, providerType);
        }
        tfTypeModel.providersByFullName = destination$iv$iv$iv;
        Set loadedProviders = CollectionsKt.toSet((Iterable)this.providersByFullName.values());
        Iterable $i$f$mapValues22 = resources;
        tfTypeModel = this;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceType)element$iv$iv;
            boolean bl = false;
            if (!loadedProviders.contains(((ResourceType)it).getProvider())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy2 = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (ResourceType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ResourceType)it).getProvider().getFullName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            key$iv$iv$iv = destination$iv$iv2;
            String key$iv$iv$iv2 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv2);
            if (value$iv$iv$iv2 == null) {
                boolean bl5 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv2, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv2;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        tfTypeModel.resourcesByProvider = destination$iv$iv2;
        $this$groupBy$iv = dataSources;
        tfTypeModel = this;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataSourceType)element$iv$iv;
            boolean bl = false;
            if (!loadedProviders.contains(((DataSourceType)it).getProvider())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$groupBy2 = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (DataSourceType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((DataSourceType)it).getProvider().getFullName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            String key$iv$iv$iv3 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv3);
            if (value$iv$iv$iv3 == null) {
                boolean bl6 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv3, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv3;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        tfTypeModel.dataSourcesByProvider = destination$iv$iv2;
        $this$groupBy$iv = ephemeralResources;
        tfTypeModel = this;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EphemeralType)element$iv$iv;
            boolean bl = false;
            if (!loadedProviders.contains(((EphemeralType)it).getProvider())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$groupBy2 = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (EphemeralType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((EphemeralType)it).getProvider().getFullName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            String key$iv$iv$iv4 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv4 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv4);
            if (value$iv$iv$iv4 == null) {
                boolean bl7 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv4, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv4;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        tfTypeModel.ephemeralByProvider = destination$iv$iv2;
    }

    public /* synthetic */ TfTypeModel(List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list6 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list7 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list8 = CollectionsKt.emptyList();
        }
        this(list, list2, list3, list4, list5, list6, list7, list8);
    }

    @NotNull
    public final List<ProvisionerType> getProvisioners() {
        return this.provisioners;
    }

    @NotNull
    public final List<BackendType> getBackends() {
        return this.backends;
    }

    @NotNull
    public final List<TfFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<TfFunction> getProviderDefinedFunctions() {
        return this.providerDefinedFunctions;
    }

    @NotNull
    public final Map<String, ProviderType> getProvidersByFullName() {
        return this.providersByFullName;
    }

    @NotNull
    public final Map<String, List<ResourceType>> getResourcesByProvider() {
        return this.resourcesByProvider;
    }

    @NotNull
    public final Map<String, List<DataSourceType>> getDataSourcesByProvider() {
        return this.dataSourcesByProvider;
    }

    @NotNull
    public final Map<String, List<EphemeralType>> getEphemeralByProvider() {
        return this.ephemeralByProvider;
    }

    private final <T> T findBinary(List<? extends T> $this$findBinary, String elt, Function1<? super T, String> k) {
        T t;
        Integer n = this.findIndexBinary($this$findBinary, elt, k);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            t = $this$findBinary.get(it);
        } else {
            t = null;
        }
        return t;
    }

    private final <T> int findIndexBinary(List<? extends T> $this$findIndexBinary, String elt, Function1<? super T, String> k) {
        int low = 0;
        int high = $this$findIndexBinary.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $this$findIndexBinary.get(mid);
            int cmp = ((String)k.invoke(midVal)).compareTo(elt);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final String getProviderNameForIdentifier(String identifier, PsiElement psiElement) {
        String providerShortName;
        Object object;
        String string;
        Object localNames;
        block11: {
            Object object2;
            block10: {
                object2 = psiElement;
                if (object2 == null) break block10;
                PsiElement it = object2;
                boolean bl = false;
                Map<String, String> map = Companion.collectProviderLocalNames(it);
                object2 = map;
                if (map != null) break block11;
            }
            object2 = localNames = MapsKt.emptyMap();
        }
        if ((string = this.isProviderTypeDefined(psiElement)) == null) {
            string = Companion.getResourcePrefix(identifier);
        }
        if ((object = (String)localNames.get(providerShortName = string)) == null) {
            Object v4;
            block9: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = Constants.INSTANCE.getOfficialProvidersNamespace();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it + "/" + providerShortName);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!this.providersByFullName.containsKey(it)) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            if ((object = (String)v4) == null) {
                object = "hashicorp/" + providerShortName;
            }
        }
        String providerFullName = object;
        String string3 = providerFullName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    static /* synthetic */ String getProviderNameForIdentifier$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getProviderNameForIdentifier(string, psiElement);
    }

    private final String isProviderTypeDefined(PsiElement psiElement) {
        Object object;
        if (psiElement == null || !TfPsiPatterns.INSTANCE.getProviderDefinedHclBlocks().accepts((Object)psiElement)) {
            return null;
        }
        PsiElement $this$childrenOfType$iv = psiElement;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, HCLObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        HCLObject hCLObject = (HCLObject)CollectionsKt.firstOrNull((List)list);
        if (hCLObject == null) {
            return null;
        }
        HCLObject hclObject = hCLObject;
        Object object2 = hclObject.findProperty("provider");
        if (object2 == null || (object2 = object2.getValue()) == null || (object2 = object2.getText()) == null) {
            return null;
        }
        Object providerProperty = object2;
        Object object3 = new char[]{'.'};
        String string = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)providerProperty))).toString(), (char[])object3, (boolean)false, (int)0, (int)6, null));
        if (string != null) {
            Object it = object3 = (Object)string;
            boolean bl = false;
            object = ((CharSequence)it).length() > 0 ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final ResourceType getResourceType(@NotNull String name, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.lookupType(name, psiElement, this.resourcesByProvider, this.allResources());
    }

    public static /* synthetic */ ResourceType getResourceType$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getResourceType(string, psiElement);
    }

    @Nullable
    public final DataSourceType getDataSourceType(@NotNull String name, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.lookupType(name, psiElement, this.dataSourcesByProvider, this.allDataSources());
    }

    public static /* synthetic */ DataSourceType getDataSourceType$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getDataSourceType(string, psiElement);
    }

    @Nullable
    public final EphemeralType getEphemeralType(@NotNull String name, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.lookupType(name, psiElement, this.ephemeralByProvider, this.allEphemeralResources());
    }

    public static /* synthetic */ EphemeralType getEphemeralType$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getEphemeralType(string, psiElement);
    }

    private final <T extends ResourceOrDataSourceType> T lookupType(String name, PsiElement psiElement, Map<String, ? extends List<? extends T>> typesMap, Sequence<? extends T> allTypes) {
        ResourceOrDataSourceType resourceOrDataSourceType;
        Object v1;
        ResourceOrDataSourceType it;
        block4: {
            String providerName = this.getProviderNameForIdentifier(name, psiElement);
            List<T> list = typesMap.get(providerName);
            if (list == null) {
                return null;
            }
            List<T> typesCollection = list;
            Iterable $this$firstOrNull$iv = typesCollection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (ResourceOrDataSourceType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((NamedType)it).getType(), (Object)name)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        if ((resourceOrDataSourceType = (ResourceOrDataSourceType)v1) == null) {
            Object v3;
            block5: {
                Sequence<? extends T> sequence = allTypes;
                for (Object e : sequence) {
                    it = (ResourceOrDataSourceType)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((NamedType)it).getType(), (Object)name)) continue;
                    v3 = e;
                    break block5;
                }
                v3 = null;
            }
            resourceOrDataSourceType = v3;
        }
        return (T)resourceOrDataSourceType;
    }

    @Nullable
    public final ProviderType getProviderType(@NotNull String name, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String providerName = this.getProviderNameForIdentifier(name, psiElement);
        return this.providersByFullName.get(providerName);
    }

    public static /* synthetic */ ProviderType getProviderType$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getProviderType(string, psiElement);
    }

    @Nullable
    public final ProvisionerType getProvisionerType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.findBinary(this.provisioners, name, TfTypeModel::getProvisionerType$lambda$0);
    }

    @Nullable
    public final BackendType getBackendType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.findBinary(this.backends, name, TfTypeModel::getBackendType$lambda$0);
    }

    @Nullable
    public final TfFunction getFunction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.findBinary(this.functions, name, TfTypeModel::getFunction$lambda$0);
    }

    @Nullable
    public final TfFunction getProviderFunction(@NotNull String provider, @NotNull String functionName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Iterable iterable = this.providerDefinedFunctions;
            for (Object t : iterable) {
                TfFunction it = (TfFunction)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)functionName) && Intrinsics.areEqual((Object)it.getProviderType(), (Object)provider))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final PropertyOrBlockType getByFQN(@NotNull String fqn, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        char[] cArray = new char[]{'.'};
        List parts = StringsKt.split$default((CharSequence)fqn, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() < 2) {
            return null;
        }
        String string = (String)parts.get(0);
        BlockType blockType = Intrinsics.areEqual((Object)string, (Object)"resource") ? this.getResourceType((String)parts.get(1), psiElement) : (Intrinsics.areEqual((Object)string, (Object)"data") ? this.getDataSourceType((String)parts.get(1), psiElement) : null);
        if (blockType == null) {
            return null;
        }
        ResourceType second = blockType;
        if (parts.size() == 2) {
            return second;
        }
        return this.find(second, parts.subList(2, parts.size()));
    }

    public static /* synthetic */ PropertyOrBlockType getByFQN$default(TfTypeModel tfTypeModel, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        return tfTypeModel.getByFQN(string, psiElement);
    }

    private final PropertyOrBlockType find(BlockType block, List<String> parts) {
        if (parts.isEmpty()) {
            return null;
        }
        PropertyOrBlockType propertyOrBlockType = block.getProperties().get(parts.get(0));
        if (propertyOrBlockType == null) {
            return null;
        }
        PropertyOrBlockType pobt = propertyOrBlockType;
        if (pobt instanceof PropertyType) {
            return parts.size() == 1 ? pobt : null;
        }
        if (pobt instanceof BlockType) {
            return parts.size() == 1 ? pobt : this.find((BlockType)pobt, parts.subList(1, parts.size()));
        }
        return null;
    }

    @NotNull
    public final Sequence<ResourceType> allResources() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.resourcesByProvider.values()));
    }

    @NotNull
    public final Sequence<DataSourceType> allDataSources() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.dataSourcesByProvider.values()));
    }

    @NotNull
    public final Sequence<ProviderType> allProviders() {
        return CollectionsKt.asSequence((Iterable)this.providersByFullName.values());
    }

    @NotNull
    public final Sequence<EphemeralType> allEphemeralResources() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.ephemeralByProvider.values()));
    }

    private static final String getProvisionerType$lambda$0(ProvisionerType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType();
    }

    private static final String getBackendType$lambda$0(BackendType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType();
    }

    private static final String getFunction$lambda$0(TfFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    public TfTypeModel() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"VersionRange"};
        VersionProperty = new PropertyType("version", Types.INSTANCE.getString(), new SimpleValueHint((String[])objectArray), false, null, null, false, false, false, false, null, null, false, 8176, null);
        objectArray = new String[]{"VersionRange"};
        TerraformRequiredVersion = new PropertyType("required_version", Types.INSTANCE.getString(), new SimpleValueHint((String[])objectArray), false, null, null, false, false, false, false, null, null, false, 8176, null);
        objectArray = new String[]{"resource.#name", "data_source.#name", "module.#name", "variable.#name", "ephemeral.#name"};
        DependsOnProperty = new PropertyType("depends_on", Types.INSTANCE.getArray(), new ReferenceHint((String[])objectArray), false, null, null, false, false, false, false, null, null, false, 8184, null);
        CountProperty = new PropertyType("count", Types.INSTANCE.getNumber(), null, false, null, null, false, false, false, false, null, CollectionsKt.listOf((Object)"for_each"), false, 6140, null);
        ForEachProperty = new PropertyType("for_each", Types.INSTANCE.getAny(), null, false, null, null, false, false, false, false, null, CollectionsKt.listOf((Object)"count"), false, 6140, null);
        objectArray = new String[]{"provider.#type", "provider.#alias"};
        ProviderProperty = new PropertyType("provider", Types.INSTANCE.getString(), new ReferenceHint((String[])objectArray), false, null, null, false, false, false, false, null, null, false, 8184, null);
        DescriptionProperty = new PropertyType("description", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        SensitiveProperty = new PropertyType("sensitive", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        NullableProperty = new PropertyType("nullable", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        Atlas = new BlockType("atlas", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object)new PropertyType("name", Types.INSTANCE.getString(), null, false, null, null, false, true, false, false, null, null, false, 8052, null))), 1020, null);
        objectArray = new PropertyType[6];
        Object[] objectArray2 = new String[]{"Url"};
        objectArray[0] = new PropertyType("source", Types.INSTANCE.getString(), new SimpleValueHint((String[])objectArray2), false, null, null, false, true, false, false, null, null, false, 8056, null);
        objectArray[1] = VersionProperty;
        objectArray[2] = DependsOnProperty;
        objectArray[3] = CountProperty;
        objectArray[4] = ForEachProperty;
        objectArray[5] = new PropertyType("providers", new MapType(Types.INSTANCE.getString()), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        Module = new BlockType("module", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        ErrorMessageProperty = new PropertyType("error_message", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        ConditionProperty = new PropertyType("condition", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8180, null);
        VariableType = new PropertyType("type", Types.INSTANCE.getAny(), null, false, null, null, false, false, false, false, null, null, false, 8180, null);
        VariableDefault = new PropertyType("default", Types.INSTANCE.getAny(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        objectArray = new PropertyType[]{ConditionProperty, ErrorMessageProperty};
        VariableValidation = new BlockType("validation", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        EphemeralProperty = new PropertyType("ephemeral", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        objectArray = new PropertyOrBlockType[]{VariableType, VariableDefault, VariableValidation, DescriptionProperty, SensitiveProperty, NullableProperty, EphemeralProperty};
        Variable = new BlockType("variable", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyType[]{new PropertyType("type", Types.INSTANCE.getString(), null, false, "The connection type that should be used. Valid types are \"ssh\" and \"winrm\" This defaults to \"ssh\".", null, false, false, false, false, null, null, false, 8172, null), new PropertyType("user", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("password", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("host", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("port", Types.INSTANCE.getNumber(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("timeout", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("script_path", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null)};
        Connection = new BlockType("connection", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyType[]{new PropertyType("key_file", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, "Use 'private_key'", null, false, 7164, null), new PropertyType("private_key", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("agent", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_host", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_port", Types.INSTANCE.getNumber(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_user", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_password", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_private_key", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("bastion_key_file", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, "Use 'bastion_private_key'", null, false, 7164, null)};
        ConnectionPropertiesSSH = TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new PropertyType[]{new PropertyType("https", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("insecure", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("cacert", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null)};
        ConnectionPropertiesWinRM = TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new PropertyType[]{ConditionProperty, ErrorMessageProperty};
        PreconditionBlock = new BlockType("precondition", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyType[]{ConditionProperty, ErrorMessageProperty};
        PostconditionBlock = new BlockType("postcondition", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        ValueProperty = new PropertyType("value", Types.INSTANCE.getAny(), null, false, null, null, false, true, false, false, null, null, false, 8060, null);
        objectArray = new Object[]{ValueProperty, DescriptionProperty, DependsOnProperty, SensitiveProperty, PreconditionBlock, EphemeralProperty};
        Output = new BlockType("output", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new Object[]{new PropertyType("create_before_destroy", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("prevent_destroy", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("ignore_changes", new ListType(Types.INSTANCE.getAny()), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("replace_triggered_by", new ListType(Types.INSTANCE.getAny()), null, false, null, null, false, false, false, false, null, null, false, 8188, null), PreconditionBlock, PostconditionBlock};
        ResourceLifecycle = new BlockType("lifecycle", 0, "Describe to Terraform how to connect to the resource for provisioning", null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1016, null);
        AbstractResourceProvisioner = new BlockType("provisioner", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object)Connection)), 1020, null);
        AbstractResourceDynamicContent = new BlockType("content", 0, null, null, false, true, false, null, null, null, null, 2012, null);
        objectArray = new PropertyOrBlockType[]{new PropertyType("for_each", Types.INSTANCE.getAny(), null, false, null, null, false, true, false, false, null, null, false, 8060, null), new PropertyType("labels", Types.INSTANCE.getArray(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), new PropertyType("iterator", Types.INSTANCE.getIdentifier(), null, false, null, null, false, false, false, false, null, null, false, 8188, null), AbstractResourceDynamicContent};
        ResourceDynamic = new BlockType("dynamic", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyOrBlockType[]{new PropertyType("id", Types.INSTANCE.getString(), null, false, "A unique ID for this resource", null, false, false, true, false, null, null, false, 7716, null), CountProperty, ForEachProperty, DependsOnProperty, ProviderProperty, ResourceLifecycle, ResourceDynamic, Connection, AbstractResourceProvisioner};
        AbstractResource = new BlockType("resource", 2, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyOrBlockType[]{DependsOnProperty, CountProperty, ForEachProperty, ProviderProperty, ResourceLifecycle};
        AbstractEphemeralResource = new BlockType("ephemeral", 2, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new Object[]{new PropertyType("id", Types.INSTANCE.getString(), null, false, "A unique ID for this data source", null, false, false, true, false, null, null, false, 7716, null), CountProperty, ForEachProperty, DependsOnProperty, ResourceLifecycle, ProviderProperty};
        AbstractDataSource = new BlockType("data", 2, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new PropertyType[]{new PropertyType("alias", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8180, null), VersionProperty};
        AbstractProvider = new BlockType("provider", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 988, null);
        AbstractBackend = new BlockType("backend", 1, null, null, false, false, false, null, null, null, null, 2044, null);
        FromProperty = new PropertyType("from", Types.INSTANCE.getIdentifier(), null, false, null, null, false, true, false, false, null, null, false, 8060, null);
        ToProperty = new PropertyType("to", Types.INSTANCE.getIdentifier(), null, false, null, null, false, true, false, false, null, null, false, 8060, null);
        objectArray = new PropertyType[]{FromProperty, ToProperty};
        Moved = new BlockType("moved", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        objectArray = new Object[2];
        objectArray[0] = new PropertyType("organization", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        objectArray2 = new PropertyType[]{new PropertyType("name", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, CollectionsKt.listOf((Object)"tags"), false, 6140, null), new PropertyType("tags", new ListType(Types.INSTANCE.getString()), null, false, null, null, false, false, false, false, null, CollectionsKt.listOf((Object)"name"), false, 6140, null)};
        objectArray[1] = new BlockType("workspaces", 0, null, null, false, true, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray2)), 990, null);
        Cloud = new BlockType("cloud", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        objectArray = new PropertyOrBlockType[]{TerraformRequiredVersion, new BlockType("required_providers", 0, null, null, false, false, false, null, null, null, null, 2046, null), new BlockType("provider_meta", 1, null, null, false, false, false, null, null, null, null, 2044, null), new EncryptionBlockType(), Cloud, AbstractBackend, new PropertyType("experiments", Types.INSTANCE.getArray(), null, false, null, null, false, false, false, false, null, null, false, 8188, null)};
        Terraform = new BlockType("terraform", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        Locals = new BlockType("locals", 0, null, null, false, false, false, null, null, null, null, 2046, null);
        objectArray = new Object[]{ToProperty, new PropertyType("id", Types.INSTANCE.getString(), null, false, null, null, false, true, false, false, null, CollectionsKt.listOf((Object)"identity"), false, 6012, null), new BlockType("identity", 0, null, null, false, false, false, null, CollectionsKt.listOf((Object)"id"), null, null, 1788, null), new PropertyType("provider", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8060, null), ForEachProperty};
        Import = new BlockType("import", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        objectArray = new PropertyType[]{ConditionProperty, ErrorMessageProperty};
        AssertBlock = new BlockType("assert", 0, null, null, false, true, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 988, null);
        objectArray = new BlockType[]{AbstractDataSource, AssertBlock};
        CheckBlock = new BlockType("check", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new Object[]{FromProperty, ResourceLifecycle};
        RemovedBlock = new BlockType("removed", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1020, null);
        objectArray = new BlockType[]{AbstractDataSource, AbstractEphemeralResource, AbstractProvider, AbstractResource, Atlas, CheckBlock, Import, Locals, Module, Moved, Output, RemovedBlock, Terraform, Variable};
        RootBlocks = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$associateBy$iv = RootBlocks;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            BlockType blockType = (BlockType)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(p0.getLiteral(), element$iv$iv);
        }
        RootBlocksMap = destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020+J\u000e\u0010d\u001a\u00020+2\u0006\u0010c\u001a\u00020+J\u001c\u0010e\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0*2\u0006\u0010f\u001a\u00020gH\u0007J\u0014\u0010h\u001a\u0004\u0018\u00010i2\b\u0010f\u001a\u0004\u0018\u00010gH\u0002J\u0014\u0010j\u001a\u0004\u0018\u00010k2\b\u0010l\u001a\u0004\u0018\u00010mH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u0011\u0010%\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016R\u0011\u0010'\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001d\u0010/\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0011\u00101\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0016R\u0011\u00103\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0016R\u0011\u00105\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\bR\u0011\u00107\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0016R\u0011\u00109\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0016R\u0011\u0010;\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0016R\u0011\u0010=\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0016R\u0011\u0010?\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0016R\u0010\u0010A\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010B\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0016R\u0010\u0010D\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010F\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0016R\u0011\u0010H\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\bR\u0011\u0010J\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\bR\u0011\u0010L\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0016R\u0011\u0010N\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0016R\u0011\u0010P\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u0016R\u0011\u0010R\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0016R\u0011\u0010T\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0016R\u0011\u0010V\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0016R\u0011\u0010X\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0016R\u0011\u0010Z\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0016R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00140]\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u001d\u0010`\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00140*\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010.\u00a8\u0006n"}, d2={"Lorg/intellij/terraform/config/model/TfTypeModel$Companion;", "", "<init>", "()V", "VersionProperty", "Lorg/intellij/terraform/config/model/PropertyType;", "TerraformRequiredVersion", "getTerraformRequiredVersion", "()Lorg/intellij/terraform/config/model/PropertyType;", "DependsOnProperty", "CountProperty", "ForEachProperty", "ProviderProperty", "DescriptionProperty", "getDescriptionProperty", "SensitiveProperty", "getSensitiveProperty", "NullableProperty", "getNullableProperty", "Atlas", "Lorg/intellij/terraform/config/model/BlockType;", "getAtlas", "()Lorg/intellij/terraform/config/model/BlockType;", "Module", "getModule", "ErrorMessageProperty", "getErrorMessageProperty", "ConditionProperty", "getConditionProperty", "VariableType", "getVariableType", "VariableDefault", "getVariableDefault", "VariableValidation", "getVariableValidation", "EphemeralProperty", "getEphemeralProperty", "Variable", "getVariable", "Connection", "getConnection", "ConnectionPropertiesSSH", "", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "getConnectionPropertiesSSH", "()Ljava/util/Map;", "ConnectionPropertiesWinRM", "getConnectionPropertiesWinRM", "PreconditionBlock", "getPreconditionBlock", "PostconditionBlock", "getPostconditionBlock", "ValueProperty", "getValueProperty", "Output", "getOutput", "ResourceLifecycle", "getResourceLifecycle", "AbstractResourceProvisioner", "getAbstractResourceProvisioner", "AbstractResourceDynamicContent", "getAbstractResourceDynamicContent", "ResourceDynamic", "getResourceDynamic", "AbstractResource", "AbstractEphemeralResource", "getAbstractEphemeralResource", "AbstractDataSource", "AbstractProvider", "AbstractBackend", "getAbstractBackend", "FromProperty", "getFromProperty", "ToProperty", "getToProperty", "Moved", "getMoved", "Cloud", "getCloud", "Terraform", "getTerraform", "Locals", "getLocals", "Import", "getImport", "AssertBlock", "getAssertBlock", "CheckBlock", "getCheckBlock", "RemovedBlock", "getRemovedBlock", "RootBlocks", "", "getRootBlocks", "()Ljava/util/List;", "RootBlocksMap", "getRootBlocksMap", "getResourcePrefix", "identifier", "getResourceName", "collectProviderLocalNames", "psiElement", "Lcom/intellij/psi/PsiElement;", "getContainingDir", "Lcom/intellij/psi/PsiDirectory;", "getTerraformBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfTypeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfTypeModel.kt\norg/intellij/terraform/config/model/TfTypeModel$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n455#2:474\n455#2:495\n774#3:475\n865#3,2:476\n1563#3:478\n1634#3,3:479\n1374#3:482\n1460#3,5:483\n1193#3,2:488\n1267#3,4:490\n295#3,2:496\n1#4:494\n*S KotlinDebug\n*F\n+ 1 TfTypeModel.kt\norg/intellij/terraform/config/model/TfTypeModel$Companion\n*L\n320#1:474\n333#1:495\n321#1:475\n321#1:476,2\n322#1:478\n322#1:479,3\n323#1:482\n323#1:483,5\n323#1:488,2\n323#1:490,4\n333#1:496,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PropertyType getTerraformRequiredVersion() {
            return TerraformRequiredVersion;
        }

        @NotNull
        public final PropertyType getDescriptionProperty() {
            return DescriptionProperty;
        }

        @NotNull
        public final PropertyType getSensitiveProperty() {
            return SensitiveProperty;
        }

        @NotNull
        public final PropertyType getNullableProperty() {
            return NullableProperty;
        }

        @NotNull
        public final BlockType getAtlas() {
            return Atlas;
        }

        @NotNull
        public final BlockType getModule() {
            return Module;
        }

        @NotNull
        public final PropertyType getErrorMessageProperty() {
            return ErrorMessageProperty;
        }

        @NotNull
        public final PropertyType getConditionProperty() {
            return ConditionProperty;
        }

        @NotNull
        public final PropertyType getVariableType() {
            return VariableType;
        }

        @NotNull
        public final PropertyType getVariableDefault() {
            return VariableDefault;
        }

        @NotNull
        public final BlockType getVariableValidation() {
            return VariableValidation;
        }

        @NotNull
        public final PropertyType getEphemeralProperty() {
            return EphemeralProperty;
        }

        @NotNull
        public final BlockType getVariable() {
            return Variable;
        }

        @NotNull
        public final BlockType getConnection() {
            return Connection;
        }

        @NotNull
        public final Map<String, PropertyOrBlockType> getConnectionPropertiesSSH() {
            return ConnectionPropertiesSSH;
        }

        @NotNull
        public final Map<String, PropertyOrBlockType> getConnectionPropertiesWinRM() {
            return ConnectionPropertiesWinRM;
        }

        @NotNull
        public final BlockType getPreconditionBlock() {
            return PreconditionBlock;
        }

        @NotNull
        public final BlockType getPostconditionBlock() {
            return PostconditionBlock;
        }

        @NotNull
        public final PropertyType getValueProperty() {
            return ValueProperty;
        }

        @NotNull
        public final BlockType getOutput() {
            return Output;
        }

        @NotNull
        public final BlockType getResourceLifecycle() {
            return ResourceLifecycle;
        }

        @NotNull
        public final BlockType getAbstractResourceProvisioner() {
            return AbstractResourceProvisioner;
        }

        @NotNull
        public final BlockType getAbstractResourceDynamicContent() {
            return AbstractResourceDynamicContent;
        }

        @NotNull
        public final BlockType getResourceDynamic() {
            return ResourceDynamic;
        }

        @NotNull
        public final BlockType getAbstractEphemeralResource() {
            return AbstractEphemeralResource;
        }

        @NotNull
        public final BlockType getAbstractBackend() {
            return AbstractBackend;
        }

        @NotNull
        public final PropertyType getFromProperty() {
            return FromProperty;
        }

        @NotNull
        public final PropertyType getToProperty() {
            return ToProperty;
        }

        @NotNull
        public final BlockType getMoved() {
            return Moved;
        }

        @NotNull
        public final BlockType getCloud() {
            return Cloud;
        }

        @NotNull
        public final BlockType getTerraform() {
            return Terraform;
        }

        @NotNull
        public final BlockType getLocals() {
            return Locals;
        }

        @NotNull
        public final BlockType getImport() {
            return Import;
        }

        @NotNull
        public final BlockType getAssertBlock() {
            return AssertBlock;
        }

        @NotNull
        public final BlockType getCheckBlock() {
            return CheckBlock;
        }

        @NotNull
        public final BlockType getRemovedBlock() {
            return RemovedBlock;
        }

        @NotNull
        public final List<BlockType> getRootBlocks() {
            return RootBlocks;
        }

        @NotNull
        public final Map<String, BlockType> getRootBlocksMap() {
            return RootBlocksMap;
        }

        @NotNull
        public final String getResourcePrefix(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            String[] stringArray = new String[]{"_"};
            List stringList = StringsKt.split$default((CharSequence)identifier, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            String prefix = stringList.size() < 2 ? identifier : (String)stringList.get(0);
            return prefix;
        }

        @NotNull
        public final String getResourceName(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            String[] stringArray = new String[]{"_"};
            List stringList = StringsKt.split$default((CharSequence)identifier, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            String id = stringList.size() < 2 ? identifier : (String)stringList.get(1);
            return id;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequiresReadLock
        @NotNull
        public final Map<String, String> collectProviderLocalNames(@NotNull PsiElement psiElement) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            LocalProviderNamesService providerNamesService = LocalProviderNamesService.Companion.getInstance();
            PsiDirectory psiDirectory = this.getContainingDir(psiElement);
            if (psiDirectory == null) return MapsKt.emptyMap();
            PsiElement psiElement2 = (PsiElement)psiDirectory;
            boolean $i$f$childrenOfType22 = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiElement2, PsiFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            List list2 = list;
            if (list2 == null) return MapsKt.emptyMap();
            Iterable $i$f$childrenOfType22 = list2;
            boolean $i$f$filter22 = false;
            void var9_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiFile file = (PsiFile)element$iv$iv;
                boolean bl = false;
                if (!UtilKt.isTerraformCompatiblePsiFile(file)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiFile bl = (PsiFile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((Map)providerNamesService.getProvidersNamesGist().getFileData((PsiFile)it));
            }
            List gists = (List)destination$iv$iv2;
            Iterable $this$flatMap$iv = gists;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : iterable) {
                Map it = (Map)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.entrySet();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv3;
            boolean $i$f$associate = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv3 = $this$associate$iv;
            Map destination$iv$iv4 = new LinkedHashMap(n);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv4;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(it.getKey(), it.getValue());
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv4;
        }

        private final PsiDirectory getContainingDir(PsiElement psiElement) {
            PsiElement psiElement2;
            block4: {
                block3: {
                    psiElement2 = psiElement;
                    if (psiElement2 == null) break block3;
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    PsiFile psiFile = HclTypeModelKt.getContainingFile(it);
                    Object object = psiFile != null ? psiFile.getParent() : null;
                    psiElement2 = object;
                    if (object != null) break block4;
                }
                return null;
            }
            PsiElement containingDir = psiElement2;
            return containingDir.isDirectory() ? containingDir : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequiresReadLock
        @Nullable
        public final HCLBlock getTerraformBlock(@Nullable PsiFile psiFile) {
            Object v3;
            block1: {
                PsiFile psiFile2 = psiFile;
                Object object = psiFile2;
                if (psiFile2 == null) return null;
                PsiElement $this$childrenOfType$iv = (PsiElement)object;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, HCLBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                object = list;
                if (list == null) return null;
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HCLBlock it = (HCLBlock)element$iv;
                    boolean bl = false;
                    if (!TfPsiPatterns.INSTANCE.getTerraformRootBlock().accepts((Object)it)) continue;
                    v3 = element$iv;
                    break block1;
                }
                v3 = null;
            }
            HCLBlock hCLBlock = v3;
            return hCLBlock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

