/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.LazyKt;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.model.Block;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.model.VariableTypeCachedValueProvider;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/intellij/terraform/config/model/Variable;", "Lorg/intellij/terraform/config/model/Block;", "declaration", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)V", "getDeclaration", "()Lorg/intellij/terraform/hcl/psi/HCLBlock;", "name", "", "getName", "()Ljava/lang/String;", "name$delegate", "Lkotlin/Lazy;", "nameIdentifier", "Lcom/intellij/psi/PsiElement;", "getNameIdentifier", "()Lcom/intellij/psi/PsiElement;", "getDefault", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "getTypeExpression", "getType", "Lorg/intellij/terraform/config/model/HclType;", "getCombinedType", "getDescription", "equals", "", "other", "", "hashCode", "", "intellij.terraform"})
public final class Variable
extends Block {
    @NotNull
    private final HCLBlock declaration;
    @NotNull
    private final Lazy name$delegate;

    public Variable(@NotNull HCLBlock declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super(TfTypeModel.Companion.getVariable(), null, 2, null);
        this.declaration = declaration;
        this.name$delegate = LazyKt.lazyPub(() -> Variable.name_delegate$lambda$0(this));
    }

    @NotNull
    public final HCLBlock getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final PsiElement getNameIdentifier() {
        PsiElement psiElement = this.declaration.getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    @Nullable
    public final HCLExpression getDefault() {
        HCLElement hCLElement = this.declaration.getObject();
        return hCLElement != null && (hCLElement = hCLElement.findProperty(TfTypeModel.Companion.getVariableDefault().getName())) != null ? hCLElement.getValue() : null;
    }

    @Nullable
    public final HCLExpression getTypeExpression() {
        HCLElement hCLElement = this.declaration.getObject();
        return hCLElement != null && (hCLElement = hCLElement.findProperty(TfTypeModel.Companion.getVariableType().getName())) != null ? hCLElement.getValue() : null;
    }

    @Nullable
    public final HclType getType() {
        HCLExpression hCLExpression = this.getTypeExpression();
        if (hCLExpression == null) {
            return null;
        }
        HCLExpression expression = hCLExpression;
        return (HclType)CachedValuesManager.getManager((Project)this.declaration.getProject()).getCachedValue((UserDataHolder)expression, (CachedValueProvider)new VariableTypeCachedValueProvider(expression));
    }

    @Nullable
    public final HclType getCombinedType() {
        HclType typeType = this.getType();
        HclType hclType = ExtensionsKt.getType(this.getDefault());
        if (hclType == null) {
            return typeType;
        }
        HclType defType = hclType;
        if (typeType == null) {
            return defType;
        }
        Object[] objectArray = new HclType[]{defType, typeType};
        return HclTypeModelKt.getCommonSupertype(CollectionsKt.listOf((Object[])objectArray));
    }

    @Nullable
    public final HCLExpression getDescription() {
        HCLElement hCLElement = this.declaration.getObject();
        return hCLElement != null && (hCLElement = hCLElement.findProperty(TfTypeModel.Companion.getDescriptionProperty().getName())) != null ? hCLElement.getValue() : null;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Variable)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.declaration, (Object)((Variable)other).declaration);
    }

    public int hashCode() {
        return this.declaration.hashCode();
    }

    private static final String name_delegate$lambda$0(Variable this$0) {
        String string = this$0.declaration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

