/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.NestingInfo;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.TfTypeModelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.loader.BaseLoader;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.TfMetadataLoader;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/intellij/terraform/config/model/loader/ProviderLoader;", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "base", "Lorg/intellij/terraform/config/model/loader/BaseLoader;", "<init>", "(Lorg/intellij/terraform/config/model/loader/BaseLoader;)V", "getBase", "()Lorg/intellij/terraform/config/model/loader/BaseLoader;", "isSupportedType", "", "type", "", "load", "", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "parseProviderInfo", "Lorg/intellij/terraform/config/model/ProviderType;", "name", "obj", "parseResourceInfo", "Lorg/intellij/terraform/config/model/ResourceType;", "entry", "", "", "info", "parseDataSourceInfo", "Lorg/intellij/terraform/config/model/DataSourceType;", "getTimeoutsBlock", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nloaders_v1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/ProviderLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1#2:333\n1634#3,3:317\n1634#3,3:320\n1617#3,9:323\n1869#3:332\n1870#3:334\n1626#3:335\n1563#3:336\n1634#3,3:337\n1563#3:340\n1634#3,3:341\n*S KotlinDebug\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/ProviderLoader\n*L\n219#1:333\n188#1:317,3\n189#1:320,3\n219#1:323,9\n219#1:332\n219#1:334\n219#1:335\n219#1:336\n219#1:337,3\n223#1:340\n223#1:341,3\n*E\n"})
public abstract class ProviderLoader
implements VersionedMetadataLoader {
    @NotNull
    private final BaseLoader base;

    public ProviderLoader(@NotNull BaseLoader base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.base = base;
    }

    @NotNull
    protected final BaseLoader getBase() {
        return this.base;
    }

    @Override
    public boolean isSupportedType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"provider");
    }

    @Override
    public void load(@NotNull LoadContext context, @NotNull ObjectNode json, @NotNull String fileName) {
        block6: {
            Map.Entry it;
            Collection collection;
            Iterable $this$mapTo$iv;
            boolean $i$f$mapTo;
            Collection destination$iv;
            ObjectNode it2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            LoadingModel model = context.getModel();
            String string = ExtensionsKt.string(json, "name");
            Intrinsics.checkNotNull((Object)string);
            String name = LoadersKt.pool(string, context);
            ObjectNode provider = ExtensionsKt.obj(json, "provider");
            if (provider == null) {
                TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No provider schema in file '" + fileName + "'");
                return;
            }
            if (model.getLoaded().containsKey("provider." + name)) {
                TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Provider '" + name + "' is already loaded from '" + model.getLoaded().get("provider." + name) + "'");
                return;
            }
            model.getLoaded().put("provider." + name, fileName);
            ProviderType info = this.parseProviderInfo(context, name, provider);
            model.getProviders().add(info);
            ObjectNode resources = ExtensionsKt.obj(json, "resources");
            ObjectNode dataSources = ExtensionsKt.obj(json, "data-sources");
            if (resources == null && dataSources == null) {
                TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No resources nor data-sources defined for provider '" + name + "' in file '" + fileName + "'");
            }
            ObjectNode objectNode = resources;
            if (objectNode != null) {
                it2 = objectNode;
                boolean bl = false;
                Set set = it2.properties();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
                Iterable iterable = set;
                destination$iv = model.getResources();
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    Map.Entry entry = (Map.Entry)item$iv;
                    collection = destination$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(this.parseResourceInfo(context, it, info));
                }
                List cfr_ignored_0 = (List)destination$iv;
            }
            ObjectNode objectNode2 = dataSources;
            if (objectNode2 == null) break block6;
            it2 = objectNode2;
            boolean bl = false;
            Set set = it2.properties();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
            $this$mapTo$iv = set;
            destination$iv = model.getDataSources();
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (Map.Entry)item$iv;
                collection = destination$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(this.parseDataSourceInfo(context, it, info));
            }
            List cfr_ignored_1 = (List)destination$iv;
        }
    }

    private final ProviderType parseProviderInfo(LoadContext context, String name, ObjectNode obj) {
        Set set = obj.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        return new ProviderType(name, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> ProviderLoader.parseProviderInfo$lambda$0(this, context, name, arg_0))), null, null, null, null, 60, null);
    }

    private final ResourceType parseResourceInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        String name = LoadersKt.pool(entry.getKey(), context);
        boolean bl = entry.getValue() instanceof ObjectNode;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ProviderLoader$parseResourceInfo$22 = false;
            String $i$a$-assert-ProviderLoader$parseResourceInfo$22 = "Right part of resource should be object";
            throw new AssertionError((Object)$i$a$-assert-ProviderLoader$parseResourceInfo$22);
        }
        Object object = entry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode obj = (ObjectNode)object;
        PropertyOrBlockType timeouts = this.getTimeoutsBlock(context, obj);
        Set set = obj.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        return new ResourceType(name, info, SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> ProviderLoader.parseResourceInfo$lambda$1(this, context, name, arg_0)), (Object)timeouts))), null, 8, null);
    }

    private final DataSourceType parseDataSourceInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        String name = LoadersKt.pool(entry.getKey(), context);
        boolean bl = entry.getValue() instanceof ObjectNode;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ProviderLoader$parseDataSourceInfo$22 = false;
            String $i$a$-assert-ProviderLoader$parseDataSourceInfo$22 = "Right part of data-source should be object";
            throw new AssertionError((Object)$i$a$-assert-ProviderLoader$parseDataSourceInfo$22);
        }
        Object object = entry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode obj = (ObjectNode)object;
        PropertyOrBlockType timeouts = this.getTimeoutsBlock(context, obj);
        Set set = obj.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        return new DataSourceType(name, info, SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> ProviderLoader.parseDataSourceInfo$lambda$1(this, context, name, arg_0)), (Object)timeouts))), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyOrBlockType getTimeoutsBlock(LoadContext context, ObjectNode obj) {
        Collection<PropertyType> collection;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        JsonNode jsonNode = obj.remove("__timeouts__");
        if (jsonNode == null) {
            return null;
        }
        JsonNode value = jsonNode;
        boolean bl = value instanceof ArrayNode;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ProviderLoader$getTimeoutsBlock$32 = false;
            String $i$a$-assert-ProviderLoader$getTimeoutsBlock$32 = "__timeouts__ should be an array";
            throw new AssertionError((Object)$i$a$-assert-ProviderLoader$getTimeoutsBlock$32);
        }
        ArrayNode arrayNode = value instanceof ArrayNode ? (ArrayNode)value : null;
        if (arrayNode == null) {
            return null;
        }
        ArrayNode array = arrayNode;
        Iterator iterator = array.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator $i$a$-assert-ProviderLoader$getTimeoutsBlock$32 = iterator;
        while ($i$a$-assert-ProviderLoader$getTimeoutsBlock$32.hasNext()) {
            JsonNode element = (JsonNode)$i$a$-assert-ProviderLoader$getTimeoutsBlock$32.next();
            boolean bl2 = element instanceof TextNode;
            if (!_Assertions.ENABLED || bl2) continue;
            boolean $i$a$-assert-ProviderLoader$getTimeoutsBlock$42 = false;
            Object object = element;
            String $i$a$-assert-ProviderLoader$getTimeoutsBlock$42 = "__timeouts__ array elements should be string, got " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null);
            throw new AssertionError((Object)$i$a$-assert-ProviderLoader$getTimeoutsBlock$42);
        }
        Iterable $this$mapNotNull$iv = (Iterable)array;
        boolean $i$f$mapNotNull = false;
        Iterable $i$a$-assert-ProviderLoader$getTimeoutsBlock$42 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl3 = false;
            JsonNode it2 = (JsonNode)element$iv$iv;
            boolean bl4 = false;
            if (it2.textValue() == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl6 = false;
            collection2.add(LoadersKt.pool(it, context));
        }
        List timeouts = (List)destination$iv$iv;
        if (timeouts.isEmpty()) {
            return null;
        }
        $this$map$iv = timeouts;
        NestingInfo nestingInfo = null;
        List list = null;
        String string = null;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        String string2 = null;
        String string3 = "Amount of time a specific operation is allowed to take before being considered an error";
        int n = 0;
        String string4 = "timeouts";
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl10 = false;
            collection.add(LoadersKt.pool(new PropertyType(it, Types.INSTANCE.getString(), null, false, null, null, true, false, false, false, null, null, false, 8124, null), context));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 1016;
        Map<String, PropertyOrBlockType> map = TfTypeModelKt.toMap((Collection<? extends PropertyOrBlockType>)collection);
        NestingInfo nestingInfo2 = nestingInfo;
        List list2 = list;
        String string5 = string;
        boolean bl11 = bl7;
        boolean bl12 = bl8;
        boolean bl13 = bl9;
        String string6 = string2;
        String string7 = string3;
        int n3 = n;
        String string8 = string4;
        return LoadersKt.pool(new BlockType(string8, n3, string7, string6, bl13, bl12, bl11, string5, list2, nestingInfo2, map, n2, defaultConstructorMarker), context);
    }

    private static final PropertyOrBlockType parseProviderInfo$lambda$0(ProviderLoader this$0, LoadContext $context, String $name, Map.Entry it) {
        BaseLoader baseLoader = this$0.base;
        Intrinsics.checkNotNull((Object)it);
        return baseLoader.parseSchemaElement($context, it, $name);
    }

    private static final PropertyOrBlockType parseResourceInfo$lambda$1(ProviderLoader this$0, LoadContext $context, String $name, Map.Entry it) {
        BaseLoader baseLoader = this$0.base;
        Intrinsics.checkNotNull((Object)it);
        return baseLoader.parseSchemaElement($context, it, $name);
    }

    private static final PropertyOrBlockType parseDataSourceInfo$lambda$1(ProviderLoader this$0, LoadContext $context, String $name, Map.Entry it) {
        BaseLoader baseLoader = this$0.base;
        Intrinsics.checkNotNull((Object)it);
        return baseLoader.parseSchemaElement($context, it, $name);
    }
}

