/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.local;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/model/local/ProviderInfo;", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)V", "name", "", "getName", "()Ljava/lang/String;", "namespace", "getNamespace", "fullName", "getFullName", "version", "getVersion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nLockFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockFileParser.kt\norg/intellij/terraform/config/model/local/ProviderInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n295#2,2:43\n*S KotlinDebug\n*F\n+ 1 LockFileParser.kt\norg/intellij/terraform/config/model/local/ProviderInfo\n*L\n34#1:43,2\n*E\n"})
public final class ProviderInfo {
    @Nullable
    private final String name;
    @Nullable
    private final String namespace;
    @NotNull
    private final String fullName;
    @NotNull
    private final String version;

    /*
     * WARNING - void declaration
     */
    public ProviderInfo(@NotNull HCLBlock block) {
        String string;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string2 = block.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        ProviderType.ProviderCoordinates coordinates = ProviderType.Companion.parseCoordinates$intellij_terraform(string2);
        this.name = coordinates.getName();
        this.namespace = coordinates.getNamespace();
        this.fullName = this.namespace + "/" + this.name;
        ProviderInfo providerInfo = this;
        if (block.getObject() != null && block.getObject() != null) {
            Object v4;
            ProviderInfo providerInfo2;
            block4: {
                void $this$firstOrNull$iv;
                HCLObject hCLObject = block.getObject();
                Intrinsics.checkNotNull((Object)hCLObject, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLObject");
                List<HCLProperty> list = hCLObject.getPropertyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                Iterable iterable = list;
                providerInfo2 = providerInfo;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HCLProperty it = (HCLProperty)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"version")) continue;
                    v4 = element$iv;
                    break block4;
                }
                v4 = null;
            }
            providerInfo = providerInfo2;
            HCLElement hCLElement = v4;
            String providerVersion = hCLElement != null && (hCLElement = hCLElement.getValue()) != null ? hCLElement.getText() : null;
            String string3 = providerVersion;
            if (string3 == null) {
                string3 = "latest";
            }
            String string4 = StringUtil.unquoteString((String)string3);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        } else {
            string = "latest";
        }
        providerInfo.version = string;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }
}

