/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.local;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/config/model/local/VirtualFileMap;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "innerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "vfm", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "set", "", "key", "Lcom/intellij/openapi/vfs/VirtualFile;", "value", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)V", "get", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Object;", "remove", "intellij.terraform"})
final class VirtualFileMap<T> {
    @NotNull
    private final ConcurrentHashMap<VirtualFileUrl, T> innerCache;
    @NotNull
    private final VirtualFileUrlManager vfm;

    public VirtualFileMap(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.innerCache = new ConcurrentHashMap();
        this.vfm = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager();
    }

    public final void set(@NotNull VirtualFile key, T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.innerCache).put(VirtualFileUrls.toVirtualFileUrl((VirtualFile)key, (VirtualFileUrlManager)this.vfm), value);
    }

    @Nullable
    public final T get(@NotNull VirtualFile key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.innerCache.get(VirtualFileUrls.toVirtualFileUrl((VirtualFile)key, (VirtualFileUrlManager)this.vfm));
    }

    @Nullable
    public final T remove(@NotNull VirtualFile key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.innerCache.remove(VirtualFileUrls.toVirtualFileUrl((VirtualFile)key, (VirtualFileUrlManager)this.vfm));
    }
}

