/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.version;

import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.model.version.ConstraintKt;
import org.intellij.terraform.config.model.version.Version;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0007\u0010\u0011\u0012\u0013\u0014\u0015\u0016B+\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0007\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "Ljava/util/function/BiFunction;", "Lorg/intellij/terraform/config/model/version/Version;", "", "name", "", "f", "Lkotlin/Function2;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getName", "()Ljava/lang/String;", "apply", "t", "u", "(Lorg/intellij/terraform/config/model/version/Version;Lorg/intellij/terraform/config/model/version/Version;)Ljava/lang/Boolean;", "Equal", "NotEqual", "GreaterThan", "LessThan", "GreaterThanOrEqual", "LessThanOrEqual", "Pessimistic", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$Equal;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$GreaterThan;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$GreaterThanOrEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$LessThan;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$LessThanOrEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$NotEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction$Pessimistic;", "intellij.terraform"})
public abstract sealed class ConstraintFunction
implements BiFunction<Version, Version, Boolean> {
    @NotNull
    private final String name;
    @NotNull
    private final Function2<Version, Version, Boolean> f;

    private ConstraintFunction(String name, Function2<? super Version, ? super Version, Boolean> f) {
        this.name = name;
        this.f = f;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Boolean apply(@NotNull Version t, @NotNull Version u) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return (Boolean)this.f.invoke((Object)t, (Object)u);
    }

    public /* synthetic */ ConstraintFunction(String name, Function2 f, DefaultConstructorMarker $constructor_marker) {
        this(name, (Function2<? super Version, ? super Version, Boolean>)f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$Equal;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class Equal
    extends ConstraintFunction {
        @NotNull
        public static final Equal INSTANCE = new Equal();

        private Equal() {
            super("=", Equal::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return Intrinsics.areEqual((Object)v, (Object)c);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$GreaterThan;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class GreaterThan
    extends ConstraintFunction {
        @NotNull
        public static final GreaterThan INSTANCE = new GreaterThan();

        private GreaterThan() {
            super(">", GreaterThan::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return ConstraintKt.prereleaseCheck(v, c) && v.compareTo(c) > 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$GreaterThanOrEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class GreaterThanOrEqual
    extends ConstraintFunction {
        @NotNull
        public static final GreaterThanOrEqual INSTANCE = new GreaterThanOrEqual();

        private GreaterThanOrEqual() {
            super(">=", GreaterThanOrEqual::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return ConstraintKt.prereleaseCheck(v, c) && v.compareTo(c) >= 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$LessThan;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class LessThan
    extends ConstraintFunction {
        @NotNull
        public static final LessThan INSTANCE = new LessThan();

        private LessThan() {
            super("<", LessThan::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return ConstraintKt.prereleaseCheck(v, c) && v.compareTo(c) < 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$LessThanOrEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class LessThanOrEqual
    extends ConstraintFunction {
        @NotNull
        public static final LessThanOrEqual INSTANCE = new LessThanOrEqual();

        private LessThanOrEqual() {
            super("<=", LessThanOrEqual::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return ConstraintKt.prereleaseCheck(v, c) && v.compareTo(c) <= 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$NotEqual;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class NotEqual
    extends ConstraintFunction {
        @NotNull
        public static final NotEqual INSTANCE = new NotEqual();

        private NotEqual() {
            super("!=", NotEqual::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return !Intrinsics.areEqual((Object)v, (Object)c);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/terraform/config/model/version/ConstraintFunction$Pessimistic;", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "<init>", "()V", "intellij.terraform"})
    public static final class Pessimistic
    extends ConstraintFunction {
        @NotNull
        public static final Pessimistic INSTANCE = new Pessimistic();

        private Pessimistic() {
            super("~>", Pessimistic::_init_$lambda$0, null);
        }

        private static final boolean _init_$lambda$0(Version v, Version c) {
            if (!ConstraintKt.prereleaseCheck(v, c) || ((CharSequence)c.getPre()).length() > 0 && ((CharSequence)v.getPre()).length() == 0) {
                return false;
            }
            if (v.compareTo(c) < 0) {
                return false;
            }
            if (c.getSegments().length > v.getSegments().length) {
                return false;
            }
            int i = 0;
            int n = c.getSi() - 2;
            if (i <= n) {
                while (true) {
                    if (v.getSegments()[i] != c.getSegments()[i]) {
                        return false;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return c.getSegments()[c.getSi() - 1] <= v.getSegments()[c.getSi() - 1];
        }
    }
}

