/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.version.ConstraintFunction;
import org.intellij.terraform.config.model.version.MalformedConstraintException;
import org.intellij.terraform.config.model.version.MalformedVersionException;
import org.intellij.terraform.config.model.version.Version;
import org.intellij.terraform.config.model.version.VersionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/model/version/VersionConstraint;", "", "constraints", "", "Lorg/intellij/terraform/config/model/version/VersionConstraint$Constraint;", "<init>", "(Ljava/util/List;)V", "getConstraints", "()Ljava/util/List;", "check", "", "version", "Lorg/intellij/terraform/config/model/version/Version;", "isEmpty", "toString", "", "Constraint", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constraint.kt\norg/intellij/terraform/config/model/version/VersionConstraint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,201:1\n1740#2,3:202\n1504#2:205\n1534#2,3:206\n1537#2,3:216\n382#3,7:209\n*S KotlinDebug\n*F\n+ 1 Constraint.kt\norg/intellij/terraform/config/model/version/VersionConstraint\n*L\n63#1:202,3\n68#1:205\n68#1:206,3\n68#1:216,3\n68#1:209,7\n*E\n"})
public final class VersionConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Constraint> constraints;
    @NotNull
    private static final Lazy<VersionConstraint> AnyVersion$delegate = LazyKt.lazy(VersionConstraint::AnyVersion_delegate$lambda$0);
    @NotNull
    private static final Map<String, ConstraintFunction> ops;
    @NotNull
    private static final Regex constraintRegexp;

    private VersionConstraint(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    @NotNull
    public final List<Constraint> getConstraints() {
        return this.constraints;
    }

    public final boolean check(@NotNull Version version) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Iterable $this$all$iv = this.constraints;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl2 = false;
                    if (it.check(version)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEmpty() {
        Object pessimistic;
        Object object;
        Object lessThanOrEqual;
        Object object2;
        Object lessThan;
        Object object3;
        Object greaterThanOrEqual;
        Object object4;
        Object greaterThan;
        Set notEqual;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.constraints;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void p0;
            Object object5;
            void $this$getOrPut$iv$iv$iv;
            Constraint p02 = (Constraint)element$iv$iv;
            boolean $i$a$-groupBy-VersionConstraint$isEmpty$map$32 = false;
            ConstraintFunction key$iv$iv = p02.getOperation();
            Map map = destination$iv$iv;
            ConstraintFunction key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            Constraint $i$a$-groupBy-VersionConstraint$isEmpty$map$32 = (Constraint)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(p0.getCheck());
        }
        Map map = destination$iv$iv;
        SequencedCollection sequencedCollection = (List)map.get(ConstraintFunction.Equal.INSTANCE);
        Set equal = sequencedCollection != null && (sequencedCollection = CollectionsKt.toSortedSet((Iterable)sequencedCollection)) != null ? (Set)((Object)sequencedCollection) : SetsKt.emptySet();
        SequencedCollection sequencedCollection2 = (List)map.get(ConstraintFunction.NotEqual.INSTANCE);
        Set set = notEqual = sequencedCollection2 != null && (sequencedCollection2 = CollectionsKt.toSortedSet((Iterable)sequencedCollection2)) != null ? (Set)((Object)sequencedCollection2) : SetsKt.emptySet();
        Object object6 = (List)map.get(ConstraintFunction.GreaterThan.INSTANCE);
        if (object6 == null || (object6 = CollectionsKt.toSortedSet((Iterable)((Iterable)object6))) == null || (object6 = (Version)CollectionsKt.maxOrNull((Iterable)((Iterable)object6))) == null) {
            object6 = greaterThan = Version.Companion.getZERO();
        }
        if ((object4 = (List)map.get(ConstraintFunction.GreaterThanOrEqual.INSTANCE)) == null || (object4 = CollectionsKt.toSortedSet((Iterable)((Iterable)object4))) == null || (object4 = (Version)CollectionsKt.maxOrNull((Iterable)((Iterable)object4))) == null) {
            object4 = greaterThanOrEqual = Version.Companion.getZERO();
        }
        if ((object3 = (List)map.get(ConstraintFunction.LessThan.INSTANCE)) == null || (object3 = CollectionsKt.toSortedSet((Iterable)((Iterable)object3))) == null || (object3 = (Version)CollectionsKt.minOrNull((Iterable)((Iterable)object3))) == null) {
            object3 = lessThan = Version.Companion.getMAX();
        }
        if ((object2 = (List)map.get(ConstraintFunction.LessThanOrEqual.INSTANCE)) == null || (object2 = CollectionsKt.toSortedSet((Iterable)((Iterable)object2))) == null || (object2 = (Version)CollectionsKt.minOrNull((Iterable)((Iterable)object2))) == null) {
            object2 = lessThanOrEqual = Version.Companion.getMAX();
        }
        if ((object = (List)map.get(ConstraintFunction.Pessimistic.INSTANCE)) == null || (object = CollectionsKt.toSortedSet((Iterable)((Iterable)object))) == null || (object = (Version)CollectionsKt.maxOrNull((Iterable)((Iterable)object))) == null) {
            object = pessimistic = Version.Companion.getZERO();
        }
        if (equal.size() > 1) {
            return true;
        }
        Object unique = (Version)CollectionsKt.firstOrNull((Iterable)equal);
        if (((Version)lessThan).compareTo((Version)greaterThan) <= 0) {
            return true;
        }
        if (((Version)lessThan).compareTo((Version)greaterThanOrEqual) <= 0) {
            return true;
        }
        if (((Version)lessThan).compareTo((Version)pessimistic) <= 0) {
            return true;
        }
        if (((Version)lessThanOrEqual).compareTo((Version)greaterThan) <= 0) {
            return true;
        }
        if (((Version)lessThanOrEqual).compareTo((Version)greaterThanOrEqual) < 0) {
            return true;
        }
        if (((Version)lessThanOrEqual).compareTo((Version)pessimistic) < 0) {
            return true;
        }
        if (Intrinsics.areEqual((Object)lessThanOrEqual, (Object)greaterThanOrEqual) || Intrinsics.areEqual((Object)lessThanOrEqual, (Object)pessimistic)) {
            if (unique != null && !Intrinsics.areEqual((Object)unique, (Object)lessThanOrEqual)) {
                return true;
            }
            unique = lessThanOrEqual;
        }
        if (Intrinsics.areEqual((Object)lessThan, (Object)Version.Companion.getZERO())) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)pessimistic, (Object)Version.Companion.getZERO())) {
            if (((Version)greaterThan).compareTo((Version)pessimistic) >= 0 && !ConstraintFunction.Pessimistic.INSTANCE.apply((Version)greaterThan, (Version)pessimistic).booleanValue()) {
                return true;
            }
            if (((Version)greaterThanOrEqual).compareTo((Version)pessimistic) >= 0 && !ConstraintFunction.Pessimistic.INSTANCE.apply((Version)greaterThanOrEqual, (Version)pessimistic).booleanValue()) {
                return true;
            }
        }
        if (unique != null) {
            if (notEqual.contains(unique)) {
                return true;
            }
            if (((Version)unique).compareTo((Version)lessThan) >= 0) {
                return true;
            }
            if (((Version)unique).compareTo((Version)lessThanOrEqual) > 0) {
                return true;
            }
            if (((Version)unique).compareTo((Version)greaterThanOrEqual) < 0) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)greaterThan, (Object)Version.Companion.getZERO()) && ((Version)unique).compareTo((Version)greaterThan) <= 0) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.constraints, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private static final VersionConstraint AnyVersion_delegate$lambda$0() {
        return Companion.parse(">=0.0.0");
    }

    private static final CharSequence constraintRegexp$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Pattern.quote(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    public /* synthetic */ VersionConstraint(List constraints, DefaultConstructorMarker $constructor_marker) {
        this(constraints);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"", (Object)ConstraintFunction.Equal.INSTANCE), TuplesKt.to((Object)"=", (Object)ConstraintFunction.Equal.INSTANCE), TuplesKt.to((Object)"!=", (Object)ConstraintFunction.NotEqual.INSTANCE), TuplesKt.to((Object)">", (Object)ConstraintFunction.GreaterThan.INSTANCE), TuplesKt.to((Object)"<", (Object)ConstraintFunction.LessThan.INSTANCE), TuplesKt.to((Object)">=", (Object)ConstraintFunction.GreaterThanOrEqual.INSTANCE), TuplesKt.to((Object)"<=", (Object)ConstraintFunction.LessThanOrEqual.INSTANCE), TuplesKt.to((Object)"~>", (Object)ConstraintFunction.Pessimistic.INSTANCE)};
        ops = MapsKt.mapOf((Pair[])object);
        String string = "^\\s*(%s)\\s*(%s)\\s*$";
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)ops.keySet(), (CharSequence)"|", null, null, (int)0, null, VersionConstraint::constraintRegexp$lambda$0, (int)30, null), VersionKt.getVersionRegexpRaw()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        object = string2;
        constraintRegexp = new Regex((String)object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/config/model/version/VersionConstraint$Companion;", "", "<init>", "()V", "AnyVersion", "Lorg/intellij/terraform/config/model/version/VersionConstraint;", "getAnyVersion", "()Lorg/intellij/terraform/config/model/version/VersionConstraint;", "AnyVersion$delegate", "Lkotlin/Lazy;", "parse", "source", "", "intersect", "a", "b", "ops", "", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "constraintRegexp", "Lkotlin/text/Regex;", "parseSingle", "Lorg/intellij/terraform/config/model/version/VersionConstraint$Constraint;", "s", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constraint.kt\norg/intellij/terraform/config/model/version/VersionConstraint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1563#2:202\n1634#2,3:203\n*S KotlinDebug\n*F\n+ 1 Constraint.kt\norg/intellij/terraform/config/model/version/VersionConstraint$Companion\n*L\n24#1:202\n24#1:203,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionConstraint getAnyVersion() {
            Lazy lazy = AnyVersion$delegate;
            return (VersionConstraint)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VersionConstraint parse(@NotNull String source) throws MalformedConstraintException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)source, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.parseSingle((String)it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            List list = (List)destination$iv$iv;
            return new VersionConstraint(list, defaultConstructorMarker);
        }

        @NotNull
        public final VersionConstraint intersect(@NotNull VersionConstraint a, @NotNull VersionConstraint b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (Intrinsics.areEqual((Object)a, (Object)this.getAnyVersion())) {
                return b;
            }
            if (Intrinsics.areEqual((Object)b, (Object)this.getAnyVersion())) {
                return a;
            }
            return new VersionConstraint(CollectionsKt.plus((Collection)a.getConstraints(), (Iterable)b.getConstraints()), null);
        }

        private final Constraint parseSingle(String s) {
            Version version;
            Object object = constraintRegexp.matchEntire((CharSequence)s);
            if (object == null || (object = object.getGroupValues()) == null) {
                throw new MalformedConstraintException("Malformed constraint: " + s);
            }
            Object match = object;
            try {
                version = Version.Companion.parse((String)match.get(2));
            }
            catch (MalformedVersionException e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                throw new MalformedConstraintException(string);
            }
            Version version2 = version;
            ConstraintFunction constraintFunction = (ConstraintFunction)ops.get(match.get(1));
            if (constraintFunction == null) {
                throw new MalformedConstraintException("Unsupported operation: " + match.get(1));
            }
            ConstraintFunction operation = constraintFunction;
            return new Constraint(operation, version2, s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0004\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/intellij/terraform/config/model/version/VersionConstraint$Constraint;", "", "operation", "Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "check", "Lorg/intellij/terraform/config/model/version/Version;", "original", "", "<init>", "(Lorg/intellij/terraform/config/model/version/ConstraintFunction;Lorg/intellij/terraform/config/model/version/Version;Ljava/lang/String;)V", "getOperation", "()Lorg/intellij/terraform/config/model/version/ConstraintFunction;", "getCheck", "()Lorg/intellij/terraform/config/model/version/Version;", "getOriginal", "()Ljava/lang/String;", "", "version", "toString", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "intellij.terraform"})
    public static final class Constraint {
        @NotNull
        private final ConstraintFunction operation;
        @NotNull
        private final Version check;
        @NotNull
        private final String original;

        public Constraint(@NotNull ConstraintFunction operation, @NotNull Version check, @NotNull String original) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            this.operation = operation;
            this.check = check;
            this.original = original;
        }

        @NotNull
        public final ConstraintFunction getOperation() {
            return this.operation;
        }

        @NotNull
        public final Version getCheck() {
            return this.check;
        }

        @NotNull
        public final String getOriginal() {
            return this.original;
        }

        public final boolean check(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.operation.apply(version, this.check);
        }

        @NotNull
        public String toString() {
            return this.original;
        }

        @NotNull
        public final ConstraintFunction component1() {
            return this.operation;
        }

        @NotNull
        public final Version component2() {
            return this.check;
        }

        @NotNull
        public final String component3() {
            return this.original;
        }

        @NotNull
        public final Constraint copy(@NotNull ConstraintFunction operation, @NotNull Version check, @NotNull String original) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            return new Constraint(operation, check, original);
        }

        public static /* synthetic */ Constraint copy$default(Constraint constraint, ConstraintFunction constraintFunction, Version version, String string, int n, Object object) {
            if ((n & 1) != 0) {
                constraintFunction = constraint.operation;
            }
            if ((n & 2) != 0) {
                version = constraint.check;
            }
            if ((n & 4) != 0) {
                string = constraint.original;
            }
            return constraint.copy(constraintFunction, version, string);
        }

        public int hashCode() {
            int result2 = this.operation.hashCode();
            result2 = result2 * 31 + this.check.hashCode();
            result2 = result2 * 31 + this.original.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Constraint)) {
                return false;
            }
            Constraint constraint = (Constraint)other;
            if (!Intrinsics.areEqual((Object)this.operation, (Object)constraint.operation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.check, (Object)constraint.check)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.original, (Object)constraint.original);
        }
    }
}

