/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hil.HILLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/refactoring/IntroduceValidator;", "", "<init>", "()V", "myNamesValidator", "Lcom/intellij/lang/refactoring/NamesValidator;", "isNameValid", "", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "checkPossibleName", "expression", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "check", "psiElement", "Companion", "intellij.terraform"})
public class IntroduceValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamesValidator myNamesValidator;

    public IntroduceValidator() {
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage((Language)HILLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"forLanguage(...)");
        this.myNamesValidator = namesValidator;
    }

    public final boolean isNameValid(@Nullable String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return name != null && this.myNamesValidator.isIdentifier(name, project) && !this.myNamesValidator.isKeyword(name, project);
    }

    public final boolean checkPossibleName(@NotNull String name, @NotNull HCLElement expression) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.check(name, expression) == null;
    }

    @Nullable
    public final String check(@NotNull String name, @NotNull HCLElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (Companion.isDefinedInScope(name, psiElement)) {
            return HCLBundle.message("refactoring.introduce.variable.scope.error", new Object[0]);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/config/refactoring/IntroduceValidator$Companion;", "", "<init>", "()V", "isDefinedInScope", "", "name", "", "psiElement", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDefinedInScope(@NotNull String name, @NotNull HCLElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Variable variable = ExtensionsKt.getTerraformModule(psiElement).findVariable(name);
            return variable != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

