/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.refactoring;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/refactoring/TfElementRenameValidator;", "Lcom/intellij/refactoring/rename/RenameInputValidator;", "<init>", "()V", "getPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "isInputValid", "", "name", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "Companion", "intellij.terraform"})
public final class TfElementRenameValidator
implements RenameInputValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> ProhibitedVariableNames;

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern[] elementPatternArray = new ElementPattern[]{TfPsiPatterns.INSTANCE.getResourceRootBlock(), TfPsiPatterns.INSTANCE.getDataSourceRootBlock(), TfPsiPatterns.INSTANCE.getModuleRootBlock(), TfPsiPatterns.INSTANCE.getVariableRootBlock(), TfPsiPatterns.INSTANCE.getOutputRootBlock()};
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        return elementPattern;
    }

    public boolean isInputValid(@NotNull String name, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isInputValid(name, element);
    }

    public final boolean isInputValid(@NotNull String name, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.getPattern().accepts((Object)element)) {
            return false;
        }
        if (TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)element)) {
            String string = HCLPsiUtil.stripQuotes(name);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (ProhibitedVariableNames.contains(string2)) {
                return false;
            }
        }
        return Companion.isInputValid$intellij_terraform(name);
    }

    static {
        Object[] objectArray = new String[]{"source", "version", "providers", "count", "for_each", "lifecycle", "depends_on", "locals"};
        ProhibitedVariableNames = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/terraform/config/refactoring/TfElementRenameValidator$Companion;", "", "<init>", "()V", "ProhibitedVariableNames", "", "", "isInputValid", "", "name", "isInputValid$intellij_terraform", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInputValid$intellij_terraform(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int length = name.length();
            if (length == 0) {
                return false;
            }
            if (name.charAt(0) != '_' && !Character.isUnicodeIdentifierStart(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < length; ++i) {
                char c = name.charAt(i);
                if (c == '-' || Character.isUnicodeIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

