/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.refactoring;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.refactoring.IntroduceOperation;
import org.intellij.terraform.config.refactoring.IntroduceValidator;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableIntroduceDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private JLabel myNameLabel;
    private ComboBox myNameComboBox;
    private JCheckBox myReplaceAll;
    private final Project myProject;
    private final int myOccurrencesCount;
    private final IntroduceValidator myValidator;
    private final HCLElement myExpression;

    public VariableIntroduceDialog(@NotNull Project project, @NotNull @Nls String caption, @NotNull IntroduceValidator validator, IntroduceOperation operation) {
        if (project == null) {
            VariableIntroduceDialog.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            VariableIntroduceDialog.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            VariableIntroduceDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myOccurrencesCount = operation.getOccurrences().size();
        this.myValidator = validator;
        this.myProject = project;
        this.myExpression = (HCLElement)operation.getInitializer();
        this.setUpNameComboBox(operation.getSuggestedNames());
        this.setTitle(caption);
        this.init();
        this.setupDialog();
        this.updateControls();
    }

    private void setUpNameComboBox(Collection<String> possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)TerraformFileType.INSTANCE, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myNameComboBox.addItemListener(e -> this.updateControls());
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                VariableIntroduceDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/terraform/config/refactoring/VariableIntroduceDialog$1", "documentChanged"));
            }
        });
        this.myContentPane.registerKeyboardAction(e -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myNameComboBox, true)), KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    private void setupDialog() {
        this.myReplaceAll.setMnemonic(65);
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        if (this.myOccurrencesCount > 1) {
            this.myReplaceAll.setSelected(false);
            this.myReplaceAll.setEnabled(true);
            this.myReplaceAll.setText(HCLBundle.message("introduce.dialogs.replace.all.checkbox.title", this.myReplaceAll.getText(), this.myOccurrencesCount));
        } else {
            this.myReplaceAll.setSelected(false);
            this.myReplaceAll.setEnabled(false);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    public String getName() {
        Object item = this.myNameComboBox.getEditor().getItem();
        if (item instanceof String && !((String)item).isEmpty()) {
            return ((String)item).trim();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public HCLElement getExpression() {
        return this.myExpression;
    }

    public boolean doReplaceAllOccurrences() {
        return this.myReplaceAll.isSelected();
    }

    private void updateControls() {
        String name = this.getName();
        boolean nameValid = this.myValidator.isNameValid(name, this.getProject());
        this.setErrorText(!nameValid ? HCLBundle.message("refactoring.introduce.name.error", new Object[0]) : null);
        this.setErrorText(!(nameValid &= name != null && this.myValidator.checkPossibleName(name, this.myExpression)) ? HCLBundle.message("refactoring.introduce.variable.scope.error", new Object[0]) : null);
        this.setOKActionEnabled(nameValid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caption";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "validator";
                break;
            }
        }
        objectArray[1] = "org/intellij/terraform/config/refactoring/VariableIntroduceDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("<HTML><u>N</u>ame:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        comboBox.setLightWeightPopupEnabled(true);
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myReplaceAll = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RefactoringBundle", VariableIntroduceDialog.class).getString("replace.all.occurences.checkbox"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

