/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.terraform.hcl.HCLElementType;
import org.intellij.terraform.hcl.HCLTokenType;
import org.intellij.terraform.hcl.psi.impl.HCLArrayImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryAdditionExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryAndExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryEqualityExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryMultiplyExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryOrExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBinaryRelationalExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBlockImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBlockObjectImpl;
import org.intellij.terraform.hcl.psi.impl.HCLBooleanLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLConditionalExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLDefinedMethodExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLForArrayExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLForConditionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLForIntroImpl;
import org.intellij.terraform.hcl.psi.impl.HCLForObjectExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLHeredocContentImpl;
import org.intellij.terraform.hcl.psi.impl.HCLHeredocLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLHeredocMarkerImpl;
import org.intellij.terraform.hcl.psi.impl.HCLIdentifierImpl;
import org.intellij.terraform.hcl.psi.impl.HCLIndexSelectExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLMethodCallExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLNullLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLNumberLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLObjectImpl;
import org.intellij.terraform.hcl.psi.impl.HCLParameterListImpl;
import org.intellij.terraform.hcl.psi.impl.HCLParenthesizedExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLPropertyImpl;
import org.intellij.terraform.hcl.psi.impl.HCLSelectExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLUnaryExpressionImpl;
import org.intellij.terraform.hcl.psi.impl.HCLVariableImpl;

public interface HCLElementTypes {
    public static final IElementType ARRAY = new HCLElementType("ARRAY");
    public static final IElementType BINARY_ADDITION_EXPRESSION = new HCLElementType("BINARY_ADDITION_EXPRESSION");
    public static final IElementType BINARY_AND_EXPRESSION = new HCLElementType("BINARY_AND_EXPRESSION");
    public static final IElementType BINARY_EQUALITY_EXPRESSION = new HCLElementType("BINARY_EQUALITY_EXPRESSION");
    public static final IElementType BINARY_MULTIPLY_EXPRESSION = new HCLElementType("BINARY_MULTIPLY_EXPRESSION");
    public static final IElementType BINARY_OR_EXPRESSION = new HCLElementType("BINARY_OR_EXPRESSION");
    public static final IElementType BINARY_RELATIONAL_EXPRESSION = new HCLElementType("BINARY_RELATIONAL_EXPRESSION");
    public static final IElementType BLOCK = new HCLElementType("BLOCK");
    public static final IElementType BLOCK_OBJECT = new HCLElementType("BLOCK_OBJECT");
    public static final IElementType BOOLEAN_LITERAL = new HCLElementType("BOOLEAN_LITERAL");
    public static final IElementType COLLECTION_VALUE = new HCLElementType("COLLECTION_VALUE");
    public static final IElementType CONDITIONAL_EXPRESSION = new HCLElementType("CONDITIONAL_EXPRESSION");
    public static final IElementType DEFINED_METHOD_EXPRESSION = new HCLElementType("DEFINED_METHOD_EXPRESSION");
    public static final IElementType EXPRESSION = new HCLElementType("EXPRESSION");
    public static final IElementType FOR_ARRAY_EXPRESSION = new HCLElementType("FOR_ARRAY_EXPRESSION");
    public static final IElementType FOR_CONDITION = new HCLElementType("FOR_CONDITION");
    public static final IElementType FOR_INTRO = new HCLElementType("FOR_INTRO");
    public static final IElementType FOR_OBJECT_EXPRESSION = new HCLElementType("FOR_OBJECT_EXPRESSION");
    public static final IElementType HEREDOC_CONTENT = new HCLElementType("HEREDOC_CONTENT");
    public static final IElementType HEREDOC_LITERAL = new HCLElementType("HEREDOC_LITERAL");
    public static final IElementType HEREDOC_MARKER = new HCLElementType("HEREDOC_MARKER");
    public static final IElementType IDENTIFIER = new HCLElementType("IDENTIFIER");
    public static final IElementType INDEX_SELECT_EXPRESSION = new HCLElementType("INDEX_SELECT_EXPRESSION");
    public static final IElementType LITERAL = new HCLElementType("LITERAL");
    public static final IElementType METHOD_CALL_EXPRESSION = new HCLElementType("METHOD_CALL_EXPRESSION");
    public static final IElementType NULL_LITERAL = new HCLElementType("NULL_LITERAL");
    public static final IElementType NUMBER_LITERAL = new HCLElementType("NUMBER_LITERAL");
    public static final IElementType OBJECT = new HCLElementType("OBJECT");
    public static final IElementType PARAMETER_LIST = new HCLElementType("PARAMETER_LIST");
    public static final IElementType PARENTHESIZED_EXPRESSION = new HCLElementType("PARENTHESIZED_EXPRESSION");
    public static final IElementType PROPERTY = new HCLElementType("PROPERTY");
    public static final IElementType SELECT_EXPRESSION = new HCLElementType("SELECT_EXPRESSION");
    public static final IElementType STRING_LITERAL = new HCLElementType("STRING_LITERAL");
    public static final IElementType UNARY_EXPRESSION = new HCLElementType("UNARY_EXPRESSION");
    public static final IElementType VALUE = new HCLElementType("VALUE");
    public static final IElementType VARIABLE = new HCLElementType("VARIABLE");
    public static final IElementType BLOCK_COMMENT = new HCLTokenType("block_comment");
    public static final IElementType COLON_COLON = new HCLTokenType("::");
    public static final IElementType COMMA = new HCLTokenType(",");
    public static final IElementType DOUBLE_QUOTED_STRING = new HCLTokenType("DOUBLE_QUOTED_STRING");
    public static final IElementType EQUALS = new HCLTokenType("=");
    public static final IElementType FALSE = new HCLTokenType("false");
    public static final IElementType HD_EOL = new HCLTokenType("HD_EOL");
    public static final IElementType HD_LINE = new HCLTokenType("HD_LINE");
    public static final IElementType HD_MARKER = new HCLTokenType("HD_MARKER");
    public static final IElementType HD_START = new HCLTokenType("HD_START");
    public static final IElementType ID = new HCLTokenType("ID");
    public static final IElementType LINE_C_COMMENT = new HCLTokenType("line_c_comment");
    public static final IElementType LINE_HASH_COMMENT = new HCLTokenType("line_hash_comment");
    public static final IElementType L_BRACKET = new HCLTokenType("[");
    public static final IElementType L_CURLY = new HCLTokenType("{");
    public static final IElementType L_PAREN = new HCLTokenType("(");
    public static final IElementType NULL = new HCLTokenType("null");
    public static final IElementType NUMBER = new HCLTokenType("NUMBER");
    public static final IElementType OP_AND_AND = new HCLTokenType("&&");
    public static final IElementType OP_COLON = new HCLTokenType(":");
    public static final IElementType OP_DIV = new HCLTokenType("/");
    public static final IElementType OP_DOT = new HCLTokenType(".");
    public static final IElementType OP_ELLIPSIS = new HCLTokenType("...");
    public static final IElementType OP_EQUAL = new HCLTokenType("==");
    public static final IElementType OP_GREATER = new HCLTokenType(">");
    public static final IElementType OP_GREATER_OR_EQUAL = new HCLTokenType(">=");
    public static final IElementType OP_LESS = new HCLTokenType("<");
    public static final IElementType OP_LESS_OR_EQUAL = new HCLTokenType("<=");
    public static final IElementType OP_MAPPING = new HCLTokenType("=>");
    public static final IElementType OP_MINUS = new HCLTokenType("-");
    public static final IElementType OP_MOD = new HCLTokenType("%");
    public static final IElementType OP_MUL = new HCLTokenType("*");
    public static final IElementType OP_NOT = new HCLTokenType("!");
    public static final IElementType OP_NOT_EQUAL = new HCLTokenType("!=");
    public static final IElementType OP_OR_OR = new HCLTokenType("||");
    public static final IElementType OP_PLUS = new HCLTokenType("+");
    public static final IElementType OP_QUEST = new HCLTokenType("?");
    public static final IElementType R_BRACKET = new HCLTokenType("]");
    public static final IElementType R_CURLY = new HCLTokenType("}");
    public static final IElementType R_PAREN = new HCLTokenType(")");
    public static final IElementType SINGLE_QUOTED_STRING = new HCLTokenType("SINGLE_QUOTED_STRING");
    public static final IElementType TRUE = new HCLTokenType("true");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ARRAY) {
                return new HCLArrayImpl(node);
            }
            if (type == BINARY_ADDITION_EXPRESSION) {
                return new HCLBinaryAdditionExpressionImpl(node);
            }
            if (type == BINARY_AND_EXPRESSION) {
                return new HCLBinaryAndExpressionImpl(node);
            }
            if (type == BINARY_EQUALITY_EXPRESSION) {
                return new HCLBinaryEqualityExpressionImpl(node);
            }
            if (type == BINARY_MULTIPLY_EXPRESSION) {
                return new HCLBinaryMultiplyExpressionImpl(node);
            }
            if (type == BINARY_OR_EXPRESSION) {
                return new HCLBinaryOrExpressionImpl(node);
            }
            if (type == BINARY_RELATIONAL_EXPRESSION) {
                return new HCLBinaryRelationalExpressionImpl(node);
            }
            if (type == BLOCK) {
                return new HCLBlockImpl(node);
            }
            if (type == BLOCK_OBJECT) {
                return new HCLBlockObjectImpl(node);
            }
            if (type == BOOLEAN_LITERAL) {
                return new HCLBooleanLiteralImpl(node);
            }
            if (type == CONDITIONAL_EXPRESSION) {
                return new HCLConditionalExpressionImpl(node);
            }
            if (type == DEFINED_METHOD_EXPRESSION) {
                return new HCLDefinedMethodExpressionImpl(node);
            }
            if (type == FOR_ARRAY_EXPRESSION) {
                return new HCLForArrayExpressionImpl(node);
            }
            if (type == FOR_CONDITION) {
                return new HCLForConditionImpl(node);
            }
            if (type == FOR_INTRO) {
                return new HCLForIntroImpl(node);
            }
            if (type == FOR_OBJECT_EXPRESSION) {
                return new HCLForObjectExpressionImpl(node);
            }
            if (type == HEREDOC_CONTENT) {
                return new HCLHeredocContentImpl(node);
            }
            if (type == HEREDOC_LITERAL) {
                return new HCLHeredocLiteralImpl(node);
            }
            if (type == HEREDOC_MARKER) {
                return new HCLHeredocMarkerImpl(node);
            }
            if (type == IDENTIFIER) {
                return new HCLIdentifierImpl(node);
            }
            if (type == INDEX_SELECT_EXPRESSION) {
                return new HCLIndexSelectExpressionImpl(node);
            }
            if (type == METHOD_CALL_EXPRESSION) {
                return new HCLMethodCallExpressionImpl(node);
            }
            if (type == NULL_LITERAL) {
                return new HCLNullLiteralImpl(node);
            }
            if (type == NUMBER_LITERAL) {
                return new HCLNumberLiteralImpl(node);
            }
            if (type == OBJECT) {
                return new HCLObjectImpl(node);
            }
            if (type == PARAMETER_LIST) {
                return new HCLParameterListImpl(node);
            }
            if (type == PARENTHESIZED_EXPRESSION) {
                return new HCLParenthesizedExpressionImpl(node);
            }
            if (type == PROPERTY) {
                return new HCLPropertyImpl(node);
            }
            if (type == SELECT_EXPRESSION) {
                return new HCLSelectExpressionImpl(node);
            }
            if (type == STRING_LITERAL) {
                return new HCLStringLiteralImpl(node);
            }
            if (type == UNARY_EXPRESSION) {
                return new HCLUnaryExpressionImpl(node);
            }
            if (type == VARIABLE) {
                return new HCLVariableImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

