/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLElementType;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.HCLParser;
import org.intellij.terraform.hcl.HCLParserDefinitionKt;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.psi.impl.HCLFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0015H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/intellij/terraform/hcl/HCLParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/NotNull;", "fileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "intellij.terraform"})
public class HCLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Lexer)HCLParserDefinitionKt.createHclLexer();
    }

    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new HCLParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return HCLParserDefinitionKt.access$getFILE();
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return HCLTokenTypes.HCL_COMMENTARIES;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return HCLTokenTypes.STRING_LITERALS;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (type instanceof HCLElementType) {
            PsiElement psiElement = HCLElementTypes.Factory.createElement(node);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
            return psiElement;
        }
        return (PsiElement)new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkNotNullParameter((Object)fileViewProvider, (String)"fileViewProvider");
        return new HCLFileImpl(fileViewProvider, HCLLanguage.INSTANCE);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@Nullable ASTNode left, @Nullable ASTNode right) {
        ASTNode aSTNode = left;
        if (HCLTokenTypes.HCL_LINE_COMMENTS.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

