/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.codeinsight;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralMixin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/hcl/codeinsight/AddClosingQuoteQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "element", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Companion", "intellij.terraform"})
public final class AddClosingQuoteQuickFix
extends PsiUpdateModCommandAction<HCLStringLiteral> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public AddClosingQuoteQuickFix(@NotNull HCLStringLiteral element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        String string = HCLBundle.message("hcl.literal.inspection.add.closing.quote.quick.fix.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull HCLStringLiteral element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        String rawText = element.getText();
        if (!(element instanceof HCLStringLiteralMixin)) {
            String[] stringArray = new String[]{rawText, element.getParent().getText()};
            LOG.error("Quick fix was applied to unexpected element", stringArray);
            return;
        }
        Intrinsics.checkNotNull((Object)rawText);
        if (((CharSequence)rawText).length() == 0) {
            String[] stringArray = new String[]{rawText, ((HCLStringLiteralMixin)element).getParent().getText()};
            LOG.error("Quick fix was applied to empty string element", stringArray);
            return;
        }
        String content = HCLPsiUtil.stripQuotes(rawText);
        char quote = ((HCLStringLiteralMixin)element).getQuoteSymbol();
        Document document = ((HCLStringLiteralMixin)element).getContainingFile().getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        Document document2 = document;
        TextRange textRange = ((HCLStringLiteralMixin)element).getTextRange();
        char c = quote;
        document2.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)(c + content + quote));
    }

    static {
        Logger logger = Logger.getInstance(AddClosingQuoteQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/terraform/hcl/codeinsight/AddClosingQuoteQuickFix$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

