/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.codeinsight;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.inspection.TfVARSIncorrectElementInspection;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLSyntaxHighlighter;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLForIntro;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.HCLValue;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/hcl/codeinsight/HCLLiteralAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "<init>", "()V", "DEBUG", "", "addBlockNameAnnotation", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "name", "", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "unifix", "Lcom/intellij/codeInsight/intention/CommonIntentionAction;", "annotate", "element", "Lcom/intellij/psi/PsiElement;", "intellij.terraform"})
public final class HCLLiteralAnnotator
implements Annotator,
DumbAware,
LightEditCompatible {
    private final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

    private final void addBlockNameAnnotation(AnnotationHolder holder, @Nls String name, TextAttributesKey textAttributes, CommonIntentionAction unifix) {
        AnnotationBuilder builder = null;
        if (this.DEBUG) {
            AnnotationBuilder annotationBuilder = holder.newAnnotation(HighlightSeverity.INFORMATION, name).textAttributes(textAttributes);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"textAttributes(...)");
            builder = annotationBuilder;
        } else {
            AnnotationBuilder annotationBuilder = holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributes);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"textAttributes(...)");
            builder = annotationBuilder;
        }
        if (unifix != null) {
            AnnotationBuilder annotationBuilder = builder.newFix(unifix).universal().registerFix();
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"registerFix(...)");
            builder = annotationBuilder;
        }
        builder.create();
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof HCLExpression && HCLPsiUtil.INSTANCE.isPropertyKey(element)) {
            if (this.DEBUG) {
                holder.newAnnotation(HighlightSeverity.INFORMATION, HCLBundle.message("hcl.literal.annotator.property.key", new Object[0])).textAttributes(HCLSyntaxHighlighter.Companion.getHCL_PROPERTY_KEY()).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(HCLSyntaxHighlighter.Companion.getHCL_PROPERTY_KEY()).create();
            }
        }
        if (element instanceof LeafPsiElement && (parent = ((LeafPsiElement)element).getParent()) instanceof HCLForIntro && (((LeafPsiElement)element).textMatches((CharSequence)"for") || ((LeafPsiElement)element).textMatches((CharSequence)"in"))) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(HCLSyntaxHighlighter.Companion.getHCL_KEYWORD()).create();
        }
        if ((element instanceof HCLStringLiteral || element instanceof HCLIdentifier) && (parent = ((HCLValue)element).getParent()) instanceof HCLBlock) {
            Object[] objectArray = ((HCLBlock)parent).getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getNameElements(...)");
            Object[] ne = objectArray;
            if (ne.length == 1 && ne[0] == element) {
                if (this.DEBUG) {
                    holder.newAnnotation(HighlightSeverity.INFORMATION, HCLBundle.message("hcl.literal.annotator.block.only.name.identifier", new Object[0])).textAttributes(HCLSyntaxHighlighter.Companion.getHCL_BLOCK_ONLY_NAME_KEY()).create();
                } else {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(HCLSyntaxHighlighter.Companion.getHCL_BLOCK_ONLY_NAME_KEY()).create();
                }
            } else {
                int n = ne.length;
                for (int i = 0; i < n; ++i) {
                    if (ne[i] != element) continue;
                    TfVARSIncorrectElementInspection.ConvertToHCLStringQuickFix fix = null;
                    fix = i != 0 && element instanceof HCLIdentifier ? new TfVARSIncorrectElementInspection.ConvertToHCLStringQuickFix(element) : null;
                    int n2 = i;
                    if (n2 == ArraysKt.getLastIndex((Object[])ne)) {
                        String string = HCLBundle.message("hcl.literal.annotator.block.name.identifier", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.addBlockNameAnnotation(holder, string, HCLSyntaxHighlighter.Companion.getHCL_BLOCK_NAME_KEY(), (CommonIntentionAction)fix);
                        break;
                    }
                    if (n2 == 0) {
                        String string = HCLBundle.message("hcl.literal.annotator.block.type.1.element", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.addBlockNameAnnotation(holder, string, HCLSyntaxHighlighter.Companion.getHCL_BLOCK_FIRST_TYPE_KEY(), null);
                        break;
                    }
                    if (n2 == 1) {
                        String string = HCLBundle.message("hcl.literal.annotator.block.type.2.element", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.addBlockNameAnnotation(holder, string, HCLSyntaxHighlighter.Companion.getHCL_BLOCK_SECOND_TYPE_KEY(), (CommonIntentionAction)fix);
                        break;
                    }
                    String string = HCLBundle.message("hcl.literal.annotator.block.type.3.element", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.addBlockNameAnnotation(holder, string, HCLSyntaxHighlighter.Companion.getHCL_BLOCK_OTHER_TYPES_KEY(), (CommonIntentionAction)fix);
                    break;
                }
            }
        }
    }
}

