/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.editor;

import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataMap;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0014R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/hcl/editor/HCLNavBarExtension;", "Lcom/intellij/ide/navigationToolbar/StructureAwareNavBarModelExtension;", "<init>", "()V", "getLeafElement", "Lcom/intellij/psi/PsiElement;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataMap;", "getIcon", "Ljavax/swing/Icon;", "e", "", "getPresentableText", "", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "isAcceptableLanguage", "", "psiElement", "intellij.terraform"})
public final class HCLNavBarExtension
extends StructureAwareNavBarModelExtension {
    @Nullable
    public PsiElement getLeafElement(@NotNull DataMap dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        PsiElement leafElement = super.getLeafElement(dataProvider);
        if (leafElement instanceof HCLObject) {
            return ((HCLObject)leafElement).getParent();
        }
        return leafElement;
    }

    @Nullable
    public Icon getIcon(@Nullable Object e) {
        if (e instanceof HCLBlock || e instanceof HCLProperty) {
            HCLElement hclElement = (HCLElement)e;
            ItemPresentation itemPresentation = hclElement.getPresentation();
            return itemPresentation != null ? itemPresentation.getIcon(false) : null;
        }
        return null;
    }

    @Nullable
    public String getPresentableText(@Nullable Object e) {
        if (e instanceof HCLBlock || e instanceof HCLProperty) {
            HCLElement hclElement = (HCLElement)e;
            ItemPresentation itemPresentation = hclElement.getPresentation();
            return itemPresentation != null ? itemPresentation.getPresentableText() : null;
        }
        return null;
    }

    @NotNull
    protected Language getLanguage() {
        return HCLLanguage.INSTANCE;
    }

    protected boolean isAcceptableLanguage(@Nullable PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null || (psiElement2 = psiElement2.getLanguage()) == null) {
            return false;
        }
        PsiElement lang = psiElement2;
        return lang instanceof HCLLanguage || lang instanceof TerraformLanguage;
    }
}

