/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.formatter.HCLBlock;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/hcl/formatter/HCLFormattingBuilderModel;", "Lcom/intellij/formatting/FormattingModelBuilder;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "createModel", "Lcom/intellij/formatting/FormattingModel;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "createSpacingBuilder", "Lcom/intellij/formatting/SpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getRangeAffectingIndent", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "elementAtOffset", "Lcom/intellij/lang/ASTNode;", "intellij.terraform"})
public class HCLFormattingBuilderModel
implements FormattingModelBuilder {
    @NotNull
    private final Language language;

    public HCLFormattingBuilderModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    public /* synthetic */ HCLFormattingBuilderModel(Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            language = HCLLanguage.INSTANCE;
        }
        this(language);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        SpacingBuilder builder = this.createSpacingBuilder(settings);
        ASTNode aSTNode = formattingContext.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        Indent indent = Indent.getNoneIndent();
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HCLBlock block = new HCLBlock(null, aSTNode, null, null, builder, indent, (HclCodeStyleSettings)customCodeStyleSettings, null, 128, null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)formattingContext.getContainingFile(), (Block)((Block)block), (CodeStyleSettings)settings);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"createFormattingModelForPsiFile(...)");
        return formattingModel;
    }

    private final SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings(this.language);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        int spacesBeforeComma = commonSettings.SPACE_BEFORE_COMMA ? 1 : 0;
        int spacesAroundAssignment = commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
        SpacingBuilder spacingBuilder = new SpacingBuilder(settings, this.language).after(HCLElementTypes.HEREDOC_LITERAL).lineBreakInCode().before(HCLElementTypes.EQUALS).spacing(spacesAroundAssignment, spacesAroundAssignment, 0, false, 0).after(HCLElementTypes.EQUALS).spacing(spacesAroundAssignment, spacesAroundAssignment, 0, false, 0).afterInside(HCLElementTypes.IDENTIFIER, HCLElementTypes.BLOCK).spaces(1).afterInside(HCLElementTypes.STRING_LITERAL, HCLElementTypes.BLOCK).spaces(1).between(HCLElementTypes.L_CURLY, HCLElementTypes.R_CURLY).none().withinPairInside(HCLElementTypes.L_CURLY, HCLElementTypes.R_CURLY, HCLElementTypes.OBJECT).parentDependentLFSpacing(1, 0, commonSettings.KEEP_LINE_BREAKS, commonSettings.KEEP_BLANK_LINES_IN_CODE).withinPairInside(HCLElementTypes.L_CURLY, HCLElementTypes.R_CURLY, HCLElementTypes.BLOCK_OBJECT).parentDependentLFSpacing(1, 0, commonSettings.KEEP_LINE_BREAKS, commonSettings.KEEP_BLANK_LINES_IN_CODE).withinPair(HCLElementTypes.L_BRACKET, HCLElementTypes.R_BRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS, true).withinPair(HCLElementTypes.L_CURLY, HCLElementTypes.R_CURLY).spaceIf(commonSettings.SPACE_WITHIN_BRACES, true).before(HCLElementTypes.COMMA).spacing(spacesBeforeComma, spacesBeforeComma, 0, false, 0).after(HCLElementTypes.COMMA).spaceIf(commonSettings.SPACE_AFTER_COMMA).before(HCLElementTypes.OP_COLON).spaceIf(commonSettings.SPACE_BEFORE_COLON).after(HCLElementTypes.OP_COLON).spaceIf(commonSettings.SPACE_AFTER_COLON).after(HCLElementTypes.BLOCK).lineBreakInCode().before(HCLElementTypes.PARAMETER_LIST).none().before(HCLElementTypes.OP_ELLIPSIS).none().before(HCLElementTypes.OP_DOT).none().after(HCLElementTypes.OP_DOT).none().after(HCLElementTypes.OP_NOT).none().around(HCLElementTypes.L_CURLY).spaces(1).around(HCLElementTypes.R_CURLY).spaces(1).around(HCLElementTypes.OP_MAPPING).spaces(1).withinPair(HCLElementTypes.L_PAREN, HCLElementTypes.R_PAREN).none().around(HCLElementTypes.OP_QUEST).spaces(1);
        Intrinsics.checkNotNullExpressionValue((Object)spacingBuilder, (String)"spaces(...)");
        return spacingBuilder;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(@Nullable PsiFile file, int offset, @Nullable ASTNode elementAtOffset) {
        return null;
    }

    public HCLFormattingBuilderModel() {
        this(null, 1, null);
    }
}

