/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/hcl/navigation/HCLQualifiedNameProvider;", "Lcom/intellij/ide/actions/QualifiedNameProvider;", "<init>", "()V", "adjustElementToCopy", "Lcom/intellij/psi/PsiElement;", "element", "getQualifiedName", "", "qualifiedNameToElement", "fqn", "project", "Lcom/intellij/openapi/project/Project;", "insertQualifiedName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLQualifiedNameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLQualifiedNameProvider.kt\norg/intellij/terraform/hcl/navigation/HCLQualifiedNameProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class HCLQualifiedNameProvider
implements QualifiedNameProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement it = psiElement = element;
        boolean bl = false;
        return it instanceof HCLElement ? psiElement : null;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Companion.getQualifiedName(element);
    }

    @Nullable
    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)fqn);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/hcl/navigation/HCLQualifiedNameProvider$Companion;", "", "<init>", "()V", "getQualifiedName", "", "element", "Lcom/intellij/psi/PsiElement;", "getQualifiedModelName", "getFQN", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getModelFQN", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getQualifiedName(@Nullable PsiElement element) {
            if (!(element instanceof HCLElement)) {
                return null;
            }
            if (element instanceof HCLBlock) {
                return this.getFQN((HCLBlock)element);
            }
            if (element instanceof HCLProperty) {
                // empty if block
            }
            return null;
        }

        @Nullable
        public final String getQualifiedModelName(@Nullable PsiElement element) {
            if (!(element instanceof HCLElement)) {
                return null;
            }
            if (element instanceof HCLBlock) {
                return this.getModelFQN((HCLBlock)element);
            }
            if (element instanceof HCLProperty) {
                PsiElement parent = ((HCLProperty)element).getParent();
                if (parent instanceof HCLBlock) {
                    String pName = this.getQualifiedModelName(parent);
                    if (pName != null) {
                        return pName + "." + ((HCLProperty)element).getName();
                    }
                } else if (parent instanceof HCLObject && ((HCLObject)parent).getParent() instanceof HCLBlock) {
                    String pName = this.getQualifiedModelName(((HCLObject)parent).getParent());
                    if (pName != null) {
                        return pName + "." + ((HCLProperty)element).getName();
                    }
                } else {
                    return ((HCLProperty)element).getName();
                }
            }
            return null;
        }

        @Nullable
        public final String getFQN(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            HCLElement[] hCLElementArray = block.getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
            List elements = ArraysKt.asList((Object[])hCLElementArray);
            if (TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)block)) {
                elements = CollectionsKt.drop((Iterable)elements, (int)1);
            } else if (!(block.getParent() instanceof HCLFile)) {
                // empty if block
            }
            StringBuilder sb = new StringBuilder();
            CollectionsKt.joinTo$default((Iterable)elements, (Appendable)sb, (CharSequence)".", null, null, (int)0, null, Companion::getFQN$lambda$0, (int)60, null);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String result2 = string;
            if (((CharSequence)result2).length() == 0) {
                return null;
            }
            return result2;
        }

        private final String getModelFQN(HCLBlock block) {
            HCLElement[] hCLElementArray = block.getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
            List elements = ArraysKt.asList((Object[])hCLElementArray);
            PsiElement parent = block.getParent();
            String prefix = null;
            if (TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)block) || TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)block)) {
                elements = CollectionsKt.dropLast((List)elements, (int)1);
            } else if (!(parent instanceof HCLFile) && parent instanceof HCLObject && ((HCLObject)parent).getParent() instanceof HCLBlock) {
                prefix = this.getQualifiedModelName(((HCLObject)parent).getParent());
            }
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix).append('.');
            }
            CollectionsKt.joinTo$default((Iterable)elements, (Appendable)sb, (CharSequence)".", null, null, (int)0, null, Companion::getModelFQN$lambda$0, (int)60, null);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String result2 = string;
            if (((CharSequence)result2).length() == 0) {
                return null;
            }
            return result2;
        }

        private static final CharSequence getFQN$lambda$0(HCLElement it) {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = StringUtil.unescapeStringCharacters((String)HCLPsiUtil.stripQuotes(string));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeStringCharacters(...)");
            return string2;
        }

        private static final CharSequence getModelFQN$lambda$0(HCLElement it) {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = StringUtil.unescapeStringCharacters((String)HCLPsiUtil.stripQuotes(string));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeStringCharacters(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

