/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.patterns.HCLPatterns;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLSelectExpression;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.HCLValue;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.ProviderDefinedFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\bR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\rR\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\rR\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\bR\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\b\u00a8\u00065"}, d2={"Lorg/intellij/terraform/hcl/patterns/HCLPatterns;", "", "<init>", "()V", "Nothing", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "getNothing", "()Lcom/intellij/patterns/ElementPattern;", "WhiteSpace", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiWhiteSpace;", "getWhiteSpace", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "AtLeastOneEOL", "getAtLeastOneEOL", "Identifier", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "getIdentifier", "Literal", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getLiteral", "File", "Lorg/intellij/terraform/hcl/psi/HCLFile;", "getFile", "Block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getBlock", "Property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "getProperty", "Object", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "getObject", "Array", "Lorg/intellij/terraform/hcl/psi/HCLArray;", "getArray", "SelectExpression", "Lorg/intellij/terraform/hcl/psi/HCLSelectExpression;", "getSelectExpression", "IdentifierOrStringLiteral", "Lorg/intellij/terraform/hcl/psi/HCLValue;", "getIdentifierOrStringLiteral", "IdentifierOrStringLiteralOrSimple", "getIdentifierOrStringLiteralOrSimple", "BlockTypeIdentifierLiteral", "getBlockTypeIdentifierLiteral", "ProviderDefinedFunction", "getProviderDefinedFunction", "FileOrBlock", "getFileOrBlock", "PropertyOrBlock", "getPropertyOrBlock", "intellij.terraform"})
public final class HCLPatterns {
    @NotNull
    public static final HCLPatterns INSTANCE = new HCLPatterns();
    @NotNull
    private static final ElementPattern<PsiElement> Nothing;
    @NotNull
    private static final PsiElementPattern.Capture<PsiWhiteSpace> WhiteSpace;
    @NotNull
    private static final PsiElementPattern.Capture<PsiWhiteSpace> AtLeastOneEOL;
    @NotNull
    private static final PsiElementPattern.Capture<HCLIdentifier> Identifier;
    @NotNull
    private static final PsiElementPattern.Capture<HCLStringLiteral> Literal;
    @NotNull
    private static final PsiElementPattern.Capture<HCLFile> File;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> Block;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> Property;
    @NotNull
    private static final PsiElementPattern.Capture<HCLObject> Object;
    @NotNull
    private static final PsiElementPattern.Capture<HCLArray> Array;
    @NotNull
    private static final PsiElementPattern.Capture<HCLSelectExpression> SelectExpression;
    @NotNull
    private static final ElementPattern<HCLValue> IdentifierOrStringLiteral;
    @NotNull
    private static final ElementPattern<PsiElement> IdentifierOrStringLiteralOrSimple;
    @NotNull
    private static final PsiElementPattern.Capture<HCLStringLiteral> BlockTypeIdentifierLiteral;
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> ProviderDefinedFunction;
    @NotNull
    private static final ElementPattern<PsiElement> FileOrBlock;
    @NotNull
    private static final ElementPattern<PsiElement> PropertyOrBlock;

    private HCLPatterns() {
    }

    @NotNull
    public final ElementPattern<PsiElement> getNothing() {
        return Nothing;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiWhiteSpace> getWhiteSpace() {
        return WhiteSpace;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiWhiteSpace> getAtLeastOneEOL() {
        return AtLeastOneEOL;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLIdentifier> getIdentifier() {
        return Identifier;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLStringLiteral> getLiteral() {
        return Literal;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLFile> getFile() {
        return File;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getBlock() {
        return Block;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getProperty() {
        return Property;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLObject> getObject() {
        return Object;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLArray> getArray() {
        return Array;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLSelectExpression> getSelectExpression() {
        return SelectExpression;
    }

    @NotNull
    public final ElementPattern<HCLValue> getIdentifierOrStringLiteral() {
        return IdentifierOrStringLiteral;
    }

    @NotNull
    public final ElementPattern<PsiElement> getIdentifierOrStringLiteralOrSimple() {
        return IdentifierOrStringLiteralOrSimple;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLStringLiteral> getBlockTypeIdentifierLiteral() {
        return BlockTypeIdentifierLiteral;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiElement> getProviderDefinedFunction() {
        return ProviderDefinedFunction;
    }

    @NotNull
    public final ElementPattern<PsiElement> getFileOrBlock() {
        return FileOrBlock;
    }

    @NotNull
    public final ElementPattern<PsiElement> getPropertyOrBlock() {
        return PropertyOrBlock;
    }

    static {
        ElementPattern elementPattern = StandardPatterns.alwaysFalse();
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"alwaysFalse(...)");
        Nothing = elementPattern;
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(PsiWhiteSpace.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiElement(...)");
        WhiteSpace = capture;
        PsiElementPattern psiElementPattern = PlatformPatterns.psiElement(PsiWhiteSpace.class).withText((ElementPattern)StandardPatterns.string().contains("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern, (String)"withText(...)");
        AtLeastOneEOL = (PsiElementPattern.Capture)psiElementPattern;
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement(HCLIdentifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        Identifier = capture2;
        PsiElementPattern.Capture capture3 = PlatformPatterns.psiElement(HCLStringLiteral.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture3, (String)"psiElement(...)");
        Literal = capture3;
        PsiElementPattern.Capture capture4 = PlatformPatterns.psiElement(HCLFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture4, (String)"psiElement(...)");
        File = capture4;
        PsiElementPattern.Capture capture5 = PlatformPatterns.psiElement(HCLBlock.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture5, (String)"psiElement(...)");
        Block = capture5;
        PsiElementPattern.Capture capture6 = PlatformPatterns.psiElement(HCLProperty.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture6, (String)"psiElement(...)");
        Property = capture6;
        PsiElementPattern.Capture capture7 = PlatformPatterns.psiElement(HCLObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture7, (String)"psiElement(...)");
        Object = capture7;
        PsiElementPattern.Capture capture8 = PlatformPatterns.psiElement(HCLArray.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture8, (String)"psiElement(...)");
        Array = capture8;
        PsiElementPattern.Capture capture9 = PlatformPatterns.psiElement(HCLSelectExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture9, (String)"psiElement(...)");
        SelectExpression = capture9;
        ElementPattern[] elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = Identifier;
        elementPatternArray[1] = Literal;
        ElementPattern elementPattern2 = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern2, (String)"or(...)");
        IdentifierOrStringLiteral = elementPattern2;
        elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = IdentifierOrStringLiteral;
        elementPatternArray[1] = PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS);
        ElementPattern elementPattern3 = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern3, (String)"or(...)");
        IdentifierOrStringLiteralOrSimple = elementPattern3;
        ObjectPattern objectPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLStringLiteral.class).withParent((ElementPattern)Block)).with((PatternCondition)new PatternCondition<HCLStringLiteral>(){

            /*
             * WARNING - void declaration
             */
            public boolean accepts(HCLStringLiteral literal, ProcessingContext context) {
                Object v2;
                block1: {
                    void $this$firstOrNull$iv;
                    Sequence $this$parentsOfType$iv;
                    Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                    String[] stringArray = new String[]{"resource", "data"};
                    Set validIdentifiers = SetsKt.setOf((Object[])stringArray);
                    stringArray = (String[])literal;
                    boolean withSelf$iv = true;
                    boolean $i$f$parentsOfType = false;
                    $this$parentsOfType$iv = SequencesKt.filter((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, HCLBlock.class, (boolean)withSelf$iv), arg_0 -> BlockTypeIdentifierLiteral.1.accepts$lambda$0(validIdentifiers, arg_0));
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        HCLBlock block = (HCLBlock)element$iv;
                        boolean bl = false;
                        String string = UtilKt.getNameElementUnquoted(block, 1);
                        String string2 = literal.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                        if (!Intrinsics.areEqual((Object)string, (Object)HCLPsiUtil.stripQuotes(string2))) continue;
                        v2 = element$iv;
                        break block1;
                    }
                    v2 = null;
                }
                return v2 != null;
            }

            private static final boolean accepts$lambda$0(Set $validIdentifiers, HCLBlock it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.contains((Iterable)$validIdentifiers, (Object)UtilKt.getNameElementUnquoted(it, 0));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        BlockTypeIdentifierLiteral = (PsiElementPattern.Capture)objectPattern;
        ObjectPattern objectPattern2 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiElement.class).inFile((ElementPattern)File)).with((PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(PsiElement identifier, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                PsiElement parent = identifier.getParent();
                if (!(parent instanceof ProviderDefinedFunction)) {
                    return false;
                }
                return ((ProviderDefinedFunction)parent).getFunction() == identifier;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern2, (String)"with(...)");
        ProviderDefinedFunction = (PsiElementPattern.Capture)objectPattern2;
        elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = File;
        elementPatternArray[1] = Block;
        ElementPattern elementPattern4 = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern4, (String)"or(...)");
        FileOrBlock = elementPattern4;
        elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = Property;
        elementPatternArray[1] = Block;
        ElementPattern elementPattern5 = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern5, (String)"or(...)");
        PropertyOrBlock = elementPattern5;
    }
}

