/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.HCLFileType;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLHeredocLiteral;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011J\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\tH\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\tJ2\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\b\b\u0002\u0010(\u001a\u00020\u001e2\b\b\u0002\u0010)\u001a\u00020\u001e2\b\b\u0002\u0010*\u001a\u00020+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/intellij/terraform/hcl/psi/HCLElementGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createDummyFile", "Lcom/intellij/psi/PsiFile;", "content", "", "createValue", "T", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "(Ljava/lang/String;)Lorg/intellij/terraform/hcl/psi/HCLExpression;", "createObject", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "properties", "", "createStringLiteral", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "unescapedContent", "quoteSymbol", "", "(Ljava/lang/String;Ljava/lang/Character;)Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "createProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "name", "value", "createPropertyString", "isIdentifier", "", "createBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "createIdentifier", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "createPropertyKey", "createHeredocContent", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "lines", "", "appendNewlines", "indented", "endIndent", "", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLElementGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLElementGenerator.kt\norg/intellij/terraform/hcl/psi/HCLElementGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,146:1\n126#2:147\n153#2,3:148\n*S KotlinDebug\n*F\n+ 1 HCLElementGenerator.kt\norg/intellij/terraform/hcl/psi/HCLElementGenerator\n*L\n59#1:147\n59#1:148,3\n*E\n"})
public class HCLElementGenerator {
    @NotNull
    private final Project project;

    public HCLElementGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.project);
        PsiFile psiFile = psiFileFactory.createFileFromText("dummy." + HCLFileType.INSTANCE.getDefaultExtension(), (FileType)HCLFileType.INSTANCE, (CharSequence)content);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        PsiFile psiFile2 = psiFile;
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)psiFile2))) {
            throw new IllegalStateException("PsiFile contains PsiErrorElement: " + DebugUtil.psiToString((PsiElement)((PsiElement)psiFile2), (boolean)true, (boolean)true) + "\n---\nError content: " + content);
        }
        return psiFile2;
    }

    @NotNull
    public final <T extends HCLExpression> T createValue(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        HCLProperty property = this.createProperty("foo", content);
        HCLExpression hCLExpression = property.getValue();
        Intrinsics.checkNotNull((Object)hCLExpression, (String)"null cannot be cast to non-null type T of org.intellij.terraform.hcl.psi.HCLElementGenerator.createValue");
        return (T)hCLExpression;
    }

    @NotNull
    public final HCLObject createObject(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiFile file = this.createDummyFile("foo {\n" + content + "\n}");
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        HCLBlock block = (HCLBlock)psiElement;
        HCLObject hCLObject = block.getObject();
        Intrinsics.checkNotNull((Object)hCLObject);
        return hCLObject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HCLObject createObject(@NotNull Map<String, String> properties) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Map<String, String> $this$map$iv = properties;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(this.createPropertyString(name, value));
        }
        String propertiesString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return this.createObject(propertiesString);
    }

    public static /* synthetic */ HCLObject createObject$default(HCLElementGenerator hCLElementGenerator, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createObject");
        }
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return hCLElementGenerator.createObject(map);
    }

    @NotNull
    public final HCLStringLiteral createStringLiteral(@NotNull String unescapedContent, @Nullable Character quoteSymbol) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)unescapedContent, (String)"unescapedContent");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        HCLElementGenerator hCLElementGenerator = this;
        boolean bl = false;
        if (quoteSymbol == null) {
            if (unescapedContent.length() < 2) {
                throw new IllegalArgumentException();
            }
            $this$createStringLiteral_u24lambda_u240.append(StringsKt.first((CharSequence)unescapedContent));
            $this$createStringLiteral_u24lambda_u240.append(StringUtil.escapeStringCharacters((String)StringsKt.substring((String)unescapedContent, (IntRange)new IntRange(1, StringsKt.getLastIndex((CharSequence)unescapedContent) - 1))));
            v0 = $this$createStringLiteral_u24lambda_u240.append(StringsKt.last((CharSequence)unescapedContent));
        } else {
            $this$createStringLiteral_u24lambda_u240.append(quoteSymbol.charValue());
            $this$createStringLiteral_u24lambda_u240.append(StringUtil.escapeStringCharacters((String)unescapedContent));
            v0 = $this$createStringLiteral_u24lambda_u240.append(quoteSymbol.charValue());
        }
        return (HCLStringLiteral)hCLElementGenerator.createValue(stringBuilder.toString());
    }

    public static /* synthetic */ HCLStringLiteral createStringLiteral$default(HCLElementGenerator hCLElementGenerator, String string, Character c, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createStringLiteral");
        }
        if ((n & 2) != 0) {
            c = Character.valueOf('\"');
        }
        return hCLElementGenerator.createStringLiteral(string, c);
    }

    @NotNull
    public final HCLProperty createProperty(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String s = this.createPropertyString(name, value);
        PsiFile file = this.createDummyFile(s);
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
        return (HCLProperty)psiElement;
    }

    @NotNull
    public final String createPropertyString(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String s = null;
        s = !this.isIdentifier(name) ? "\"" + name + "\" = " + value : name + " = " + value;
        return s;
    }

    protected final boolean isIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        return new Regex("\\w+").matches(charSequence) && !Character.isDigit(name.charAt(0));
    }

    @NotNull
    public final HCLBlock createBlock(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.isIdentifier(name)) {
            char c = '\"';
            object = c + name + "\"";
        } else {
            object = name;
        }
        String start = object;
        PsiFile file = this.createDummyFile(start + " {}");
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        return (HCLBlock)psiElement;
    }

    @NotNull
    public final HCLIdentifier createIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile file = this.createDummyFile(name + "=true");
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
        HCLProperty property = (HCLProperty)psiElement;
        HCLExpression hCLExpression = property.getNameElement();
        Intrinsics.checkNotNull((Object)hCLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLIdentifier");
        return (HCLIdentifier)hCLExpression;
    }

    @NotNull
    public final HCLExpression createPropertyKey(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile file = this.createDummyFile("x={" + name + "=true}");
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
        HCLExpression hCLExpression = ((HCLProperty)psiElement).getValue();
        Intrinsics.checkNotNull((Object)hCLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLObject");
        HCLObject obj = (HCLObject)hCLExpression;
        PsiElement psiElement2 = obj.getFirstChild().getNextSibling();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
        HCLProperty property = (HCLProperty)psiElement2;
        HCLExpression hCLExpression2 = property.getNameElement();
        Intrinsics.checkNotNullExpressionValue((Object)hCLExpression2, (String)"getNameElement(...)");
        return hCLExpression2;
    }

    @NotNull
    public final HCLHeredocContent createHeredocContent(@NotNull List<String> lines, boolean appendNewlines, boolean indented, int endIndent) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        StringBuilder $this$createHeredocContent_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createHeredocContent_u24lambda_u240.append("x=<<");
        if (indented) {
            $this$createHeredocContent_u24lambda_u240.append('-');
        }
        $this$createHeredocContent_u24lambda_u240.append("___EOF___\n");
        for (String l : lines) {
            $this$createHeredocContent_u24lambda_u240.append(l);
            if (!appendNewlines || StringsKt.endsWith$default((CharSequence)l, (char)'\n', (boolean)false, (int)2, null)) continue;
            $this$createHeredocContent_u24lambda_u240.append('\n');
        }
        $this$createHeredocContent_u24lambda_u240.append(StringsKt.repeat((CharSequence)" ", (int)endIndent));
        $this$createHeredocContent_u24lambda_u240.append("___EOF___");
        String text = stringBuilder.toString();
        PsiFile file = this.createDummyFile(text);
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
        HCLProperty property = (HCLProperty)psiElement;
        HCLExpression hCLExpression = property.getValue();
        Intrinsics.checkNotNull((Object)hCLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLHeredocLiteral");
        HCLHeredocContent hCLHeredocContent = ((HCLHeredocLiteral)hCLExpression).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)hCLHeredocContent, (String)"getContent(...)");
        return hCLHeredocContent;
    }

    public static /* synthetic */ HCLHeredocContent createHeredocContent$default(HCLElementGenerator hCLElementGenerator, List list, boolean bl, boolean bl2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createHeredocContent");
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return hCLElementGenerator.createHeredocContent(list, bl, bl2, n);
    }
}

