/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLHeredocContentManipulatorKt;
import org.intellij.terraform.hcl.psi.impl.HCLHeredocContentMixin;
import org.intellij.terraform.hcl.psi.impl.HCLPsiImplUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "<init>", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "newContent", "", "check", "", "replaceStupidly", "getRangeInElement", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLHeredocContentManipulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLHeredocContentManipulator.kt\norg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n774#2:215\n865#2,2:216\n1#3:218\n*S KotlinDebug\n*F\n+ 1 HCLHeredocContentManipulator.kt\norg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator\n*L\n38#1:211\n38#1:212,3\n44#1:215\n44#1:216,2\n*E\n"})
public final class HCLHeredocContentManipulator
extends AbstractElementManipulator<HCLHeredocContent> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HCLHeredocContent handleContentChange(@NotNull HCLHeredocContent element, @NotNull TextRange range, @NotNull String newContent) throws IncorrectOperationException {
        boolean bl;
        ASTNode aSTNode;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        if (range.getLength() == 0 && element.getLinesCount() == 0) {
            return this.replaceStupidly(element, newContent);
        }
        int offset = 0;
        List<String> lines = HCLPsiImplUtils.INSTANCE.getLinesWithEOL(element);
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TextRange r;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.from((int)offset, (int)it.length()), (String)"from(...)");
            offset += it.length();
            collection.add(r);
        }
        List ranges = (List)destination$iv$iv;
        Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)ranges);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl3 = false;
            if (!((TextRange)ranges.get(it)).intersects(range)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List linesToChange = (List)destination$iv$iv2;
        boolean bl4 = $this$filter$iv = !((Collection)linesToChange).isEmpty();
        if (_Assertions.ENABLED && !$this$filter$iv) {
            String $i$f$filter2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$filter2);
        }
        int startString = ((Number)CollectionsKt.first((List)linesToChange)).intValue();
        int endString = ((Number)CollectionsKt.last((List)linesToChange)).intValue();
        ASTNode aSTNode2 = element.getNode();
        Intrinsics.checkNotNull((Object)aSTNode2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.TreeElement");
        TreeElement node = (TreeElement)aSTNode2;
        String string = lines.get(startString).substring(0, range.getStartOffset() - ((TextRange)ranges.get(startString)).getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefixStartString = string;
        String string2 = lines.get(endString).substring(range.getEndOffset() - ((TextRange)ranges.get(endString)).getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String suffixEndString = string2;
        String newText = prefixStartString + newContent + suffixEndString;
        List<Pair<String, Boolean>> newLines = Companion.getReplacementLines(newText);
        if (!((Collection)newLines).isEmpty() && !((Boolean)((Pair)CollectionsKt.last(newLines)).getSecond()).booleanValue() && (element.getTextLength() != range.getEndOffset() || StringsKt.endsWith$default((String)newText, (String)"\n", (boolean)false, (int)2, null))) {
            throw new IllegalStateException("Last line should have line separator. New text: '" + newText + "'\nNew lines:" + newLines);
        }
        ASTNode aSTNode3 = HCLHeredocContentManipulator.Companion.lookupLine(node, endString);
        if (aSTNode3 != null) {
            ASTNode it = aSTNode3;
            boolean bl5 = false;
            aSTNode = HCLHeredocContentManipulator.Companion.nextLine(it);
        } else {
            aSTNode = null;
        }
        ASTNode stopNode = aSTNode;
        ASTNode iter = HCLHeredocContentManipulator.Companion.lookupLine(node, startString);
        Iterator<Pair<String, Boolean>> iterator = newLines.iterator();
        while (iterator.hasNext()) {
            boolean bl6;
            String line = (String)iterator.next().component1();
            if (iter != null && !Intrinsics.areEqual((Object)iter, (Object)stopNode)) {
                ASTNode next = HCLHeredocContentManipulator.Companion.nextLine(iter);
                if (HCLHeredocContentManipulatorKt.isHD_EOL(iter)) {
                    if (!(((CharSequence)line).length() == 0)) {
                        node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, iter);
                    }
                } else {
                    bl6 = Intrinsics.areEqual((Object)iter.getElementType(), (Object)HCLElementTypes.HD_LINE);
                    if (_Assertions.ENABLED && !bl6) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    if (((CharSequence)line).length() == 0) {
                        node.removeChild(iter);
                    } else if (!Intrinsics.areEqual((Object)iter.getText(), (Object)line)) {
                        ((LeafElement)iter).replaceWithText(line);
                    }
                }
                iter = next;
                continue;
            }
            if (iter == null) {
                ASTNode lcn = element.getNode().getLastChildNode();
                if (lcn != null) {
                    if (HCLHeredocContentManipulatorKt.isHD_EOL(lcn)) {
                        node.addLeaf(HCLElementTypes.HD_EOL, (CharSequence)"\n", lcn);
                        node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, lcn);
                        continue;
                    }
                    if (!_Assertions.ENABLED) continue;
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, null);
                node.addLeaf(HCLElementTypes.HD_EOL, (CharSequence)"\n", null);
                continue;
            }
            if (stopNode != null) {
                ASTNode sNP = stopNode.getTreePrev();
                if (sNP == null) {
                    node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, stopNode);
                    node.addLeaf(HCLElementTypes.HD_EOL, (CharSequence)"\n", stopNode);
                    continue;
                }
                bl6 = HCLHeredocContentManipulatorKt.isHD_EOL(sNP);
                if (_Assertions.ENABLED && !bl6) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                node.addLeaf(HCLElementTypes.HD_EOL, (CharSequence)"\n", sNP);
                node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, sNP);
                continue;
            }
            if (!_Assertions.ENABLED) continue;
            String string6 = "Assertion failed";
            throw new AssertionError((Object)string6);
        }
        if (iter != null && !Intrinsics.areEqual((Object)iter, (Object)stopNode)) {
            ASTNode iTP = iter.getTreePrev();
            if (iTP != null && HCLHeredocContentManipulatorKt.isHD_EOL(iTP)) {
                if (stopNode == null) {
                    node.removeRange(iTP, (ASTNode)node.getLastChildNode());
                } else {
                    node.removeRange(iTP, stopNode.getTreePrev());
                }
            } else {
                node.removeRange(iter, stopNode);
            }
        }
        TreeElement treeElement = node.getLastChildNode();
        boolean bl7 = bl = treeElement != null ? HCLHeredocContentManipulatorKt.isHD_EOL((ASTNode)treeElement) : true;
        if (_Assertions.ENABLED && !bl) {
            String string7 = "Assertion failed";
            throw new AssertionError((Object)string7);
        }
        this.check(element);
        return element;
    }

    private final void check(HCLHeredocContent element) {
        ASTNode node = element.getNode();
        IElementType[] iElementTypeArray = new IElementType[]{HCLElementTypes.HD_LINE};
        ASTNode[] aSTNodeArray = node.getChildren(TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        for (ASTNode line : aSTNodeArray) {
            ASTNode aSTNode = line.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeNext(...)");
            boolean bl = HCLHeredocContentManipulatorKt.isHD_EOL(aSTNode);
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl2 = false;
            String string = "Line HD_LINE (" + line.getText() + ") should be terminated with HD_EOL";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public HCLHeredocContent handleContentChange(@NotNull HCLHeredocContent element, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        if (element instanceof HCLHeredocContentMixin) {
            TextRange textRange = TextRange.from((int)0, (int)((HCLHeredocContentMixin)element).getTextLength());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
            return this.handleContentChange(element, textRange, newContent);
        }
        return this.replaceStupidly(element, newContent);
    }

    private final HCLHeredocContent replaceStupidly(HCLHeredocContent element, String newContent) {
        List<Pair<String, Boolean>> newLines = Companion.getReplacementLines(newContent);
        ASTNode node = element.getNode();
        if (node.getFirstChildNode() != null) {
            node.removeRange(node.getFirstChildNode(), null);
        }
        Iterator<Pair<String, Boolean>> iterator = newLines.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next().component1();
            if (((CharSequence)line).length() > 0) {
                node.addLeaf(HCLElementTypes.HD_LINE, (CharSequence)line, null);
            }
            node.addLeaf(HCLElementTypes.HD_EOL, (CharSequence)"\n", null);
        }
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull HCLHeredocContent element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getTextLength() == 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
        TextRange textRange = TextRange.from((int)0, (int)(element.getTextLength() - 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        return textRange;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator$Companion;", "", "<init>", "()V", "getReplacementLines", "", "Lkotlin/Pair;", "", "", "newText", "lookupLine", "Lcom/intellij/lang/ASTNode;", "node", "Lcom/intellij/psi/impl/source/tree/TreeElement;", "n", "", "nextLine", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHCLHeredocContentManipulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLHeredocContentManipulator.kt\norg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n*S KotlinDebug\n*F\n+ 1 HCLHeredocContentManipulator.kt\norg/intellij/terraform/hcl/psi/HCLHeredocContentManipulator$Companion\n*L\n153#1:211\n153#1:212,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<String, Boolean>> getReplacementLines(@NotNull String newText) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            if (Intrinsics.areEqual((Object)newText, (Object)"")) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)newText);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
            Iterable $this$map$iv = ArraysKt.toList((Object[])stringArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(TuplesKt.to((Object)StringsKt.removeSuffix((String)it, (CharSequence)"\n"), (Object)StringsKt.endsWith$default((String)it, (String)"\n", (boolean)false, (int)2, null)));
            }
            return (List)destination$iv$iv;
        }

        private final ASTNode lookupLine(TreeElement node, int n) {
            int counter = 0;
            for (ASTNode cn = (ASTNode)node.getFirstChildNode(); cn != null; cn = cn.getTreeNext()) {
                if (counter == n) {
                    return cn;
                }
                if (!Intrinsics.areEqual((Object)cn.getElementType(), (Object)HCLElementTypes.HD_EOL)) continue;
                ++counter;
            }
            return null;
        }

        private final ASTNode nextLine(ASTNode node) {
            if (HCLHeredocContentManipulatorKt.isHD_EOL(node)) {
                return node.getTreeNext();
            }
            ASTNode aSTNode = node.getTreeNext();
            return aSTNode != null ? aSTNode.getTreeNext() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

