/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLConditionalExpression;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLForObjectExpression;
import org.intellij.terraform.hcl.psi.HCLNumberLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLParameterList;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.common.Identifier;
import org.intellij.terraform.hcl.psi.common.IndexSelectExpression;
import org.intellij.terraform.hcl.psi.common.SelectExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0007J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eJ\u001d\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001d\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001e\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001f\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\f\u0010 \u001a\u0004\u0018\u00010!*\u00020\u0005J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0007J\u000e\u0010#\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0007\u00a8\u0006$"}, d2={"Lorg/intellij/terraform/hcl/psi/HCLPsiUtil;", "", "<init>", "()V", "getIdentifierPsi", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "isPropertyKey", "", "isPartOfPropertyKey", "isBlockNameElement", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "ordinal", "", "isPropertyValue", "isPartOfPropertyValue", "getElementTextWithoutHostEscaping", "", "stripQuotes", "text", "isEscapedChar", "position", "getReferencesSelectAware", "", "Lcom/intellij/psi/PsiReference;", "e", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "isUnderPropertyUnderPropertyWithObjectValue", "isUnderPropertyInsideObjectConditionalExpression", "isUnderPropertyUnderPropertyWithObjectValueAndArray", "isUnderPropertyInsideObjectArgument", "getRequiredProviderProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "getPrevSiblingNonWhiteSpace", "getNextSiblingNonWhiteSpace", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLPsiUtil.kt\norg/intellij/terraform/hcl/psi/HCLPsiUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,306:1\n2443#2,5:307\n183#3,2:312\n183#3,2:314\n*S KotlinDebug\n*F\n+ 1 HCLPsiUtil.kt\norg/intellij/terraform/hcl/psi/HCLPsiUtil\n*L\n32#1:307,5\n215#1:312,2\n219#1:314,2\n*E\n"})
public final class HCLPsiUtil {
    @NotNull
    public static final HCLPsiUtil INSTANCE = new HCLPsiUtil();

    private HCLPsiUtil() {
    }

    @Nullable
    public final PsiElement getIdentifierPsi(@NotNull HCLElement element) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HCLElement hCLElement = element;
        if (hCLElement instanceof HCLProperty) {
            psiElement = ((HCLProperty)element).getFirstChild();
        } else if (hCLElement instanceof HCLBlock) {
            Object object;
            block6: {
                PsiElement[] psiElementArray = ((HCLBlock)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] $this$lastOrNull$iv = psiElementArray;
                boolean $i$f$lastOrNull = false;
                int n = $this$lastOrNull$iv.length + -1;
                if (0 <= n) {
                    do {
                        int index$iv = n--;
                        Object element$iv = $this$lastOrNull$iv[index$iv];
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof HCLObject))) continue;
                        object = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                object = null;
            }
            psiElement = (PsiElement)object;
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    public final boolean isPropertyKey(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        return parent instanceof HCLProperty && element == ((HCLProperty)parent).getNameElement();
    }

    public final boolean isPartOfPropertyKey(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HCLProperty property = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        return property != null && PsiTreeUtil.isAncestor((PsiElement)property.getNameElement(), (PsiElement)element, (boolean)false);
    }

    public final boolean isBlockNameElement(@NotNull HCLStringLiteral element, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        HCLBlock hCLBlock = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
        if (hCLBlock == null) {
            return false;
        }
        HCLBlock parent = hCLBlock;
        HCLElement[] hCLElementArray = parent.getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
        return ArraysKt.getOrNull((Object[])hCLElementArray, (int)ordinal) == element;
    }

    public final boolean isPropertyValue(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        return parent instanceof HCLProperty && element == ((HCLProperty)parent).getValue();
    }

    public final boolean isPartOfPropertyValue(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HCLProperty property = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        return property != null && PsiTreeUtil.isAncestor((PsiElement)property.getValue(), (PsiElement)element, (boolean)false);
    }

    @NotNull
    public final String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (manager.isInjectedFragment(element.getContainingFile())) {
            String string = manager.getUnescapedText(element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnescapedText(...)");
            return string;
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String stripQuotes(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() > 0) {
            char firstChar = text.charAt(0);
            char lastChar = text.charAt(text.length() - 1);
            switch (firstChar) {
                case '\"': 
                case '\'': {
                    if (text.length() > 1 && firstChar == lastChar && !INSTANCE.isEscapedChar(text, text.length() - 1)) {
                        String string = text.substring(1, text.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        return string;
                    }
                    String string = text.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
            }
        }
        return text;
    }

    public final boolean isEscapedChar(@NotNull String text, int position) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int count = 0;
        for (int i = position - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count % 2 != 0;
    }

    @NotNull
    public final PsiReference[] getReferencesSelectAware(@Nullable PsiElement e) {
        ProgressManager.checkCanceled();
        if (e == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (e instanceof SelectExpression) {
            if (e instanceof IndexSelectExpression) {
                return this.getReferencesSelectAware((PsiElement)((IndexSelectExpression)e).getFrom());
            }
            Object t = ((SelectExpression)e).getField();
            if (t == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }
            Object field = t;
            if (field instanceof HCLNumberLiteral) {
                return this.getReferencesSelectAware((PsiElement)((SelectExpression)e).getFrom());
            }
            PsiReference[] psiReferenceArray = field.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            return psiReferenceArray;
        }
        if (e instanceof HCLForObjectExpression) {
            PsiReference[] psiReferenceArray = ((HCLForObjectExpression)e).getValue().getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = e.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        return psiReferenceArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderPropertyUnderPropertyWithObjectValue(@Nullable PsiElement element) {
        HCLProperty hCLProperty = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        if (!(property.getParent() instanceof HCLObject)) return false;
        PsiElement psiElement = property.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof HCLProperty)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderPropertyInsideObjectConditionalExpression(@Nullable PsiElement element) {
        HCLProperty hCLProperty = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        if (!(property.getParent() instanceof HCLObject)) return false;
        PsiElement psiElement = property.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof HCLConditionalExpression)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderPropertyUnderPropertyWithObjectValueAndArray(@Nullable PsiElement element) {
        HCLProperty hCLProperty = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        if (!(property.getParent() instanceof HCLObject)) return false;
        PsiElement psiElement = property.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof HCLArray)) return false;
        PsiElement psiElement2 = property.getParent();
        if (!((psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : null) instanceof HCLProperty)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderPropertyInsideObjectArgument(@Nullable PsiElement element) {
        HCLProperty hCLProperty = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)element, HCLProperty.class, (boolean)true);
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        if (!(property.getParent() instanceof HCLObject)) return false;
        PsiElement psiElement = property.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof HCLParameterList)) return false;
        return true;
    }

    @Nullable
    public final HCLProperty getRequiredProviderProperty(@NotNull PsiElement $this$getRequiredProviderProperty) {
        HCLProperty hCLProperty;
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredProviderProperty, (String)"<this>");
        PsiElement psiElement = $this$getRequiredProviderProperty;
        if (psiElement instanceof HCLProperty) {
            hCLProperty = (HCLProperty)$this$getRequiredProviderProperty;
        } else if (psiElement instanceof Identifier && ((Identifier)$this$getRequiredProviderProperty).getParent() instanceof HCLProperty) {
            PsiElement psiElement2 = ((Identifier)$this$getRequiredProviderProperty).getParent();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLProperty");
            hCLProperty = (HCLProperty)psiElement2;
        } else {
            return null;
        }
        HCLProperty providerProperty = hCLProperty;
        PsiElement psiElement3 = providerProperty.getParent();
        HCLObject hCLObject = psiElement3 instanceof HCLObject ? (HCLObject)psiElement3 : null;
        if (hCLObject == null) {
            return null;
        }
        HCLObject requiredProvidersObject = hCLObject;
        PsiElement psiElement4 = requiredProvidersObject.getParent();
        HCLBlock hCLBlock = psiElement4 instanceof HCLBlock ? (HCLBlock)psiElement4 : null;
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock providerBlock = hCLBlock;
        if (!TfPsiPatterns.INSTANCE.getRequiredProvidersBlock().accepts((Object)providerBlock)) {
            return null;
        }
        return providerProperty;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getPrevSiblingNonWhiteSpace(@NotNull PsiElement $this$getPrevSiblingNonWhiteSpace) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getPrevSiblingNonWhiteSpace, (String)"<this>");
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.siblings((PsiElement)$this$getPrevSiblingNonWhiteSpace, (boolean)false, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getNextSiblingNonWhiteSpace(@NotNull PsiElement $this$getNextSiblingNonWhiteSpace) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getNextSiblingNonWhiteSpace, (String)"<this>");
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.siblings((PsiElement)$this$getNextSiblingNonWhiteSpace, (boolean)true, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

