/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLHeredocContentManipulator;
import org.intellij.terraform.hcl.psi.impl.HCLValueWithReferencesMixin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLHeredocContentMixin;", "Lorg/intellij/terraform/hcl/psi/impl/HCLValueWithReferencesMixin;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "isValidHost", "", "updateText", "text", "", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "getInnerRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.terraform"})
public abstract class HCLHeredocContentMixin
extends HCLValueWithReferencesMixin
implements PsiLanguageInjectionHost,
HCLHeredocContent {
    public HCLHeredocContentMixin(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public boolean isValidHost() {
        return true;
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        HCLHeredocContent hCLHeredocContent = new HCLHeredocContentManipulator().handleContentChange(this, text);
        Intrinsics.checkNotNull((Object)hCLHeredocContent, (String)"null cannot be cast to non-null type com.intellij.psi.PsiLanguageInjectionHost");
        return (PsiLanguageInjectionHost)hCLHeredocContent;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return (LiteralTextEscaper)new LiteralTextEscaper<HCLHeredocContentMixin>(this){

            public boolean isOneLine() {
                return false;
            }

            public boolean decode(TextRange rangeInsideHost, StringBuilder outChars) {
                Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
                Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
                outChars.append(rangeInsideHost.subSequence((CharSequence)((HCLHeredocContentMixin)this.myHost).getText()));
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, TextRange rangeInsideHost) {
                Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
                int offset = offsetInDecoded + rangeInsideHost.getStartOffset();
                if (offset < rangeInsideHost.getStartOffset()) {
                    return -1;
                }
                if (offset > rangeInsideHost.getEndOffset()) {
                    return -1;
                }
                return offset;
            }

            public TextRange getRelevantTextRange() {
                return ((HCLHeredocContentMixin)this.myHost).getInnerRange();
            }
        };
    }

    @NotNull
    public final TextRange getInnerRange() {
        if (this.getTextLength() == 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
        PsiElement lastChild = this.getLastChild();
        if (lastChild != null) {
            TextRange textRange = TextRange.create((int)0, (int)lastChild.getStartOffsetInParent());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }
        TextRange textRange = TextRange.from((int)0, (int)this.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        return textRange;
    }
}

