/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.impl.HCLLiteralImpl;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralTextEscaper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralMixin;", "Lorg/intellij/terraform/hcl/psi/impl/HCLLiteralImpl;", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "isValidHost", "", "updateText", "s", "", "changeQuotes", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "getName", "setName", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Companion", "intellij.terraform"})
public abstract class HCLStringLiteralMixin
extends HCLLiteralImpl
implements HCLStringLiteral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public HCLStringLiteralMixin(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public boolean isValidHost() {
        return true;
    }

    @NotNull
    public HCLStringLiteralMixin updateText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.updateText(s, true);
    }

    private final HCLStringLiteralMixin updateText(String s, boolean changeQuotes) {
        boolean message2;
        if (s.length() < 2) {
            String message2 = "New text '" + s + "' too short: " + s.length();
            LOG.error(message2);
            throw new IncorrectOperationException(message2);
        }
        boolean bl = message2 = s.length() >= 2;
        if (_Assertions.ENABLED && !message2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        char quote = s.charAt(0);
        if (quote != s.charAt(StringsKt.getLastIndex((CharSequence)s))) {
            String message3 = "First '" + quote + "' and last '" + StringsKt.last((CharSequence)s) + "' quotes mismatch, text: " + s;
            LOG.error(message3);
            throw new IncorrectOperationException(message3);
        }
        if (quote != '\'' && quote != '\"') {
            String message4 = "Quote symbol not ''' or '\"' : " + quote;
            LOG.error(message4);
            throw new IncorrectOperationException(message4);
        }
        StringBuilder buffer = new StringBuilder(s);
        if (quote != this.getQuoteSymbol()) {
            if (changeQuotes) {
                buffer.setCharAt(0, this.getQuoteSymbol());
                buffer.setCharAt(StringsKt.getLastIndex((CharSequence)buffer), this.getQuoteSymbol());
            } else {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                HCLElementGenerator hCLElementGenerator = new HCLElementGenerator(project);
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                PsiElement psiElement = this.replace(hCLElementGenerator.createStringLiteral(string, null));
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.impl.HCLStringLiteralMixin");
                return (HCLStringLiteralMixin)psiElement;
            }
        }
        ASTNode aSTNode = this.getNode().getFirstChildNode();
        Intrinsics.checkNotNull((Object)aSTNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafElement");
        ((LeafElement)aSTNode).replaceWithText(buffer.toString());
        return this;
    }

    @NotNull
    public LiteralTextEscaper<HCLStringLiteralMixin> createLiteralTextEscaper() {
        return new HCLStringLiteralTextEscaper(this, false, 2, null);
    }

    @Nullable
    public String getName() {
        return this.getValue();
    }

    @NotNull
    public final HCLStringLiteralMixin setName(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder buffer = new StringBuilder(s.length());
        if (Intrinsics.areEqual((Object)this.getNode().getElementType(), (Object)HCLElementTypes.SINGLE_QUOTED_STRING)) {
            buffer.append('\'');
            StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
            v0 = buffer.append('\'');
        } else {
            buffer.append('\"');
            StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
            v0 = buffer.append('\"');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.updateText(string);
    }

    @NotNull
    public SearchScope getUseScope() {
        return (SearchScope)ExtensionsKt.getTerraformSearchScope(this);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return ExtensionsKt.getTerraformSearchScope(this);
    }

    static {
        Logger logger = Logger.getInstance(HCLStringLiteralMixin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLStringLiteralMixin$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

