/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.spellchecker;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.config.spellchecker.TfSpellcheckingUtil;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLHeredocMarker;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/terraform/hcl/spellchecker/HCLSpellcheckerStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "element", "Lcom/intellij/psi/PsiElement;", "isMyContext", "", "intellij.terraform"})
public class HCLSpellcheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    @NotNull
    public Tokenizer<?> getTokenizer(@Nullable PsiElement element) {
        if (element == null) {
            Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        if (element instanceof PsiWhiteSpace) {
            Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
                return tokenizer;
            }
            if (((PsiComment)element).getTextOffset() == 0) {
                String string = ((PsiComment)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"#!", (boolean)false, (int)2, null)) {
                    Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
                    Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
                    return tokenizer;
                }
            }
            Tokenizer tokenizer = this.myCommentTokenizer;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"myCommentTokenizer");
            return tokenizer;
        }
        if (element instanceof PsiLanguageInjectionHost && InjectedLanguageManager.getInstance((Project)((PsiLanguageInjectionHost)element).getProject()).getInjectedPsiFiles(element) != null) {
            Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof HCLBlock && (element instanceof HCLIdentifier || element instanceof HCLStringLiteral) && TfPsiPatterns.INSTANCE.getRootBlockForHCLFiles().accepts((Object)parent)) {
            String type = UtilKt.getNameElementUnquoted((HCLBlock)parent, 0);
            if (element == ((HCLBlock)parent).getNameIdentifier() && CollectionsKt.contains((Iterable)TfSpellcheckingUtil.INSTANCE.getRootBlocksWithChangeableName(), (Object)type)) {
                Tokenizer tokenizer;
                if (element instanceof HCLStringLiteral) {
                    tokenizer = TfSpellcheckingUtil.INSTANCE.getStringLiteralTokenizer();
                } else {
                    Tokenizer tokenizer2 = SpellcheckingStrategy.TEXT_TOKENIZER;
                    tokenizer = tokenizer2;
                    Intrinsics.checkNotNullExpressionValue((Object)tokenizer2, (String)"TEXT_TOKENIZER");
                }
                return tokenizer;
            }
        }
        if (element instanceof HCLStringLiteral) {
            Tokenizer tokenizer;
            if (TfPsiPatterns.INSTANCE.getDescriptionProperty().accepts((Object)parent)) {
                tokenizer = TfSpellcheckingUtil.INSTANCE.getStringLiteralTokenizer();
            } else {
                Tokenizer tokenizer3 = SpellcheckingStrategy.EMPTY_TOKENIZER;
                tokenizer = tokenizer3;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer3, (String)"EMPTY_TOKENIZER");
            }
            return tokenizer;
        }
        if (element instanceof HCLHeredocContent) {
            return TfSpellcheckingUtil.INSTANCE.getHeredocContentTokenizer();
        }
        if (element instanceof HCLHeredocMarker) {
            Tokenizer tokenizer = SpellcheckingStrategy.TEXT_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"TEXT_TOKENIZER");
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        return tokenizer;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getContainingFile() instanceof HCLFile;
    }
}

