/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.hil._HILLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/hil/HILLexer;", "Lcom/intellij/lexer/FlexAdapter;", "<init>", "()V", "getFlex", "Lorg/intellij/terraform/hil/_HILLexer;", "start", "", "buffer", "", "startOffset", "", "endOffset", "state", "isLexerInStringOrHILState", "", "getState", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHILLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILLexer.kt\norg/intellij/terraform/hil/HILLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class HILLexer
extends FlexAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int STRING_START_MASK = -65536;
    private static final int IN_STRING = 16384;
    private static final int HIL_MASK = 16128;
    private static final int JFLEX_STATE_MASK = 255;

    public HILLexer() {
        super((FlexLexer)new _HILLexer());
    }

    @NotNull
    public _HILLexer getFlex() {
        FlexLexer flexLexer = super.getFlex();
        Intrinsics.checkNotNull((Object)flexLexer, (String)"null cannot be cast to non-null type org.intellij.terraform.hil._HILLexer");
        return (_HILLexer)flexLexer;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        _HILLexer lexer = this.getFlex();
        if (!this.isLexerInStringOrHILState(state) || (state & 0x4000) == 0) {
            lexer.stringStart = -1;
            lexer.hil = 0;
        } else {
            lexer.stringStart = (state & 0xFFFF0000) >>> 16;
            lexer.hil = (state & 0x3F00) >>> 8;
        }
        super.start(buffer, startOffset, endOffset, state & 0xFF);
    }

    private final boolean isLexerInStringOrHILState(int state) {
        return switch (state & 0xFF) {
            case 2 -> true;
            case 4 -> true;
            default -> false;
        };
    }

    public int getState() {
        boolean bl;
        _HILLexer lexer = this.getFlex();
        int state = super.getState();
        boolean bl2 = bl = (state & 0xFFFFFF00) == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "State outside JFLEX_STATE_MASK (255) should not be used by JFLex lexer";
            throw new AssertionError((Object)string);
        }
        state &= 0xFF;
        if (lexer.stringStart != -1) {
            state |= 0x4000;
        }
        return state |= (lexer.hil & 0x3F) << 8 & 0x3F00;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/terraform/hil/HILLexer$Companion;", "", "<init>", "()V", "STRING_START_MASK", "", "IN_STRING", "HIL_MASK", "JFLEX_STATE_MASK", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

