/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hil.HILElementType;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.HILLanguage;
import org.intellij.terraform.hil.HILLexer;
import org.intellij.terraform.hil.HILParser;
import org.intellij.terraform.hil.HILTokenType;
import org.intellij.terraform.hil.HILTokenTypes;
import org.intellij.terraform.hil.psi.ILPsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\u000b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0016H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/terraform/hil/HILParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "FILE", "Lcom/intellij/psi/tree/IFileElementType;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/NotNull;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "intellij.terraform"})
public final class HILParserDefinition
implements ParserDefinition {
    @NotNull
    private final IFileElementType FILE = new IFileElementType((Language)HILLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Lexer)new HILLexer();
    }

    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new HILParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return this.FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return HILTokenTypes.INSTANCE.getSTRING_LITERALS();
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (type instanceof HILElementType) {
            PsiElement psiElement = HILElementTypes.Factory.createElement(node);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
            return psiElement;
        }
        if (type instanceof HILTokenType) {
            PsiElement psiElement = HILElementTypes.Factory.createElement(node);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
            return psiElement;
        }
        return (PsiElement)new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new ILPsiFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@Nullable ASTNode left, @Nullable ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

