/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLMethodCallExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "ReplaceWithListIndexing", "intellij.terraform"})
public final class HCLSimplifyExpressionInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file) || Intrinsics.areEqual((Object)file.getLanguage(), (Object)HCLLanguage.INSTANCE);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitMethodCallExpression", "", "o", "Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitMethodCallExpression(@NotNull HCLMethodCallExpression o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            HCLIdentifier hCLIdentifier = o.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier, (String)"<get-method>(...)");
            HCLIdentifier method = hCLIdentifier;
            List<HCLExpression> list = o.getParameterList().getElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
            List<HCLExpression> args = list;
            if (args.size() == 2 && Intrinsics.areEqual((Object)method.getId(), (Object)"element") && this.holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceWithListIndexing(o)};
                this.holder.registerProblem((PsiElement)o, HCLBundle.message("hcl.simplify.expression.inspection.could.be.replaced.with.list.indexing.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002J=\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lorg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection$ReplaceWithListIndexing;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInspection/BatchQuickFix;", "e", "Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;)V", "getText", "", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyFix", "descriptors", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "psiElementsToIgnore", "", "refreshViews", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/codeInspection/CommonProblemDescriptor;Ljava/util/List;Ljava/lang/Runnable;)V", "Companion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHCLSimplifyExpressionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLSimplifyExpressionInspection.kt\norg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection$ReplaceWithListIndexing\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n4225#2,11:109\n1563#3:120\n1634#3,3:121\n1869#3,2:124\n*S KotlinDebug\n*F\n+ 1 HCLSimplifyExpressionInspection.kt\norg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection$ReplaceWithListIndexing\n*L\n74#1:109,11\n75#1:120\n75#1:121,3\n82#1:124,2\n*E\n"})
    public static final class ReplaceWithListIndexing
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements BatchQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public ReplaceWithListIndexing(@NotNull HCLMethodCallExpression e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super((PsiElement)e);
        }

        @NotNull
        public String getText() {
            String string = HCLBundle.message("hcl.simplify.expression.inspection.replace.with.list.indexing.quick.fix.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("hcl.simplify.expression.inspection.replace.with.list.indexing.quick.fix.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            Object[] objectArray = new Object[]{HCLLanguage.INSTANCE, TerraformLanguage.INSTANCE};
            if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)psiFile.getLanguage())) {
                return false;
            }
            return super.isAvailable(project, psiFile, startElement, endElement);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                return;
            }
            HCLMethodCallExpression hCLMethodCallExpression = startElement instanceof HCLMethodCallExpression ? (HCLMethodCallExpression)startElement : null;
            if (hCLMethodCallExpression == null) {
                return;
            }
            HCLMethodCallExpression call = hCLMethodCallExpression;
            HCLIdentifier hCLIdentifier = call.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier, (String)"<get-method>(...)");
            HCLIdentifier method = hCLIdentifier;
            if (!Intrinsics.areEqual((Object)method.getId(), (Object)"element") || call.getParameterList().getElements().size() != 2) {
                return;
            }
            HCLExpression replacement = ReplaceWithListIndexing.Companion.getReplacementValue(project, call);
            WriteCommandAction.writeCommandAction((Project)project).withName(this.getText()).withGroupId(this.getFamilyName()).run(() -> ReplaceWithListIndexing.invoke$lambda$0(project, psiFile, call, replacement));
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
                Intrinsics.checkNotNullParameter(psiElementsToIgnore, (String)"psiElementsToIgnore");
                ArrayList targets = new ArrayList();
                for (CommonProblemDescriptor descriptor : descriptors) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    QuickFix[] $this$filterIsInstance$iv;
                    if (descriptor.getFixes() == null) continue;
                    boolean $i$f$filterIsInstance22 = false;
                    QuickFix[] quickFixArray = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ReplaceWithListIndexing)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ReplaceWithListIndexing replaceWithListIndexing = (ReplaceWithListIndexing)((Object)item$iv$iv);
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(it.getStartElement());
                    }
                    ArrayList cfr_ignored_0 = (ArrayList)CollectionsKt.filterIsInstanceTo((Iterable)((List)destination$iv$iv2), (Collection)targets, HCLMethodCallExpression.class);
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)targets)) {
                    return;
                }
                DocumentUtil.writeInRunUndoTransparentAction(() -> ReplaceWithListIndexing.applyFix$lambda$1(targets, project));
                psiElementsToIgnore.addAll(targets);
                Runnable runnable = refreshViews;
                if (runnable == null) break block4;
                runnable.run();
            }
        }

        private static final void invoke$lambda$0(Project $project, PsiFile $psiFile, HCLMethodCallExpression $call, HCLExpression $replacement) {
            ReplaceWithListIndexing.Companion.replace($project, $psiFile, $call, $replacement);
        }

        private static final void applyFix$lambda$1(ArrayList $targets, Project $project) {
            Iterable $this$forEach$iv = $targets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HCLMethodCallExpression it = (HCLMethodCallExpression)element$iv;
                boolean bl = false;
                HCLExpression replacement = ReplaceWithListIndexing.Companion.getReplacementValue($project, it);
                PsiFile psiFile = it.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                ReplaceWithListIndexing.Companion.replace($project, psiFile, it, replacement);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hil/inspection/HCLSimplifyExpressionInspection$ReplaceWithListIndexing$Companion;", "", "<init>", "()V", "getReplacementValue", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "project", "Lcom/intellij/openapi/project/Project;", "call", "Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;", "replace", "", "file", "Lcom/intellij/psi/PsiFile;", "element", "replacement", "intellij.terraform"})
        public static final class Companion {
            private Companion() {
            }

            private final HCLExpression getReplacementValue(Project project, HCLMethodCallExpression call) {
                List<HCLExpression> list = call.getParameterList().getElements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
                List<HCLExpression> args = list;
                HCLExpression list2 = args.get(0);
                HCLExpression index = args.get(1);
                return new TfElementGenerator(project).createValue(list2.getText() + "[" + index.getText() + "]");
            }

            private final void replace(Project project, PsiFile file, HCLExpression element, HCLExpression replacement) {
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> Companion.replace$lambda$0(element, replacement, file));
            }

            private static final void replace$lambda$0(HCLExpression $element, HCLExpression $replacement, PsiFile $file) {
                $element.replace($replacement);
                $file.subtreeChanged();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

