/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.hil.HILFileType;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILExpressionHolder;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/hil/psi/ILElementGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createILVariable", "Lorg/intellij/terraform/hil/psi/ILVariable;", "text", "", "createVarReference", "Lorg/intellij/terraform/hil/psi/ILSelectExpression;", "name", "createDummyFile", "Lcom/intellij/psi/PsiFile;", "content", "intellij.terraform"})
public class ILElementGenerator {
    @NotNull
    private final Project project;

    public ILElementGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ILVariable createILVariable(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile file = this.createDummyFile(text);
        PsiElement firstChild = file.getFirstChild();
        if (firstChild instanceof ILExpressionHolder) {
            ILExpression iLExpression = ((ILExpressionHolder)firstChild).getExpression();
            Intrinsics.checkNotNull((Object)iLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILVariable");
            return (ILVariable)iLExpression;
        }
        Intrinsics.checkNotNull((Object)firstChild, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILVariable");
        return (ILVariable)firstChild;
    }

    @NotNull
    public final ILSelectExpression createVarReference(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile file = this.createDummyFile("var." + name);
        PsiElement firstChild = file.getFirstChild();
        if (firstChild instanceof ILExpressionHolder) {
            ILExpression iLExpression = ((ILExpressionHolder)firstChild).getExpression();
            Intrinsics.checkNotNull((Object)iLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILSelectExpression");
            return (ILSelectExpression)iLExpression;
        }
        Intrinsics.checkNotNull((Object)firstChild, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILSelectExpression");
        return (ILSelectExpression)firstChild;
    }

    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object code = content;
        if (!StringsKt.startsWith$default((String)code, (String)"${", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)code, (String)"}", (boolean)false, (int)2, null)) {
            code = "${" + (String)code + "}";
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.project);
        PsiFile psiFile = psiFileFactory.createFileFromText("dummy." + HILFileType.INSTANCE.getDefaultExtension(), (FileType)HILFileType.INSTANCE, (CharSequence)code);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }
}

