/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/hil/psi/ILLiteralExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/terraform/hil/psi/ILLiteralExpression;", "<init>", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "newContent", "", "getRangeInElement", "intellij.terraform"})
public final class ILLiteralExpressionManipulator
extends AbstractElementManipulator<ILLiteralExpression> {
    @NotNull
    public ILLiteralExpression handleContentChange(@NotNull ILLiteralExpression element, @NotNull TextRange range, @NotNull String newContent) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        StringBuilder replacement = new StringBuilder(range.replace(element.getText(), newContent));
        if (replacement.charAt(0) != '\"') {
            replacement.insert(0, '\"');
        }
        if (StringsKt.last((CharSequence)replacement) != '\"') {
            replacement.append('\"');
        }
        ASTNode aSTNode = element.getNode().getFirstChildNode();
        Intrinsics.checkNotNull((Object)aSTNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafElement");
        ((LeafElement)aSTNode).replaceWithText(replacement.toString());
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull ILLiteralExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String text = element.getText();
        int start = 0;
        int end = text.length();
        Intrinsics.checkNotNull((Object)text);
        if (StringsKt.startsWith$default((CharSequence)text, (char)'\"', (boolean)false, (int)2, null)) {
            ++start;
        }
        if (StringsKt.endsWith$default((CharSequence)text, (char)'\"', (boolean)false, (int)2, null)) {
            --end;
        }
        TextRange textRange = TextRange.create((int)start, (int)end);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }
}

