/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.FunctionsReturnTypeHelper;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ModuleType;
import org.intellij.terraform.config.model.ObjectType;
import org.intellij.terraform.config.model.PrimitiveType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.SetType;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.model.TupleType;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLBooleanLiteral;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLForArrayExpression;
import org.intellij.terraform.hcl.psi.HCLForExpression;
import org.intellij.terraform.hcl.psi.HCLForIntro;
import org.intellij.terraform.hcl.psi.HCLForObjectExpression;
import org.intellij.terraform.hcl.psi.HCLHeredocLiteral;
import org.intellij.terraform.hcl.psi.HCLNullLiteral;
import org.intellij.terraform.hcl.psi.HCLNumberLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hcl.psi.common.BinaryExpression;
import org.intellij.terraform.hcl.psi.common.CollectionExpression;
import org.intellij.terraform.hcl.psi.common.ConditionalExpression;
import org.intellij.terraform.hcl.psi.common.Identifier;
import org.intellij.terraform.hcl.psi.common.IndexSelectExpression;
import org.intellij.terraform.hcl.psi.common.LiteralExpression;
import org.intellij.terraform.hcl.psi.common.MethodCallExpression;
import org.intellij.terraform.hcl.psi.common.ParameterList;
import org.intellij.terraform.hcl.psi.common.ParenthesizedExpression;
import org.intellij.terraform.hcl.psi.common.ProviderDefinedFunction;
import org.intellij.terraform.hcl.psi.common.SelectExpression;
import org.intellij.terraform.hcl.psi.common.UnaryExpression;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.patterns.HILPatterns;
import org.intellij.terraform.hil.psi.ForVariableDirectReference;
import org.intellij.terraform.hil.psi.ILArray;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILObject;
import org.intellij.terraform.hil.psi.ILProperty;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/hil/psi/TypeCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/intellij/terraform/config/model/HclType;", "e", "Lorg/intellij/terraform/hcl/psi/common/BaseExpression;", "<init>", "(Lorg/intellij/terraform/hcl/psi/common/BaseExpression;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTypeCachedValueProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeCachedValueProvider.kt\norg/intellij/terraform/hil/psi/TypeCachedValueProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
public final class TypeCachedValueProvider
implements CachedValueProvider<HclType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseExpression e;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TokenSet UnaryNumberOps;
    @NotNull
    private static final TokenSet UnaryBooleanOps;
    @NotNull
    private static final TokenSet BinaryNumberOps;
    @NotNull
    private static final TokenSet BinaryBooleanOps;

    private TypeCachedValueProvider(BaseExpression e) {
        this.e = e;
    }

    @Nullable
    public CachedValueProvider.Result<HclType> compute() {
        CachedValueProvider.Result result2;
        BaseExpression baseExpression = this.e;
        if (baseExpression instanceof ParenthesizedExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((ParenthesizedExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof LiteralExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((LiteralExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof UnaryExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((UnaryExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof BinaryExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((BinaryExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof ConditionalExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((ConditionalExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof SelectExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((SelectExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof ProviderDefinedFunction) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((ProviderDefinedFunction)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof MethodCallExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((MethodCallExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof ParameterList) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((ParameterList)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof CollectionExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((CollectionExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof Identifier) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((Identifier)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else if (baseExpression instanceof HCLForExpression) {
            HclType hclType = TypeCachedValueProvider.Companion.doGetType((HCLForExpression)this.e);
            if (hclType != null) {
                HclType it = hclType;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.e};
                result2 = CachedValueProvider.Result.create((Object)it, (Object[])objectArray);
            } else {
                result2 = null;
            }
        } else {
            String[] stringArray = new String[]{this.e.getText()};
            LOG.error("Unexpected #getType call for " + this.e.getClass().getName(), stringArray);
            return null;
        }
        return result2;
    }

    public /* synthetic */ TypeCachedValueProvider(BaseExpression e, DefaultConstructorMarker $constructor_marker) {
        this(e);
    }

    static {
        Logger logger = Logger.getInstance(TypeCachedValueProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IElementType[] iElementTypeArray = new IElementType[]{HILElementTypes.OP_PLUS, HILElementTypes.OP_MINUS, HCLElementTypes.OP_PLUS, HCLElementTypes.OP_MINUS};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        UnaryNumberOps = tokenSet;
        iElementTypeArray = new IElementType[]{HILElementTypes.OP_NOT, HCLElementTypes.OP_NOT};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        UnaryBooleanOps = tokenSet2;
        iElementTypeArray = new IElementType[]{HILElementTypes.IL_BINARY_ADDITION_EXPRESSION, HILElementTypes.IL_BINARY_MULTIPLY_EXPRESSION, HCLElementTypes.BINARY_ADDITION_EXPRESSION, HCLElementTypes.BINARY_MULTIPLY_EXPRESSION};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        BinaryNumberOps = tokenSet3;
        iElementTypeArray = new IElementType[]{HILElementTypes.IL_BINARY_RELATIONAL_EXPRESSION, HILElementTypes.IL_BINARY_EQUALITY_EXPRESSION, HILElementTypes.IL_BINARY_AND_EXPRESSION, HILElementTypes.IL_BINARY_OR_EXPRESSION, HCLElementTypes.BINARY_RELATIONAL_EXPRESSION, HCLElementTypes.BINARY_EQUALITY_EXPRESSION, HCLElementTypes.BINARY_AND_EXPRESSION, HCLElementTypes.BINARY_OR_EXPRESSION};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        BinaryBooleanOps = tokenSet4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030!H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\"H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020#H\u0002R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/intellij/terraform/hil/psi/TypeCachedValueProvider$Companion;", "", "<init>", "()V", "getType", "Lorg/intellij/terraform/config/model/HclType;", "e", "Lorg/intellij/terraform/hcl/psi/common/BaseExpression;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doGetType", "Lorg/intellij/terraform/hcl/psi/common/ParenthesizedExpression;", "Lorg/intellij/terraform/hcl/psi/common/LiteralExpression;", "UnaryNumberOps", "Lcom/intellij/psi/tree/TokenSet;", "UnaryBooleanOps", "Lorg/intellij/terraform/hcl/psi/common/UnaryExpression;", "BinaryNumberOps", "BinaryBooleanOps", "Lorg/intellij/terraform/hcl/psi/common/BinaryExpression;", "Lorg/intellij/terraform/hcl/psi/common/ConditionalExpression;", "Lorg/intellij/terraform/hcl/psi/common/CollectionExpression;", "Lorg/intellij/terraform/hcl/psi/common/ParameterList;", "Lorg/intellij/terraform/hcl/psi/common/SelectExpression;", "selectFromMapType", "fromType", "name", "", "isSplatSelection", "", "expr", "Lorg/intellij/terraform/hcl/psi/common/MethodCallExpression;", "Lorg/intellij/terraform/hcl/psi/common/ProviderDefinedFunction;", "Lorg/intellij/terraform/hcl/psi/HCLForExpression;", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTypeCachedValueProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeCachedValueProvider.kt\norg/intellij/terraform/hil/psi/TypeCachedValueProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,401:1\n1563#2:402\n1634#2,3:403\n1617#2,9:406\n1869#2:415\n1870#2:417\n1626#2:418\n1#3:416\n4225#4,11:419\n*S KotlinDebug\n*F\n+ 1 TypeCachedValueProvider.kt\norg/intellij/terraform/hil/psi/TypeCachedValueProvider$Companion\n*L\n116#1:402\n116#1:403,3\n212#1:406,9\n212#1:415\n212#1:417\n212#1:418\n212#1:416\n366#1:419,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HclType getType(@NotNull BaseExpression e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return (HclType)CachedValuesManager.getCachedValue((PsiElement)e, (CachedValueProvider)new TypeCachedValueProvider(e, null));
        }

        private final HclType doGetType(ParenthesizedExpression<?> e) {
            Object obj = e.getExpression();
            if (obj == null) {
                return Types.INSTANCE.getAny();
            }
            Object expression = obj;
            return ExtensionsKt.getType(expression);
        }

        private final HclType doGetType(LiteralExpression e) {
            LiteralExpression literalExpression = e;
            return literalExpression instanceof ILLiteralExpression ? (HclType)(((ILLiteralExpression)e).getDoubleQuotedString() != null ? Types.INSTANCE.getString() : (((ILLiteralExpression)e).getNumber() != null ? Types.INSTANCE.getNumber() : (StringsKt.equals((String)"true", (String)((ILLiteralExpression)e).getText(), (boolean)true) ? Types.INSTANCE.getBoolean() : (StringsKt.equals((String)"false", (String)((ILLiteralExpression)e).getText(), (boolean)true) ? Types.INSTANCE.getBoolean() : null)))) : (literalExpression instanceof HCLNullLiteral ? (HclType)Types.INSTANCE.getNull() : (literalExpression instanceof HCLBooleanLiteral ? (HclType)Types.INSTANCE.getBoolean() : (literalExpression instanceof HCLNumberLiteral ? (HclType)Types.INSTANCE.getNumber() : (literalExpression instanceof HCLStringLiteral ? (HclType)Types.INSTANCE.getString() : (literalExpression instanceof HCLHeredocLiteral ? (HclType)Types.INSTANCE.getString() : null)))));
        }

        private final HclType doGetType(UnaryExpression<?> e) {
            HclType hclType;
            IElementType sign = e.getOperationSign();
            if (UnaryNumberOps.contains(sign)) {
                hclType = Types.INSTANCE.getNumber();
            } else if (UnaryBooleanOps.contains(sign)) {
                hclType = Types.INSTANCE.getBoolean();
            } else {
                String[] stringArray = new String[]{e.getText()};
                LOG.error("Unexpected operation sign of UnaryExpression: " + sign, stringArray);
                hclType = null;
            }
            return hclType;
        }

        private final HclType doGetType(BinaryExpression<?> e) {
            HclType hclType;
            IElementType iElementType = e.getNode().getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType et = iElementType;
            if (BinaryNumberOps.contains(et)) {
                hclType = Types.INSTANCE.getNumber();
            } else if (BinaryBooleanOps.contains(et)) {
                hclType = Types.INSTANCE.getBoolean();
            } else {
                String[] stringArray = new String[]{e.getText()};
                LOG.error("Unexpected operation sign of BinaryExpression: " + et, stringArray);
                hclType = null;
            }
            return hclType;
        }

        private final HclType doGetType(ConditionalExpression<?> e) {
            HclType r;
            Object first = e.getThen();
            Object second = e.getOtherwise();
            HclType l = ExtensionsKt.getType(first);
            if (Intrinsics.areEqual((Object)l, (Object)(r = ExtensionsKt.getType(second)))) {
                return l;
            }
            if (l == null) {
                return r;
            }
            if (r == null) {
                return l;
            }
            if (Intrinsics.areEqual((Object)l, (Object)Types.INSTANCE.getAny()) || Intrinsics.areEqual((Object)r, (Object)Types.INSTANCE.getAny())) {
                return Types.INSTANCE.getAny();
            }
            if (Intrinsics.areEqual((Object)l, (Object)Types.INSTANCE.getString())) {
                return r;
            }
            return l;
        }

        /*
         * WARNING - void declaration
         */
        private final HclType doGetType(CollectionExpression<?> e) {
            HclType hclType;
            CollectionExpression<?> collectionExpression = e;
            if (collectionExpression instanceof ParameterList) {
                hclType = this.doGetType((ParameterList)e);
            } else if (collectionExpression instanceof HCLArray || collectionExpression instanceof ILArray) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = e.getElements();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BaseExpression baseExpression = (BaseExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ExtensionsKt.getType((BaseExpression)it));
                }
                Set innerTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                hclType = switch (innerTypes.size()) {
                    case 0 -> new ListType(null);
                    case 1 -> new ListType((HclType)CollectionsKt.first((Iterable)innerTypes));
                    default -> {
                        HclType v2 = HclTypeModelKt.getCommonSupertype(innerTypes);
                        if (v2 == null) {
                            v2 = Types.INSTANCE.getAny();
                        }
                        yield new ListType(v2);
                    }
                };
            } else if (collectionExpression instanceof HCLObject) {
                Map result2 = new TreeMap();
                for (HCLProperty prop : ((HCLObject)e).getPropertyList()) {
                    result2.put(prop.getName(), ExtensionsKt.getType(prop.getValue()));
                }
                for (HCLBlock block : ((HCLObject)e).getBlockList()) {
                    result2.put(block.getName(), ExtensionsKt.getType(block.getObject()));
                }
                hclType = HclTypeModelKt.ObjectType$default(result2, null, 2, null);
            } else if (collectionExpression instanceof ILObject) {
                Map result3 = new TreeMap();
                for (ILProperty prop : ((ILObject)e).getPropertyList()) {
                    result3.put(prop.getName(), ExtensionsKt.getType(prop.getValue()));
                }
                hclType = HclTypeModelKt.ObjectType$default(result3, null, 2, null);
            } else {
                String[] stringArray = new String[]{e.getText()};
                LOG.error("Unexpected collection expression type: " + e.getClass().getName(), stringArray);
                hclType = null;
            }
            return hclType;
        }

        private final HclType doGetType(ParameterList<?> e) {
            Logger logger = LOG;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
            stringArray[0] = ((PsiElement)e).getText();
            logger.error("#getType should not be called for ILParameterList", stringArray);
            return null;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final HclType doGetType(SelectExpression<?> e) {
            String string;
            Object obj;
            HclType fromType;
            block65: {
                block64: {
                    fromType = ExtensionsKt.getType(e.getFrom());
                    if (this.isSplatSelection(e)) {
                        HclType hclType;
                        if (fromType instanceof SetType) {
                            return new ListType((HclType)((SetType)fromType).getElements());
                        }
                        if (HclTypeModelKt.isListType(fromType)) {
                            return fromType;
                        }
                        if (fromType instanceof PrimitiveType || HclTypeModelKt.isObjectType(fromType)) {
                            return new ListType(fromType);
                        }
                        if (ExtensionsKt.isInTerraformFile(e) && ((hclType = fromType) instanceof ResourceType || hclType instanceof DataSourceType || hclType instanceof ModuleType)) {
                            return new ListType(fromType);
                        }
                        return Types.INSTANCE.getInvalid();
                    }
                    if (e.getField() instanceof HCLNumberLiteral) break block64;
                    Object obj2 = e.getField();
                    ILLiteralExpression iLLiteralExpression = obj2 instanceof ILLiteralExpression ? (ILLiteralExpression)obj2 : null;
                    if ((iLLiteralExpression != null ? iLLiteralExpression.getNumber() : null) == null) break block65;
                }
                if (fromType instanceof ObjectType) {
                    HclType hclType;
                    Map<String, HclType> map = ((ObjectType)fromType).getElements();
                    if (map == null || (map = map.values()) == null) {
                        map = CollectionsKt.emptyList();
                    }
                    if ((hclType = HclTypeModelKt.getCommonSupertype((Collection<? extends HclType>)((Object)map))) == null) {
                        hclType = Types.INSTANCE.getAny();
                    }
                    return hclType;
                }
                if (fromType instanceof ListType) {
                    HclType hclType = (HclType)((ListType)fromType).getElements();
                    if (hclType == null) {
                        hclType = Types.INSTANCE.getAny();
                    }
                    return hclType;
                }
                if (fromType instanceof SetType) {
                    HclType hclType = (HclType)((SetType)fromType).getElements();
                    if (hclType == null) {
                        hclType = Types.INSTANCE.getAny();
                    }
                    return hclType;
                }
                if (fromType instanceof MapType) {
                    HclType hclType = (HclType)((MapType)fromType).getElements();
                    if (hclType == null) {
                        hclType = Types.INSTANCE.getAny();
                    }
                    return hclType;
                }
            }
            if (ExtensionsKt.isInTerraformFile(e) && !(e instanceof IndexSelectExpression)) {
                if (HILPatterns.INSTANCE.getIlseFromKnownScope().accepts(e)) {
                    Object obj3 = e.getFrom();
                    Intrinsics.checkNotNull(obj3, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.common.Identifier");
                    Identifier identifier = (Identifier)obj3;
                    Object object = e.getField();
                    if (object == null || (object = ((PsiElement)object).getText()) == null) {
                        return Types.INSTANCE.getInvalid();
                    }
                    Object object2 = object;
                    Object object3 = ILExpressionBaseKt.getHCLHost(e);
                    if (object3 == null || (object3 = ExtensionsKt.getTerraformModule((HCLElement)object3)) == null) {
                        return Types.INSTANCE.getInvalid();
                    }
                    Object module = object3;
                    String string2 = identifier.getName();
                    if (string2 != null) {
                        int n = -1;
                        switch (string2.hashCode()) {
                            case 116519: {
                                if (!string2.equals("var")) break;
                                n = 1;
                                break;
                            }
                            case -1068784020: {
                                if (!string2.equals("module")) break;
                                n = 2;
                                break;
                            }
                            case 103145323: {
                                if (!string2.equals("local")) break;
                                n = 3;
                                break;
                            }
                        }
                        switch (n) {
                            case 1: {
                                Variable variable;
                                List<Variable> variables = ((Module)module).findVariables((String)object2);
                                if (!((Collection)variables).isEmpty() && !PsiTreeUtil.isAncestor((PsiElement)(variable = (Variable)CollectionsKt.first(variables)).getDeclaration(), (PsiElement)e, (boolean)false)) {
                                    HclType hclType = variable.getCombinedType();
                                    if (hclType == null) {
                                        hclType = Types.INSTANCE.getAny();
                                    }
                                    return hclType;
                                }
                                return Types.INSTANCE.getAny();
                            }
                            case 3: {
                                Object object4 = ((Module)module).findLocal((String)object2);
                                if (object4 == null || (object4 = (HCLProperty)object4.getSecond()) == null || (object4 = object4.getValue()) == null || (object4 = ExtensionsKt.getType((BaseExpression)object4)) == null) {
                                    object4 = Types.INSTANCE.getAny();
                                }
                                return object4;
                            }
                            case 2: {
                                void $this$mapNotNullTo$iv$iv;
                                Iterable $this$mapNotNull$iv = ((Module)module).getDefinedModules((String)object2);
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    Module it$iv$iv;
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl = false;
                                    HCLBlock it = (HCLBlock)element$iv$iv;
                                    boolean bl2 = false;
                                    if (Module.Companion.getAsModuleBlock(it) == null) continue;
                                    boolean bl3 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                List modules = (List)destination$iv$iv;
                                if (!(!((Collection)modules).isEmpty())) break;
                                Module mod = (Module)CollectionsKt.first((List)modules);
                                return mod.getType();
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (HILPatterns.INSTANCE.getIlseNotFromKnownScope().accepts(e)) {
                    Object object;
                    block63: {
                        Object object5 = e.getField();
                        if (object5 == null || (object5 = ((PsiElement)object5).getText()) == null) {
                            return Types.INSTANCE.getInvalid();
                        }
                        object = object5;
                        if (e.getFrom() instanceof Identifier) {
                            Object obj4 = e.getFrom();
                            Intrinsics.checkNotNull(obj4, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.common.Identifier");
                            Identifier identifier = (Identifier)obj4;
                            Object object6 = ILExpressionBaseKt.getHCLHost(e);
                            if (object6 == null || (object6 = ExtensionsKt.getTerraformModule((HCLElement)object6)) == null) {
                                return Types.INSTANCE.getInvalid();
                            }
                            Object module = object6;
                            PsiReference[] psiReferenceArray = identifier.getReferences();
                            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                            PsiReference[] references = psiReferenceArray;
                            if (!(references.length == 0)) {
                                LOG.warn("Element: " + e.getText() + " From-References: " + references);
                                break block63;
                            } else {
                                HCLBlock hCLBlock = (HCLBlock)CollectionsKt.firstOrNull(((Module)module).getDefinedResources(identifier.getName(), (String)object));
                                if (hCLBlock == null) {
                                    return Types.INSTANCE.getInvalid();
                                }
                                HCLBlock block = hCLBlock;
                                HclType blockType = TfModelHelper.INSTANCE.getBlockType(block);
                                HclType hclType = blockType;
                                if (hclType == null) {
                                    hclType = Types.INSTANCE.getInvalid();
                                }
                                return hclType;
                            }
                        }
                        if (HILPatterns.INSTANCE.getIlseFromDataScope().accepts(e.getFrom())) {
                            Object obj5 = e.getFrom();
                            Intrinsics.checkNotNull(obj5, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.common.SelectExpression<*>");
                            Object references = ((SelectExpression)obj5).getField();
                            Identifier identifier = references instanceof Identifier ? (Identifier)references : null;
                            if (identifier == null) {
                                return Types.INSTANCE.getInvalid();
                            }
                            Identifier identifier2 = identifier;
                            Object object7 = ILExpressionBaseKt.getHCLHost(e);
                            if (object7 == null || (object7 = ExtensionsKt.getTerraformModule((HCLElement)object7)) == null) {
                                return Types.INSTANCE.getInvalid();
                            }
                            Object module = object7;
                            HCLBlock hCLBlock = (HCLBlock)CollectionsKt.firstOrNull(((Module)module).getDefinedDataSources(identifier2.getName(), (String)object));
                            if (hCLBlock == null) {
                                return Types.INSTANCE.getInvalid();
                            }
                            HCLBlock block = hCLBlock;
                            HclType blockType = TfModelHelper.INSTANCE.getBlockType(block);
                            HclType hclType = blockType;
                            if (hclType == null) {
                                hclType = Types.INSTANCE.getInvalid();
                            }
                            return hclType;
                        }
                    }
                    if (fromType instanceof ObjectType) {
                        Map<String, HclType> map = ((ObjectType)fromType).getElements();
                        if (map == null || (map = map.get(object)) == null) {
                            map = Types.INSTANCE.getInvalid();
                        }
                        return map;
                    }
                }
            }
            if ((obj = e.getField()) instanceof LiteralExpression) {
                Object obj6 = e.getField();
                Intrinsics.checkNotNull(obj6, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.common.LiteralExpression");
                v24 = ((LiteralExpression)obj6).getUnquotedText();
            } else if (obj instanceof Identifier) {
                Object obj7 = e.getField();
                Intrinsics.checkNotNull(obj7, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.common.Identifier");
                v24 = ((Identifier)obj7).getName();
            } else {
                v24 = string = null;
            }
            if (string != null) {
                HclType hclType;
                if (this.isSplatSelection((BaseExpression)e.getFrom())) {
                    if (fromType instanceof ListType) {
                        return new ListType(this.selectFromMapType((HclType)((ListType)fromType).getElements(), string));
                    }
                    if (fromType instanceof SetType) {
                        return new SetType(this.selectFromMapType((HclType)((SetType)fromType).getElements(), string));
                    }
                }
                if ((hclType = this.selectFromMapType(fromType, string)) != null) {
                    return hclType;
                }
            }
            return Types.INSTANCE.getAny();
        }

        private final HclType selectFromMapType(HclType fromType, String name) {
            if (fromType instanceof ObjectType) {
                Map<String, HclType> map = ((ObjectType)fromType).getElements();
                if (map == null) {
                    return Types.INSTANCE.getAny();
                }
                Map<String, HclType> elements = map;
                HclType hclType = elements.get(name);
                if (hclType == null) {
                    hclType = Types.INSTANCE.getInvalid();
                }
                return hclType;
            }
            if (fromType instanceof MapType) {
                HclType hclType = (HclType)((MapType)fromType).getElements();
                if (hclType == null) {
                    hclType = Types.INSTANCE.getAny();
                }
                return hclType;
            }
            return null;
        }

        private final boolean isSplatSelection(BaseExpression expr) {
            if (!(expr instanceof SelectExpression)) {
                return false;
            }
            Object field = ((SelectExpression)expr).getField();
            if (field instanceof Identifier && Intrinsics.areEqual((Object)((Identifier)field).getText(), (Object)"*")) {
                return true;
            }
            return field instanceof LiteralExpression && Intrinsics.areEqual((Object)((LiteralExpression)field).getUnquotedText(), (Object)"*");
        }

        private final HclType doGetType(MethodCallExpression<?> e) {
            if (ExtensionsKt.isInTerraformFile(e)) {
                return FunctionsReturnTypeHelper.INSTANCE.getType(e);
            }
            return Types.INSTANCE.getAny();
        }

        private final HclType doGetType(ProviderDefinedFunction<?> e) {
            String providerName = UtilKt.getNameOrText((PsiNamedElement)e.getProvider());
            String functionName = UtilKt.getNameOrText((PsiNamedElement)e.getFunction());
            TfTypeModel model = TypeModelProvider.Companion.getModel(e);
            Object object = model.getProviderFunction(providerName, functionName);
            if (object == null || (object = ((TfFunction)object).getReturnType()) == null) {
                return Types.INSTANCE.getAny();
            }
            return object;
        }

        private final HclType doGetType(HCLForExpression e) {
            HclType hclType;
            HCLForExpression hCLForExpression = e;
            if (hCLForExpression instanceof HCLForObjectExpression) {
                HclType hclType2 = ExtensionsKt.getType(((HCLForObjectExpression)e).getValue());
                if (hclType2 == null) {
                    hclType2 = Types.INSTANCE.getAny();
                }
                HclType valueType = hclType2;
                hclType = ((HCLForObjectExpression)e).isGrouping() ? new MapType(new ListType(valueType)) : new MapType(valueType);
            } else if (hCLForExpression instanceof HCLForArrayExpression) {
                hclType = new ListType(ExtensionsKt.getType(((HCLForArrayExpression)e).getExpression()));
            } else {
                String[] stringArray = new String[]{e.getText()};
                LOG.error("Unexpected for expression type: " + e.getClass().getName(), stringArray);
                hclType = null;
            }
            return hclType;
        }

        /*
         * WARNING - void declaration
         */
        private final HclType doGetType(Identifier e) {
            void $this$filterIsInstanceTo$iv$iv;
            PsiReference[] references;
            if (HCLPsiUtil.INSTANCE.isPartOfPropertyKey(e)) {
                return null;
            }
            if (TfPsiPatterns.INSTANCE.getForVariable().accepts((Object)e)) {
                HclType hclType;
                PsiElement psiElement = e.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLForIntro");
                HCLForIntro p = (HCLForIntro)psiElement;
                Object object = p.getContainer();
                if (object == null || (object = ExtensionsKt.getType((BaseExpression)object)) == null) {
                    return null;
                }
                Object containerType = object;
                if (p.getVar2() == null && p.getVar1() == e || p.getVar2() == e) {
                    Object object2 = containerType;
                    if (object2 instanceof ListType) {
                        hclType = (HclType)((ListType)containerType).getElements();
                        if (hclType == null) {
                            hclType = Types.INSTANCE.getAny();
                        }
                    } else if (object2 instanceof SetType) {
                        hclType = (HclType)((SetType)containerType).getElements();
                        if (hclType == null) {
                            hclType = Types.INSTANCE.getAny();
                        }
                    } else if (object2 instanceof TupleType) {
                        hclType = HclTypeModelKt.getCommonSupertype((Collection)((TupleType)containerType).getElements());
                        if (hclType == null) {
                            hclType = Types.INSTANCE.getAny();
                        }
                    } else if (object2 instanceof MapType) {
                        hclType = (HclType)((MapType)containerType).getElements();
                        if (hclType == null) {
                            hclType = Types.INSTANCE.getAny();
                        }
                    } else if (object2 instanceof ObjectType) {
                        Map<String, HclType> map = ((ObjectType)containerType).getElements();
                        if (map == null || (map = map.values()) == null) {
                            map = CollectionsKt.emptyList();
                        }
                        if ((hclType = HclTypeModelKt.getCommonSupertype((Collection<? extends HclType>)((Object)map))) == null) {
                            hclType = Types.INSTANCE.getAny();
                        }
                    } else {
                        hclType = null;
                    }
                } else {
                    hclType = HclTypeModelKt.isListType((HclType)containerType) ? Types.INSTANCE.getNumber() : (HclTypeModelKt.isObjectType((HclType)containerType) ? Types.INSTANCE.getString() : null);
                }
                return hclType;
            }
            PsiReference[] psiReferenceArray = e.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            PsiReference[] $this$filterIsInstance$iv = references = psiReferenceArray;
            boolean $i$f$filterIsInstance = false;
            PsiReference[] psiReferenceArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ForVariableDirectReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ForVariableDirectReference forVariableReference = (ForVariableDirectReference)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (forVariableReference != null) {
                BaseExpression resolved;
                PsiElement psiElement = forVariableReference.resolve();
                BaseExpression baseExpression = resolved = psiElement instanceof BaseExpression ? (BaseExpression)psiElement : null;
                return baseExpression != null ? ExtensionsKt.getType(baseExpression) : null;
            }
            return Types.INSTANCE.getIdentifier();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

