/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hil.psi.ForVariable;
import org.intellij.terraform.hil.psi.ILBinaryExpression;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILMethodCallExpression;
import org.intellij.terraform.hil.psi.ILObject;
import org.intellij.terraform.hil.psi.ILProperty;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILTemplateForBlockExpression;
import org.intellij.terraform.hil.psi.ILUnaryExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.hil.psi.impl.HILPsiImplUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HILPsiImplUtilJ {
    public static ILExpression getQualifier(ILMethodCallExpression expression) {
        return HILPsiImplUtils.INSTANCE.getQualifier(expression);
    }

    @Nullable
    public static ILVariable getMethod(ILMethodCallExpression expression) {
        return HILPsiImplUtils.INSTANCE.getMethod(expression);
    }

    @NotNull
    public static String getUnquotedText(ILLiteralExpression literal) {
        String string = HILPsiImplUtils.INSTANCE.getUnquotedText(literal);
        if (string == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static IElementType getOperationSign(ILUnaryExpression expression) {
        IElementType iElementType = HILPsiImplUtils.INSTANCE.getOperationSign(expression);
        if (iElementType == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    @NotNull
    public static IElementType getOperationSign(ILBinaryExpression expression) {
        IElementType iElementType = expression.getNode().getFirstChildNode().getTreeNext().getElementType();
        if (iElementType == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull ILSelectExpression select) {
        if (select == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(3);
        }
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)select);
        if (psiReferenceArray == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiReference getReference(@NotNull ILSelectExpression select) {
        PsiReference[] refs;
        if (select == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(5);
        }
        return (refs = HILPsiImplUtilJ.getReferences(select)).length != 0 ? refs[0] : null;
    }

    @NotNull
    public static String getName(@NotNull ILProperty property) {
        if (property == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(6);
        }
        String string = StringUtil.unescapeStringCharacters((String)HCLPsiUtil.stripQuotes(property.getNameElement().getText()));
        if (string == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static ILExpression getNameElement(@NotNull ILProperty property) {
        PsiElement firstChild;
        if (property == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(8);
        }
        if (!((firstChild = property.getFirstChild()) instanceof ILExpression)) {
            throw new IllegalStateException("Excepted expression, got " + firstChild.getClass().getName());
        }
        ILExpression iLExpression = (ILExpression)firstChild;
        if (iLExpression == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(9);
        }
        return iLExpression;
    }

    @Nullable
    public static ILExpression getValue(@NotNull ILProperty property) {
        if (property == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(10);
        }
        return (ILExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)HILPsiImplUtilJ.getNameElement(property), ILExpression.class);
    }

    @NotNull
    public static List<ILExpression> getElements(@NotNull ILObject object) {
        if (object == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(11);
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)object, ILExpression.class);
        if (list == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static List<ForVariable> getLoopVariables(@NotNull ILTemplateForBlockExpression forBlockExpression) {
        Object[] variables;
        if (forBlockExpression == null) {
            HILPsiImplUtilJ.$$$reportNull$$$0(13);
        }
        if ((variables = (ForVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)forBlockExpression.getForCondition(), ForVariable.class)) == null || variables.length == 0) {
            List<ForVariable> list = Collections.emptyList();
            if (list == null) {
                HILPsiImplUtilJ.$$$reportNull$$$0(14);
            }
            return list;
        }
        return new SmartList(variables);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 6, 8, 10, 11, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/terraform/hil/psi/impl/HILPsiImplUtilJ";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "select";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forBlockExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnquotedText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/terraform/hil/psi/impl/HILPsiImplUtilJ";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoopVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLoopVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 6, 8, 10, 11, 13 -> new IllegalArgumentException(string);
        };
    }
}

