/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.TerraformIcons;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.TfCommand;
import org.intellij.terraform.runtime.TfRunConfiguration;
import org.intellij.terraform.runtime.TfToolConfigurationTypeBase;
import org.intellij.terraform.runtime.TfToolsRunConfigurationBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0014\u0010\u001f\u001a\u00020 *\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/intellij/terraform/runtime/TfConfigurationType;", "Lorg/intellij/terraform/runtime/TfToolConfigurationTypeBase;", "Lcom/intellij/execution/RunConfigurationConverter;", "<init>", "()V", "baseFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getBaseFactory", "()Lcom/intellij/execution/configurations/ConfigurationFactory;", "initFactory", "getInitFactory", "validateFactory", "getValidateFactory", "planFactory", "getPlanFactory", "applyFactory", "getApplyFactory", "destroyFactory", "getDestroyFactory", "actionGroupId", "", "getActionGroupId", "()Ljava/lang/String;", "getDisplayName", "getConfigurationTypeDescription", "getIcon", "Ljavax/swing/Icon;", "getConfigurationFactories", "", "()[Lcom/intellij/execution/configurations/ConfigurationFactory;", "getId", "createConfiguration", "Lorg/intellij/terraform/runtime/TfToolsRunConfigurationBase;", "project", "Lcom/intellij/openapi/project/Project;", "convertRunConfigurationOnDemand", "", "element", "Lorg/jdom/Element;", "getFactoryName", "oldName", "Companion", "intellij.terraform"})
public final class TfConfigurationType
extends TfToolConfigurationTypeBase
implements RunConfigurationConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurationFactory baseFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.CUSTOM);
    @NotNull
    private final ConfigurationFactory initFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.INIT);
    @NotNull
    private final ConfigurationFactory validateFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.VALIDATE);
    @NotNull
    private final ConfigurationFactory planFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.PLAN);
    @NotNull
    private final ConfigurationFactory applyFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.APPLY);
    @NotNull
    private final ConfigurationFactory destroyFactory = this.createFactory(TfToolType.TERRAFORM, TfCommand.DESTROY);
    @NotNull
    private final String actionGroupId;
    @NotNull
    public static final String TF_RUN_CONFIGURATION_ID = "TerraformConfigurationType";

    public TfConfigurationType() {
        this.actionGroupId = "TfRunConfigurationActions";
    }

    @Override
    @NotNull
    public ConfigurationFactory getBaseFactory() {
        return this.baseFactory;
    }

    @Override
    @NotNull
    public ConfigurationFactory getInitFactory() {
        return this.initFactory;
    }

    @Override
    @NotNull
    public ConfigurationFactory getValidateFactory() {
        return this.validateFactory;
    }

    @Override
    @NotNull
    public ConfigurationFactory getPlanFactory() {
        return this.planFactory;
    }

    @Override
    @NotNull
    public ConfigurationFactory getApplyFactory() {
        return this.applyFactory;
    }

    @Override
    @NotNull
    public ConfigurationFactory getDestroyFactory() {
        return this.destroyFactory;
    }

    @Override
    @NotNull
    public String getActionGroupId() {
        return this.actionGroupId;
    }

    @NotNull
    public String getDisplayName() {
        String string = HCLBundle.message("terraform.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getConfigurationTypeDescription() {
        Object[] objectArray = new Object[]{TfToolType.TERRAFORM.getDisplayName()};
        String string = HCLBundle.message("terraform.configuration.type.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TerraformIcons.Terraform;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Terraform");
        return icon;
    }

    @NotNull
    public ConfigurationFactory[] getConfigurationFactories() {
        ConfigurationFactory[] configurationFactoryArray = new ConfigurationFactory[]{this.getBaseFactory(), this.getInitFactory(), this.getValidateFactory(), this.getPlanFactory(), this.getApplyFactory(), this.getDestroyFactory()};
        return configurationFactoryArray;
    }

    @NotNull
    public String getId() {
        return TF_RUN_CONFIGURATION_ID;
    }

    @Override
    @NotNull
    protected TfToolsRunConfigurationBase createConfiguration(@NotNull ConfigurationFactory $this$createConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$createConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new TfRunConfiguration(project, $this$createConfiguration, "", CollectionsKt.emptyList());
    }

    public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getAttributeValue("type");
        if (string == null) {
            return false;
        }
        String configType = string;
        if (StringsKt.contains$default((CharSequence)configType, (CharSequence)TF_RUN_CONFIGURATION_ID, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)configType, (Object)TF_RUN_CONFIGURATION_ID)) {
            element.setAttribute("type", TF_RUN_CONFIGURATION_ID);
            String oldFactoryName = element.getAttributeValue("factoryName");
            element.setAttribute("factoryName", this.getFactoryName(oldFactoryName));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getFactoryName(String oldName) {
        String string;
        char[] cArray;
        Object object = oldName;
        String suffix = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : null;
        String string2 = suffix;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case 2283824: {
                    if (!string2.equals("Init")) break;
                    n = 1;
                    break;
                }
                case -1356628682: {
                    if (!string2.equals("Validate")) break;
                    n = 2;
                    break;
                }
                case 63476558: {
                    if (!string2.equals("Apply")) break;
                    n = 3;
                    break;
                }
                case -1072941094: {
                    if (!string2.equals("Destroy")) break;
                    n = 4;
                    break;
                }
                case 2490185: {
                    if (!string2.equals("Plan")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String string3 = this.getInitFactory().getId();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
                    return string;
                }
                case 2: {
                    String string4 = this.getValidateFactory().getId();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getId(...)");
                    return string;
                }
                case 5: {
                    String string5 = this.getPlanFactory().getId();
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getId(...)");
                    return string;
                }
                case 3: {
                    String string6 = this.getApplyFactory().getId();
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getId(...)");
                    return string;
                }
                case 4: {
                    String string7 = this.getDestroyFactory().getId();
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getId(...)");
                    return string;
                }
            }
        }
        String string8 = this.getBaseFactory().getId();
        string = string8;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getId(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/terraform/runtime/TfConfigurationType$Companion;", "", "<init>", "()V", "TF_RUN_CONFIGURATION_ID", "", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

