/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.terraform.config.util.TfExecutor;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.TfToolInitCommandFilter;
import org.intellij.terraform.runtime.TfToolPathDetector;
import org.intellij.terraform.runtime.TfToolPathDetectorKt;
import org.intellij.terraform.runtime.TfToolsRunConfigurationBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f*\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lorg/intellij/terraform/runtime/TfToolCommandLineState;", "Lcom/intellij/execution/configurations/CommandLineState;", "project", "Lcom/intellij/openapi/project/Project;", "configParams", "Lorg/intellij/terraform/runtime/TfToolsRunConfigurationBase;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "toolType", "Lorg/intellij/terraform/install/TfToolType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/intellij/terraform/runtime/TfToolsRunConfigurationBase;Lcom/intellij/execution/runners/ExecutionEnvironment;Lorg/intellij/terraform/install/TfToolType;)V", "getToolType", "()Lorg/intellij/terraform/install/TfToolType;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "parameters", "Lcom/intellij/execution/configurations/SimpleProgramParameters;", "getParameters", "()Lcom/intellij/execution/configurations/SimpleProgramParameters;", "handleEnvVar", "", "", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfToolsRunConfigurationBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolCommandLineState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n463#2:242\n413#2:243\n1252#3,4:244\n*S KotlinDebug\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolCommandLineState\n*L\n213#1:242\n213#1:243\n213#1:244,4\n*E\n"})
public final class TfToolCommandLineState
extends CommandLineState {
    @NotNull
    private final Project project;
    @NotNull
    private final TfToolsRunConfigurationBase configParams;
    @NotNull
    private final TfToolType toolType;

    public TfToolCommandLineState(@NotNull Project project, @NotNull TfToolsRunConfigurationBase configParams, @NotNull ExecutionEnvironment env, @NotNull TfToolType toolType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)configParams), (String)"configParams");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)toolType), (String)"toolType");
        super(env);
        this.project = project;
        this.configParams = configParams;
        this.toolType = toolType;
    }

    @NotNull
    public final TfToolType getToolType() {
        return this.toolType;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (ExecutionResult)new DefaultExecutionResult();
        }
        Object[] objectArray = new Object[]{this.toolType.getDisplayName()};
        String string = HCLBundle.message("progress.title.detecting.terraform.executable", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        boolean isToolDetected2 = (Boolean)TasksKt.runWithModalProgressBlocking((Project)this.project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ TfToolCommandLineState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TfToolPathDetector.Companion.getInstance(TfToolCommandLineState.access$getProject$p(this.this$0)).detectAndVerifyTool(this.this$0.getToolType(), false, (Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (!isToolDetected2) {
            TfToolPathDetectorKt.showIncorrectPathNotification(this.project, this.toolType);
            throw new ProcessCanceledException();
        }
        ExecutionResult executionResult = super.execute(executor, runner);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"execute(...)");
        return executionResult;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler handler = (OSProcessHandler)new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)handler));
        return (ProcessHandler)handler;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ConsoleView consoleView = super.createConsole(executor);
        if (consoleView == null) {
            return null;
        }
        ConsoleView consoleView2 = consoleView;
        String string = this.getParameters().getWorkingDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirectory(...)");
        consoleView2.addMessageFilter((Filter)new TfToolInitCommandFilter(this.project, string, this.toolType));
        return consoleView2;
    }

    private final GeneralCommandLine createCommandLine() throws ExecutionException {
        SimpleProgramParameters parameters = this.getParameters();
        Object[] objectArray = new Object[]{this.toolType.getDisplayName()};
        TfExecutor tfExecutor = TfExecutor.in(this.project, this.toolType).withPresentableName(HCLBundle.message("terraform.run.configuration.name", objectArray)).withWorkDirectory(parameters.getWorkingDirectory()).withParameters(parameters.getProgramParametersList().getParameters()).withPassParentEnvironment(parameters.isPassParentEnvs());
        Map map = parameters.getEnv();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnv(...)");
        GeneralCommandLine generalCommandLine = tfExecutor.withExtraEnvironment(this.handleEnvVar(map)).showOutputOnError().createCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"createCommandLine(...)");
        return generalCommandLine;
    }

    private final SimpleProgramParameters getParameters() {
        SimpleProgramParameters params = new SimpleProgramParameters();
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)this.configParams);
        return params;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> handleEnvVar(Map<String, String> $this$handleEnvVar) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = $this$handleEnvVar;
        boolean $i$f$mapValues = false;
        Map<String, String> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String value = (String)entry2.getValue();
            if (StringsKt.startsWith$default((CharSequence)value, (char)'$', (boolean)false, (int)2, null)) {
                String string2 = value.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = System.getenv(string2);
                if (string == null) {
                    string = value;
                }
            } else {
                string = value;
            }
            String string3 = string;
            map3.put(k, string3);
        }
        return destination$iv$iv$iv;
    }

    public static final /* synthetic */ Project access$getProject$p(TfToolCommandLineState $this) {
        return $this.project;
    }
}

