/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.TfExecutableTestButton;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.opentofu.runtime.OpenTofuProjectSettings;
import org.intellij.terraform.runtime.TfProjectSettings;
import org.intellij.terraform.runtime.TfToolConfigurableKt;
import org.intellij.terraform.runtime.TfToolSettings;
import org.intellij.terraform.terragrunt.runtime.TerragruntProjectSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/terraform/runtime/TfToolConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "terraformConfig", "Lorg/intellij/terraform/runtime/TfProjectSettings;", "openTofuConfig", "Lorg/intellij/terraform/opentofu/runtime/OpenTofuProjectSettings;", "terragruntConfig", "Lorg/intellij/terraform/terragrunt/runtime/TerragruntProjectSettings;", "getId", "", "getHelpTopic", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "executableToolSettingsPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "parent", "settings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "type", "Lorg/intellij/terraform/install/TfToolType;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.terraform"})
public final class TfToolConfigurable
extends BoundConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final TfProjectSettings terraformConfig;
    @NotNull
    private final OpenTofuProjectSettings openTofuConfig;
    @NotNull
    private final TerragruntProjectSettings terragruntConfig;

    public TfToolConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = HCLBundle.message("terraform.opentofu.settings.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, null);
        this.project = project;
        this.terraformConfig = TfProjectSettings.Companion.getInstance(this.project);
        this.openTofuConfig = OpenTofuProjectSettings.Companion.getInstance(this.project);
        this.terragruntConfig = TerragruntProjectSettings.Companion.getInstance(this.project);
    }

    @NotNull
    public String getId() {
        return "reference.settings.dialog.project.terraform";
    }

    @NotNull
    public String getHelpTopic() {
        return "terraform";
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> TfToolConfigurable.createPanel$lambda$0(this, arg_0));
    }

    private final Panel executableToolSettingsPanel(Panel parent, TfToolSettings settings, TfToolType type, Disposable parentDisposable) {
        Panel panel;
        Panel $this$executableToolSettingsPanel_u24lambda_u240 = panel = parent;
        boolean bl = false;
        Object[] objectArray = new Object[]{type.getDisplayName()};
        String string = HCLBundle.message("tool.settings.executable.path.label", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row myRow = $this$executableToolSettingsPanel_u24lambda_u240.row(string, TfToolConfigurable::executableToolSettingsPanel$lambda$0$0);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFile();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"singleFile(...)");
        objectArray = new DialogValidation.WithParameter[]{TfToolConfigurableKt.access$getIS_EXIST$p(), TfToolConfigurableKt.access$getCHECK_EXECUTABLE$p()};
        Cell executorField2 = TextFieldWithBrowseButtonKt.trimmedTextValidation((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)myRow, (FileChooserDescriptor)fileChooserDescriptor, null, TfToolConfigurable::executableToolSettingsPanel$lambda$0$1, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(settings){

            public Object get() {
                return ((TfToolSettings)this.receiver).getToolPath();
            }

            public void set(Object value) {
                ((TfToolSettings)this.receiver).setToolPath((String)value);
            }
        })).applyToComponent(arg_0 -> TfToolConfigurable.executableToolSettingsPanel$lambda$0$2(type, arg_0)), (DialogValidation.WithParameter[])objectArray).align((Align)AlignX.FILL.INSTANCE);
        TfExecutableTestButton testButton = new TfExecutableTestButton(this.project, type, (TextFieldWithBrowseButton)executorField2.getComponent(), parentDisposable);
        Panel.row$default((Panel)$this$executableToolSettingsPanel_u24lambda_u240, null, arg_0 -> TfToolConfigurable.executableToolSettingsPanel$lambda$0$3(testButton, arg_0), (int)1, null);
        executorField2.onChanged(arg_0 -> TfToolConfigurable.executableToolSettingsPanel$lambda$0$4(testButton, arg_0));
        return panel;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$0(TfToolConfigurable this$0, Panel $this$panel) {
        void $this$createPanel_u24lambda_u240_u242;
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)HCLBundle.message("terraform.name", new Object[0]), (boolean)false, arg_0 -> TfToolConfigurable.createPanel$lambda$0$0(this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)HCLBundle.message("opentofu.name", new Object[0]), (boolean)false, arg_0 -> TfToolConfigurable.createPanel$lambda$0$1(this$0, arg_0), (int)2, null);
        JBLabel jBLabel2 = jBLabel = new JBLabel(HCLBundle.message("terragrunt.name", new Object[0]));
        Panel panel = $this$panel;
        boolean bl = false;
        $this$createPanel_u24lambda_u240_u242.setIcon(AllIcons.General.Beta);
        $this$createPanel_u24lambda_u240_u242.setHorizontalTextPosition(2);
        Panel.group$default((Panel)panel, (JBLabel)jBLabel, (boolean)false, arg_0 -> TfToolConfigurable.createPanel$lambda$0$3(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(TfToolConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.executableToolSettingsPanel($this$group, this$0.terraformConfig, TfToolType.TERRAFORM, this$0.getDisposable());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(TfToolConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.executableToolSettingsPanel($this$group, this$0.openTofuConfig, TfToolType.OPENTOFU, this$0.getDisposable());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(TfToolConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.executableToolSettingsPanel($this$group, this$0.terragruntConfig, TfToolType.TERRAGRUNT, this$0.getDisposable());
        return Unit.INSTANCE;
    }

    private static final Unit executableToolSettingsPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final String executableToolSettingsPanel$lambda$0$1(VirtualFile chosenFile) {
        Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
        String string = chosenFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final Unit executableToolSettingsPanel$lambda$0$2(TfToolType $type, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        UiUtils.getEmptyText((TextFieldWithBrowseButton)$this$applyToComponent).setText($type.getBinaryName());
        return Unit.INSTANCE;
    }

    private static final Unit executableToolSettingsPanel$lambda$0$3(TfExecutableTestButton $testButton, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$testButton);
        return Unit.INSTANCE;
    }

    private static final Unit executableToolSettingsPanel$lambda$0$4(TfExecutableTestButton $testButton, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $testButton.updateTestButton(it.getText());
        return Unit.INSTANCE;
    }
}

