/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.runtime;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.actions.TfActionService;
import org.intellij.terraform.install.TfToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/runtime/TfToolInitCommandFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "directory", "", "toolType", "Lorg/intellij/terraform/install/TfToolType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lorg/intellij/terraform/install/TfToolType;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDirectory", "()Ljava/lang/String;", "command", "getCommand", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfToolsRunConfigurationBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolInitCommandFilter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,241:1\n30#2,2:242\n*S KotlinDebug\n*F\n+ 1 TfToolsRunConfigurationBase.kt\norg/intellij/terraform/runtime/TfToolInitCommandFilter\n*L\n237#1:242,2\n*E\n"})
final class TfToolInitCommandFilter
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final String directory;
    @NotNull
    private final String command;

    public TfToolInitCommandFilter(@NotNull Project project, @NotNull String directory, @NotNull TfToolType toolType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)((Object)toolType), (String)"toolType");
        this.project = project;
        this.directory = directory;
        this.command = toolType.getBinaryName() + " init";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getDirectory() {
        return this.directory;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)this.command, (boolean)false, (int)2, null)) {
            return null;
        }
        TextRange textRange = StringKt.findTextRange((String)line, (String)this.command);
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        return new Filter.Result(entireLength - line.length() + textRange2.getStartOffset(), entireLength - line.length() + textRange2.getEndOffset(), arg_0 -> TfToolInitCommandFilter.applyFilter$lambda$0(this, arg_0));
    }

    private static final void applyFilter$lambda$0(TfToolInitCommandFilter this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<TfActionService> serviceClass$iv = TfActionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((TfActionService)object).scheduleTerraformInit(this$0.directory, true);
    }
}

