/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DbOptionProvider<Target, T> {
    public static final ExtensionPointName<DbOptionProvider<?, ?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.optionProvider");

    public boolean isAcceptable(@NotNull Class<?> var1);

    public boolean isApplicable(@Nullable Project var1, @NotNull Target var2);

    @Nls
    public String getDisplayName();

    @Nls
    public String getDescription();

    default public T getValue(@Nullable Target target) {
        return this.load(target);
    }

    public T load(@Nullable Target var1);

    public void store(@NotNull Target var1, T var2);

    public EditorDesc<T> getEditor(Target var1, @NotNull DataContext var2);

    @NotNull
    public UiLocation getLocation();

    @Nullable
    default public String getPassToConnectKey() {
        return null;
    }

    default public boolean isAffectsIntrospection() {
        return false;
    }

    public static <Target> JBIterable<DbOptionProvider<Target, ?>> getProviders(@NotNull Class<? extends Target> clazz) {
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(0);
        }
        return JBIterable.from((Iterable)EP_NAME.getIterable()).filter(e -> e.isAcceptable(clazz));
    }

    public static <Target> JBIterable<DbOptionProvider<Target, ?>> getProviders(@NotNull Project project, @NotNull Target target) {
        if (project == null) {
            DbOptionProvider.$$$reportNull$$$0(1);
        }
        if (target == null) {
            DbOptionProvider.$$$reportNull$$$0(2);
        }
        return DbOptionProvider.getProviders(DbImplUtilCore.classOf(target)).filter(e -> e.isApplicable(project, target));
    }

    public static <Target, T> T getOptionValue(@NotNull Target target, @NotNull Class<? extends DbOptionProvider<Target, T>> clazz) {
        DbOptionProvider<Target, T> provider;
        if (target == null) {
            DbOptionProvider.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(4);
        }
        return (provider = DbOptionProvider.getProvider(target, clazz)) == null ? null : (T)provider.getValue(target);
    }

    @Nullable
    public static <Target, T> DbOptionProvider<Target, T> getProvider(@NotNull Target target, @NotNull Class<? extends DbOptionProvider<Target, T>> clazz) {
        if (target == null) {
            DbOptionProvider.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            DbOptionProvider.$$$reportNull$$$0(6);
        }
        return (DbOptionProvider)DbOptionProvider.getProviders(DbImplUtilCore.classOf(target)).filter(clazz).first();
    }

    public static EditorDesc<Boolean> getCheckBox(Boolean value) {
        JCheckBox component = new JCheckBox(null, null, value);
        EditorDesc<Boolean> res = new EditorDesc<Boolean>(component, component::setSelected, component::isSelected);
        component.addActionListener(e -> res.fireChanged());
        return res;
    }

    public static EditorDesc<String> getTextField(@Nls String value) {
        return DbOptionProvider.getTextField(value, Functions.id(), Functions.id());
    }

    public static <T> EditorDesc<T> getTextField(T value, Function<? super T, @Nls String> toStr, Function<? super String, T> fromStr) {
        JTextField component = new JTextField((String)toStr.fun(value));
        final EditorDesc res = new EditorDesc(component, v -> component.setText((String)toStr.fun(v)), () -> fromStr.fun((Object)component.getText()));
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                res.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DbOptionProvider$1", "textChanged"));
            }
        });
        return res;
    }

    @NotNull
    public static <T> EditorDesc<T> getComboBox(JComboBox<T> component) {
        EditorDesc res = new EditorDesc(component, v -> component.setSelectedItem(v), () -> component.getSelectedItem());
        component.addItemListener(e -> res.fireChanged());
        EditorDesc editorDesc = res;
        if (editorDesc == null) {
            DbOptionProvider.$$$reportNull$$$0(7);
        }
        return editorDesc;
    }

    @Nullable
    public static Double getDouble(@Nullable String v) {
        double res = v == null ? -1.0 : StringUtil.parseDouble((String)v, (double)-1.0);
        return res > 0.0 ? Double.valueOf(res) : null;
    }

    @Nullable
    public static Integer getInteger(@Nullable String v) {
        int res = v == null ? -1 : StringUtil.parseInt((String)v, (int)-1);
        return res > 0 ? Integer.valueOf(res) : null;
    }

    @Nullable
    public static Long getLong(@Nullable String v) {
        long res = v == null ? -1L : StringUtil.parseLong((String)v, (long)-1L);
        return res > 0L ? Long.valueOf(res) : null;
    }

    @Nullable
    public static String getString(@Nullable Object v) {
        return v == null ? null : v.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DbOptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DbOptionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    public static class EditorDesc<T> {
        public final JComponent component;
        public final Setter<T> setter;
        public final Getter<T> getter;
        public final Ref<Runnable> changed;

        public EditorDesc(JComponent component, Setter<T> setter, Getter<T> getter) {
            this(component, setter, getter, (Ref<Runnable>)Ref.create());
        }

        public EditorDesc(JComponent component, Setter<T> setter, Getter<T> getter, Ref<Runnable> changed) {
            this.component = component;
            this.setter = setter;
            this.getter = getter;
            this.changed = changed;
        }

        public void fireChanged() {
            Runnable runnable = (Runnable)this.changed.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public static abstract class LocalDataSourceOptionProvider<T>
    implements DbOptionProvider<LocalDataSource, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                LocalDataSourceOptionProvider.$$$reportNull$$$0(0);
            }
            return LocalDataSource.class.isAssignableFrom(targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider", "isAcceptable"));
        }
    }

    public static abstract class ConnectionPointOptionProvider<T>
    implements DbOptionProvider<DatabaseConnectionPoint, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                ConnectionPointOptionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseConnectionPoint.class.isAssignableFrom(targetClass);
        }

        @Override
        public void store(@NotNull DatabaseConnectionPoint point, T value) {
            if (point == null) {
                ConnectionPointOptionProvider.$$$reportNull$$$0(1);
            }
            if (point instanceof DatabaseConnectionConfig) {
                this.store((DatabaseConnectionConfig)point, value);
            }
        }

        @Override
        public abstract void store(@NotNull DatabaseConnectionConfig var1, T var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DbOptionProvider$ConnectionPointOptionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DriverOptionProvider<T>
    implements DbOptionProvider<DatabaseDriver, T> {
        @Override
        public boolean isAcceptable(@NotNull Class<?> targetClass) {
            if (targetClass == null) {
                DriverOptionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseDriver.class.isAssignableFrom(targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/dataSource/DbOptionProvider$DriverOptionProvider", "isAcceptable"));
        }
    }

    public static enum UiLocation {
        EXPERT,
        SCHEMAS,
        CONNECTION,
        INTROSPECTION,
        GENERAL,
        NEW_TAB;

    }
}

