/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchangeCore;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInterchange
implements DataInterchangeCore {
    public static final Key<?> ACTIVITY = Key.create((String)"ACTIVITY");
    private final DataSourceFacade myConfigurable;
    private final Map<String, String> myProperties;
    private final Set<String> myPersistentProperties;
    private final Map<Key, Object> myUserData;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final EventDispatcher<UserDataListener> myDispatcher;
    private final EventDispatcher<NestedChangeListener> myNestedDispatcher;
    private int myDepth;

    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myConfigurable.getCoroutineScope();
        if (coroutineScope == null) {
            DataInterchange.$$$reportNull$$$0(0);
        }
        return coroutineScope;
    }

    public void addGroupedChangeListener(@NotNull NestedChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(2);
        }
        this.myNestedDispatcher.addListener((EventListener)listener, parent);
    }

    public DatabaseCredentials getCredentials() {
        return this.myConfigurable.getSecretService();
    }

    public DataInterchange(@NotNull DataSourceFacade configurable) {
        if (configurable == null) {
            DataInterchange.$$$reportNull$$$0(3);
        }
        this.myProperties = new HashMap<String, String>();
        this.myPersistentProperties = new HashSet<String>();
        this.myUserData = new HashMap<Key, Object>();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDispatcher = EventDispatcher.create(UserDataListener.class);
        this.myNestedDispatcher = EventDispatcher.create(NestedChangeListener.class);
        this.myDepth = 0;
        this.myConfigurable = configurable;
    }

    public Project getProject() {
        return this.myConfigurable.getProject();
    }

    public void showError(@Nls @Nullable String message, @NotNull Object id) {
        if (id == null) {
            DataInterchange.$$$reportNull$$$0(4);
        }
        this.myConfigurable.showErrorNotification(message, id);
    }

    @NotNull
    public Set<String> getPersistentProperties() {
        Set<String> set = this.myPersistentProperties;
        if (set == null) {
            DataInterchange.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void addPersistentProperty(@NotNull String key) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(6);
        }
        this.myPersistentProperties.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putProperty(@NotNull String key, @Nullable String val) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(7);
        }
        this.startNested();
        try {
            String prev = this.myProperties.put(key, val);
            this.myPropertyChangeSupport.firePropertyChange(key, prev, val);
        }
        finally {
            this.endNested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperties(Consumer<PairConsumer<@NotNull String, @Nullable String>> action) {
        this.startNested();
        try {
            LinkedHashMap values = new LinkedHashMap();
            action.consume((key, val) -> {
                String prev = this.myProperties.put((String)key, (String)val);
                if (!values.containsKey(key)) {
                    values.put(key, prev);
                }
            });
            for (Map.Entry e : values.entrySet()) {
                this.myPropertyChangeSupport.firePropertyChange((String)e.getKey(), e.getValue(), this.myProperties.get(e.getKey()));
            }
        }
        finally {
            this.endNested();
        }
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String key) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(8);
        }
        return this.myProperties.get(key);
    }

    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(10);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(listener);
            }
        });
    }

    public void addPropertyChangeListener(final @NotNull String key, final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(11);
        }
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(13);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(key, listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(key, listener);
            }
        });
    }

    public void forceUpdateProperty(@NotNull String key) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(14);
        }
        this.startNested();
        try {
            String prev = this.myProperties.get(key);
            this.myPropertyChangeSupport.firePropertyChange(key, prev == null ? "" : null, prev);
        }
        finally {
            this.endNested();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(15);
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DataInterchange.$$$reportNull$$$0(16);
        }
        if (Comparing.equal(this.getUserData(key), value)) {
            return;
        }
        this.myUserData.put(key, value);
        this.fireUserDataChanged(key);
    }

    public void fireUserDataChanged(@NotNull Key<?> changed) {
        if (changed == null) {
            DataInterchange.$$$reportNull$$$0(17);
        }
        ((UserDataListener)this.myDispatcher.getMulticaster()).userDataChanged(changed);
    }

    public void addUserDataListener(@NotNull UserDataListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(19);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void startNested() {
        ++this.myDepth;
    }

    public void endNested() {
        ((NestedChangeListener)this.myNestedDispatcher.getMulticaster()).nestedChange(--this.myDepth);
    }

    @NotNull
    public LocalDataSource buildDataSource() {
        LocalDataSource result = LocalDataSource.temporary();
        UIUtil.invokeAndWaitIfNeeded(() -> this.myConfigurable.saveData(result, true, true));
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(20);
        }
        return localDataSource;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myConfigurable.getTempDataSource().getDatabaseDriver();
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myConfigurable.getTempDataSource();
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(21);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getDataSourceRef() {
        LocalDataSource localDataSource = this.myConfigurable.getTempDataSource();
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(22);
        }
        return localDataSource;
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myConfigurable.getActiveParser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/DataInterchange";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/DataInterchange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentProperties";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataSource";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceRef";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGroupedChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPersistentProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fireUserDataChanged";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addUserDataListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    public static interface UserDataListener
    extends EventListener {
        public void userDataChanged(@NotNull Key<?> var1);
    }

    public static interface NestedChangeListener
    extends EventListener {
        public void nestedChange(int var1);
    }
}

