/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.sql.SqlUtilFun;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\f\u0010\f\u001a\u00020\b*\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\b*\u00020\rH\u0002\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"languageRequiresSpaceBetween", "", "node1", "Lcom/intellij/lang/ASTNode;", "node2", "languageRequiresSpaceBetweenLeafNodes", "languageRequiresSpacesBetweenChars", "c1", "", "c2", "WORD_CATEGORY_CHARS", "", "safeFirst", "", "safeLast", "intellij.database.sql.core.impl"})
@JvmName(name="SqlSpacing")
public final class SqlSpacing {
    @NotNull
    private static final Set<Character> WORD_CATEGORY_CHARS;

    public static final boolean languageRequiresSpaceBetween(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        ASTNode leaf1 = SqlUtilFun.lastLeaf(node1);
        ASTNode leaf2 = SqlUtilFun.firstLeaf(node2);
        return SqlSpacing.languageRequiresSpaceBetweenLeafNodes(leaf1, leaf2);
    }

    public static final boolean languageRequiresSpaceBetweenLeafNodes(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        String string = node1.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char c1 = SqlSpacing.safeLast(string);
        String string2 = node2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        char c2 = SqlSpacing.safeFirst(string2);
        if (c1 == '$' && node1.getTextLength() == 1) {
            return false;
        }
        if (CharsKt.isWhitespace((char)c1) || CharsKt.isWhitespace((char)c2)) {
            return false;
        }
        return SqlSpacing.languageRequiresSpacesBetweenChars(c1, c2);
    }

    private static final boolean languageRequiresSpacesBetweenChars(char c1, char c2) {
        return SqlSpacing.languageRequiresSpacesBetweenChars$isWordCategory(c1) && SqlSpacing.languageRequiresSpacesBetweenChars$isWordCategory(c2);
    }

    private static final char safeFirst(String $this$safeFirst) {
        return ((CharSequence)$this$safeFirst).length() > 0 ? $this$safeFirst.charAt(0) : (char)'\u0000';
    }

    private static final char safeLast(String $this$safeLast) {
        int n = $this$safeLast.length();
        return n > 0 ? $this$safeLast.charAt(n - 1) : (char)'\u0000';
    }

    private static final boolean languageRequiresSpacesBetweenChars$isWordCategory(char c) {
        return Character.isLetterOrDigit(c) || WORD_CATEGORY_CHARS.contains(Character.valueOf(c));
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('`'), Character.valueOf('$')};
        WORD_CATEGORY_CHARS = SetsKt.setOf((Object[])objectArray);
    }
}

