/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent.mrfs;

import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.ijent.DockerEelDescriptor;
import com.intellij.docker.ijent.DockerMountsAwareFileSystemProvider;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystemProvider;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.ijent.community.impl.IjentFailSafeFileSystemPosixApiKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import java.io.File;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend;", "Lcom/intellij/platform/eel/provider/MultiRoutingFileSystemBackend;", "<init>", "()V", "fileSystemRecords", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$FileSystemRecord;", "getFileSystemRecords", "()Ljava/util/concurrent/atomic/AtomicReference;", "compute", "Ljava/nio/file/FileSystem;", "localFS", "sanitizedPath", "", "computeImpl", "", "fsRoot", "containerId", "record", "getCustomRoots", "", "getCustomFileStores", "Ljava/nio/file/FileStore;", "FileSystemRecord", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nEelDockerMrfsBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelDockerMrfsBackend.kt\ncom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n626#2,12:150\n1563#2:162\n1634#2,3:163\n1374#2:166\n1460#2,5:167\n1761#2,3:172\n13#3:175\n*S KotlinDebug\n*F\n+ 1 EelDockerMrfsBackend.kt\ncom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend\n*L\n57#1:150,12\n115#1:162\n115#1:163,3\n119#1:166\n119#1:167,5\n52#1:172,3\n128#1:175\n*E\n"})
public final class EelDockerMrfsBackend
implements MultiRoutingFileSystemBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<List<FileSystemRecord>> fileSystemRecords = new AtomicReference<List>(CollectionsKt.emptyList());
    @NotNull
    private static final Logger LOG;
    private static final boolean isWindows;
    private static final int TRUNCATED_CONTAINER_ID_LENGTH = 12;
    @JvmField
    @NotNull
    public static final String DOCKER_PATH_PREFIX;

    @NotNull
    public final AtomicReference<List<FileSystemRecord>> getFileSystemRecords() {
        return this.fileSystemRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public FileSystem compute(@NotNull FileSystem localFS, @NotNull String sanitizedPath) {
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
        if (!StringsKt.startsWith$default((String)sanitizedPath, (String)DOCKER_PATH_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        String string = Companion.extractIdFromPath$intellij_clouds_docker(sanitizedPath);
        if (string == null) {
            return null;
        }
        String containerId = string;
        if (containerId.length() != 12) {
            return null;
        }
        String fsRoot = DOCKER_PATH_PREFIX + containerId;
        List<FileSystemRecord> list = this.fileSystemRecords.updateAndGet(arg_0 -> EelDockerMrfsBackend.compute$lambda$0(containerId, fsRoot, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, (String)"updateAndGet(...)");
        Object object = list;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            FileSystemRecord record = (FileSystemRecord)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)record.getFsRoot(), (Object)fsRoot)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        FileSystemRecord record = single$iv;
        if (record.getFs() == null) {
            object = record;
            synchronized (object) {
                boolean bl = false;
                if (record.getFs() == null) {
                    this.computeImpl(localFS, fsRoot, containerId, record);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return record.getFs();
    }

    private final void computeImpl(FileSystem localFS, String fsRoot, String containerId, FileSystemRecord record) {
        Path localPath = localFS.getPath(fsRoot, new String[0]);
        if (Files.exists(localPath, new LinkOption[0])) {
            LOG.warn("Cannot register a file system for a path that already exists: " + localPath);
            return;
        }
        CoroutineScope scope = DockerMainCoroutineScopeHolder.Companion.getInstance().getScope();
        URI ijentUri = new URI("ijent", "docker", "/" + containerId, null, null);
        TracingFileSystemProvider ijentDefaultProvider = new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance(), null, 2, null);
        DockerEelDescriptor descriptor2 = new DockerEelDescriptor(containerId);
        try {
            IjentFileSystemApi ijentFs = IjentFailSafeFileSystemPosixApiKt.IjentFailSafeFileSystemPosixApi((CoroutineScope)scope, (EelDescriptor)((EelDescriptor)descriptor2));
            ijentDefaultProvider.newFileSystem(ijentUri, IjentNioFileSystemProvider.Companion.newFileSystemMap(ijentFs));
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        Intrinsics.checkNotNull((Object)localPath);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)ijentDefaultProvider;
        FileSystemProvider fileSystemProvider2 = localFS.provider();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider2, (String)"provider(...)");
        IjentEphemeralRootAwareFileSystemProvider ijentFsProvider = new IjentEphemeralRootAwareFileSystemProvider(localPath, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider2, null, 2, null), false);
        DockerMountsAwareFileSystemProvider mountsAwareFileSystemProvider = new DockerMountsAwareFileSystemProvider((FileSystemProvider)ijentFsProvider);
        record.setFs((FileSystem)mountsAwareFileSystemProvider.getFileSystem(ijentUri));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomRoots() {
        void $this$mapTo$iv$iv;
        List<FileSystemRecord> list = this.fileSystemRecords.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void record;
            FileSystemRecord fileSystemRecord = (FileSystemRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(record.getFsRoot());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<FileStore> getCustomFileStores(@NotNull FileSystem localFS) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        List<FileSystemRecord> list = this.fileSystemRecords.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileSystemRecord record = (FileSystemRecord)element$iv$iv;
            boolean bl = false;
            Object object = this.compute(localFS, record.getFsRoot());
            if (object == null || (object = ((FileSystem)object).getFileStores()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object list$iv$iv = object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List compute$lambda$0(String $containerId, String $fsRoot, List fileSystemRecords) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNull((Object)fileSystemRecords);
            Iterable $this$any$iv = fileSystemRecords;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileSystemRecord record = (FileSystemRecord)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)record.getFsRoot(), (Object)$fsRoot)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? fileSystemRecords : CollectionsKt.plus((Collection)fileSystemRecords, (Object)new FileSystemRecord($containerId, null));
    }

    @JvmStatic
    @Nullable
    public static final String extractIdFromPath$intellij_clouds_docker(@NotNull String path2) {
        return Companion.extractIdFromPath$intellij_clouds_docker(path2);
    }

    @JvmStatic
    @Nullable
    public static final String substringAfterPrefix$intellij_clouds_docker(@NotNull String $this$substringAfterPrefix_u24intellij_clouds_docker, @NotNull String prefix) {
        return Companion.substringAfterPrefix$intellij_clouds_docker($this$substringAfterPrefix_u24intellij_clouds_docker, prefix);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelDockerMrfsBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        isWindows = File.separatorChar == '\\';
        DOCKER_PATH_PREFIX = (isWindows ? "//" : "/") + "docker" + (isWindows ? "/" : "-");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u000eJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isWindows", "", "TRUNCATED_CONTAINER_ID_LENGTH", "", "DOCKER_PATH_PREFIX", "", "extractIdFromPath", "path", "extractIdFromPath$intellij_clouds_docker", "substringAfterPrefix", "prefix", "substringAfterPrefix$intellij_clouds_docker", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nEelDockerMrfsBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelDockerMrfsBackend.kt\ncom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String extractIdFromPath$intellij_clouds_docker(@NotNull String path2) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String string4 = this.substringAfterPrefix$intellij_clouds_docker(path2, DOCKER_PATH_PREFIX);
            if (string4 != null && (string3 = StringsKt.substringBefore$default((String)string4, (String)"/", null, (int)2, null)) != null && (string2 = StringsKt.substringBefore$default((String)string3, (String)"\\", null, (int)2, null)) != null) {
                String string5;
                String p0 = string5 = string2;
                boolean bl = false;
                string = ((CharSequence)p0).length() > 0 ? string5 : null;
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        @Nullable
        public final String substringAfterPrefix$intellij_clouds_docker(@NotNull String $this$substringAfterPrefix, @NotNull String prefix) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$substringAfterPrefix, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            if (StringsKt.startsWith$default((String)$this$substringAfterPrefix, (String)prefix, (boolean)false, (int)2, null)) {
                String string2 = $this$substringAfterPrefix.substring(prefix.length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$FileSystemRecord;", "", "containerId", "", "fs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/lang/String;Ljava/nio/file/FileSystem;)V", "getContainerId", "()Ljava/lang/String;", "getFs", "()Ljava/nio/file/FileSystem;", "setFs", "(Ljava/nio/file/FileSystem;)V", "fsRoot", "getFsRoot", "intellij.clouds.docker"})
    public static final class FileSystemRecord {
        @NotNull
        private final String containerId;
        @Nullable
        private volatile FileSystem fs;
        @NotNull
        private final String fsRoot;

        public FileSystemRecord(@NotNull String containerId, @Nullable FileSystem fs) {
            Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
            this.containerId = containerId;
            this.fs = fs;
            this.fsRoot = DOCKER_PATH_PREFIX + this.containerId;
        }

        @NotNull
        public final String getContainerId() {
            return this.containerId;
        }

        @Nullable
        public final FileSystem getFs() {
            return this.fs;
        }

        public final void setFs(@Nullable FileSystem fileSystem) {
            this.fs = fileSystem;
        }

        @NotNull
        public final String getFsRoot() {
            return this.fsRoot;
        }
    }
}

