/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.impl;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapProcessStarter;
import com.intellij.platform.dap.LaunchRequestArguments;
import com.intellij.platform.dap.impl.utils.UtilsKt;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/dap/impl/DapProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "intellij.platform.dap"})
@SourceDebugExtension(value={"SMAP\nDapProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapProgramRunner.kt\ncom/intellij/platform/dap/impl/DapProgramRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n2746#2,3:49\n295#2,2:52\n*S KotlinDebug\n*F\n+ 1 DapProgramRunner.kt\ncom/intellij/platform/dap/impl/DapProgramRunner\n*L\n24#1:49,3\n34#1:52,2\n*E\n"})
public final class DapProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            Iterable $this$none$iv = DapLaunchArgumentsProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    DapLaunchArgumentsProvider it = (DapLaunchArgumentsProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isApplicable(profile)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        String string = executorId;
        return Intrinsics.areEqual((Object)string, (Object)"Debug") ? !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction) : (Intrinsics.areEqual((Object)string, (Object)"Run") ? !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Promise promise;
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Iterable $this$firstOrNull$iv = DapLaunchArgumentsProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DapLaunchArgumentsProvider it = (DapLaunchArgumentsProvider)element$iv;
                boolean bl = false;
                RunProfile runProfile = environment.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                if (!it.isApplicable(runProfile)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        DapLaunchArgumentsProvider dapLaunchArgumentsProvider = v1;
        if (dapLaunchArgumentsProvider == null) {
            return Promises.resolvedPromise(null);
        }
        DapLaunchArgumentsProvider argumentsProvider = dapLaunchArgumentsProvider;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        LaunchRequestArguments arguments = argumentsProvider.getLaunchArguments(project, runProfile);
        Executor executor = environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        Executor executor2 = executor;
        DapProcessStarter processStarter = new DapProcessStarter(environment, executor2, state, arguments.getAdapterId(), arguments.getRequest(), arguments.getArguments());
        String string = executor2.getId();
        switch (string.hashCode()) {
            case 82539: {
                if (string.equals("Run")) break;
                throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
            }
            case 65906227: {
                if (!string.equals("Debug")) throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
                promise = Promises.resolvedPromise((Object)XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, (XDebugProcessStarter)processStarter).getRunContentDescriptor());
                return promise;
            }
        }
        promise = UtilsKt.toPromise(processStarter.startNoDebug());
        return promise;
        throw new IllegalArgumentException("Unsupported executor id: " + executor2.getId());
    }

    @NotNull
    public String getRunnerId() {
        return "DebugAdapterRunner";
    }
}

