/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0004\"\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0004\u00a8\u0006\r"}, d2={"k8sFilePattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "getK8sFilePattern", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "chartFilePattern", "getChartFilePattern", "k8sValuePattern", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "getK8sValuePattern", "k8sKeyValuePattern", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getK8sKeyValuePattern", "intellij.clouds.kubernetes.backend"})
public final class PatternsKt {
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> k8sFilePattern;
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> chartFilePattern;
    @NotNull
    private static final PsiElementPattern.Capture<YAMLScalar> k8sValuePattern;
    @NotNull
    private static final PsiElementPattern.Capture<YAMLKeyValue> k8sKeyValuePattern;

    @NotNull
    public static final PsiElementPattern.Capture<PsiElement> getK8sFilePattern() {
        return k8sFilePattern;
    }

    @NotNull
    public static final PsiElementPattern.Capture<PsiElement> getChartFilePattern() {
        return chartFilePattern;
    }

    @NotNull
    public static final PsiElementPattern.Capture<YAMLScalar> getK8sValuePattern() {
        return k8sValuePattern;
    }

    @NotNull
    public static final PsiElementPattern.Capture<YAMLKeyValue> getK8sKeyValuePattern() {
        return k8sKeyValuePattern;
    }

    static {
        ObjectPattern objectPattern = PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(PsiElement element, ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                PsiFile psiFile = element.getContainingFile();
                return KubernetesUtilKt.isKubernetesYaml((PsiFile)(psiFile != null ? psiFile.getOriginalFile() : null));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        k8sFilePattern = (PsiElementPattern.Capture)objectPattern;
        ObjectPattern objectPattern2 = PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accepts(PsiElement element, ProcessingContext context2) {
                CustomChartSupport it;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)element);
                if (virtualFile == null) {
                    return false;
                }
                VirtualFile vfsFile = virtualFile;
                if (Chart.Companion.isChartFile(vfsFile)) return true;
                if (Chart.Companion.isRequirementsFile(vfsFile)) return true;
                Iterable $this$any$iv = CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes_backend();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    it = (CustomChartSupport)element$iv;
                    boolean bl = false;
                } while (!it.isValueContainer(vfsFile));
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern2, (String)"with(...)");
        chartFilePattern = (PsiElementPattern.Capture)objectPattern2;
        ObjectPattern objectPattern3 = PlatformPatterns.psiElement(YAMLScalar.class).and((ElementPattern)k8sFilePattern);
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern3, (String)"and(...)");
        k8sValuePattern = (PsiElementPattern.Capture)objectPattern3;
        ObjectPattern objectPattern4 = PlatformPatterns.psiElement(YAMLKeyValue.class).and((ElementPattern)k8sFilePattern);
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern4, (String)"and(...)");
        k8sKeyValuePattern = (PsiElementPattern.Capture)objectPattern4;
    }
}

