/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.inlays;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.RoundWithBackgroundPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.codeInsight.hints.presentation.TextInlayPresentation;
import com.intellij.codeInsight.hints.presentation.WithAttributesPresentation;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.inlays.KubernetesInlayHintsService;
import com.intellij.kubernetes.inlays.KubernetesInlayKeys;
import com.intellij.kubernetes.inlays.KubernetesPodStatusesInlayProvider;
import com.intellij.kubernetes.inlays.KubernetesPodStatusesInlayProviderKt;
import com.intellij.kubernetes.logs.BackendKubernetesLogUtilsKt;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.util.KubernetesPodStateKt;
import com.intellij.kubernetes.util.KubernetesStateWatcher;
import com.intellij.kubernetes.util.PodState;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import com.intellij.kubernetes.view.nodes.KubernetesContextServiceViewContributor;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewContributor;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewContributorKt;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptorKt;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodsServiceViewContributor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesWorkloadsServiceViewContributor;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1JobStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0003VWXB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001bH\u0002J8\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u001e\u0010\u001e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001bH\u0002J(\u0010!\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J(\u0010%\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J \u0010'\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010-\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0018\u00010.2\u0006\u0010/\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u00100\u001a\u00020\u000f2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#02H\u0002J7\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u00020\b2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H50\u001f2\u0006\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020 H\u0002J\"\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J \u0010=\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\"\u0010>\u001a\u0004\u0018\u00010<2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0018\u0010?\u001a\u00020@2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J \u0010A\u001a\u00020B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020EH\u0002J&\u0010F\u001a\u00020B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010G\u001a\u00020#2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00170IH\u0002J>\u0010J\u001a\u00020B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010K\u001a\u00020B2\u0006\u0010D\u001a\u00020E2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010I2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010#H\u0002J>\u0010M\u001a\u00020B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010G\u001a\u00020#2\u0006\u0010D\u001a\u00020E2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010I2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010#H\u0002JF\u0010N\u001a\u00020B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u00020E2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010I2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010#H\u0002J*\u0010S\u001a\u0004\u0018\u00010B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010T\u001a\u00020#2\u0006\u0010/\u001a\u00020\bH\u0002J\"\u0010U\u001a\u0004\u0018\u00010B2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector;", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCachedKubernetesObject", "Lkotlinx/coroutines/Deferred;", "Lio/kubernetes/client/common/KubernetesObject;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "openPodsServiceView", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "findDescriptor", "Lkotlin/Function1;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesPodServiceViewContributorDescriptor;", "openPodsLogs", "podFilter", "", "Lio/kubernetes/client/openapi/models/V1Pod;", "openJobPodsLogs", "jobName", "", "namespace", "openPodLogs", "name", "openDeploymentPodsLogs", "deployment", "Lio/kubernetes/client/openapi/models/V1Deployment;", "isSupportedMetatype", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "currentApiModel", "resourceNameAndNamespace", "Lkotlin/Pair;", "obj", "labelsMatch", "labels", "", "selector", "findByNameAndNamespace", "T", "items", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)Lio/kubernetes/client/common/KubernetesObject;", "isTerminating", "podHasIssues", "pod", "computePodStatus", "Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$KubeStatus;", "hasIssuesForJobPods", "computeJobStatus", "computeDeploymentCounts", "Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$DeploymentStatus;", "asK8sInlay", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "base", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "buildLogsButtonPresentation", "text", "onClick", "Lkotlin/Function0;", "buildPillFromContent", "content", "tooltip", "buildStatusPill", "buildIconNumberPill", "icon", "Ljavax/swing/Icon;", "number", "", "buildPodOrJobPresentation", "kind", "buildDeploymentPresentation", "KubeStatus", "DeploymentStatus", "Ui", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodStatusesInlayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodStatusesInlayProvider.kt\ncom/intellij/kubernetes/inlays/PodStatusesInlayCollector\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,582:1\n66#2,2:583\n30#3,2:585\n30#3,2:587\n1#4:589\n295#5,2:590\n295#5,2:595\n1761#5,3:597\n1761#5,3:600\n1761#5,3:603\n1788#5,4:606\n774#5:612\n865#5,2:613\n295#5,2:615\n774#5:617\n865#5,2:618\n168#6,3:592\n37#7,2:610\n*S KotlinDebug\n*F\n+ 1 KubernetesPodStatusesInlayProvider.kt\ncom/intellij/kubernetes/inlays/PodStatusesInlayCollector\n*L\n105#1:583,2\n132#1:585,2\n155#1:587,2\n212#1:590,2\n258#1:595,2\n281#1:597,3\n299#1:600,3\n300#1:603,3\n526#1:606,4\n173#1:612\n173#1:613,2\n182#1:615,2\n193#1:617\n193#1:618,2\n221#1:592,3\n580#1:610,2\n*E\n"})
final class PodStatusesInlayCollector
implements InlayHintsCollector {
    @NotNull
    private final CoroutineScope coroutineScope;

    public PodStatusesInlayCollector(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    private final Deferred<KubernetesObject> getCachedKubernetesObject(YAMLDocument document, Project project, CoroutineScope scope2) {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)document, () -> PodStatusesInlayCollector.getCachedKubernetesObject$lambda$0(scope2, document, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Deferred)object;
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        InlayPresentation inlayPresentation;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Project project = editor.getProject();
        if (project == null) {
            return true;
        }
        Project project2 = project;
        YAMLKeyValue yAMLKeyValue = element instanceof YAMLKeyValue ? (YAMLKeyValue)element : null;
        if (yAMLKeyValue == null) {
            return true;
        }
        YAMLKeyValue yamlKey = yAMLKeyValue;
        YAMLValue yAMLValue = yamlKey.getValue();
        YAMLScalar yAMLScalar = yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
        if (yAMLScalar == null) {
            return true;
        }
        YAMLScalar value = yAMLScalar;
        if (!this.isSupportedMetatype(yamlKey)) {
            return true;
        }
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)yamlKey);
        String typeName = yamlMetaType != null ? yamlMetaType.getTypeName() : null;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy(yamlKey);
        String fieldName = metaTypeProxy != null && (metaTypeProxy = metaTypeProxy.getField()) != null ? metaTypeProxy.getName() : null;
        boolean isMetadataName = Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta") && Intrinsics.areEqual((Object)fieldName, (Object)"name");
        boolean isDeploymentReplicas = Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.apps.v1.DeploymentSpec") && Intrinsics.areEqual((Object)fieldName, (Object)"replicas");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)yamlKey;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLDocument yAMLDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLDocument.class, (boolean)true);
        if (yAMLDocument == null) {
            return true;
        }
        YAMLDocument document = yAMLDocument;
        Deferred<KubernetesObject> cacheData = this.getCachedKubernetesObject(document, project2, this.coroutineScope);
        if (!cacheData.isCompleted()) {
            return true;
        }
        KubernetesObject kubernetesObject = (KubernetesObject)cacheData.getCompleted();
        if (kubernetesObject == null) {
            return true;
        }
        KubernetesObject kubernetesObject2 = kubernetesObject;
        String string = kubernetesObject2.getKind();
        if (string == null) {
            return true;
        }
        String kind = string;
        if (isMetadataName) {
            inlayPresentation = this.buildPodOrJobPresentation(editor, project2, kind, kubernetesObject2);
        } else if (isDeploymentReplicas && Intrinsics.areEqual((Object)kind, (Object)"Deployment")) {
            V1Deployment v1Deployment = kubernetesObject2 instanceof V1Deployment ? (V1Deployment)kubernetesObject2 : null;
            if (v1Deployment == null) {
                return true;
            }
            V1Deployment deployment = v1Deployment;
            inlayPresentation = this.buildDeploymentPresentation(editor, project2, deployment);
        } else {
            return true;
        }
        InlayPresentation presentation = inlayPresentation;
        if (presentation == null) {
            return true;
        }
        sink.addInlineElement(value.getTextRange().getEndOffset(), true, presentation, true);
        return true;
    }

    private final void openPodsServiceView(Project project, KubernetesApiModelInterface apiModel2, Function1<? super KubernetesPodServiceViewContributorDescriptor, Boolean> findDescriptor) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesInlayHintsService> serviceClass$iv = KubernetesInlayHintsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((KubernetesInlayHintsService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, findDescriptor, apiModel2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<KubernetesPodServiceViewContributorDescriptor, Boolean> $findDescriptor;
            final /* synthetic */ KubernetesApiModelInterface $apiModel;
            {
                this.$project = $project;
                this.$findDescriptor = $findDescriptor;
                this.$apiModel = $apiModel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = (KubernetesServiceViewContributor)ServiceViewContributor.findRootContributor(KubernetesServiceViewContributor.class);
                        if (v0 == null) {
                            return Unit.INSTANCE;
                        }
                        root = v0;
                        var5_5 = root.getServices(this.$project);
                        $i$f$filterIsInstance = false;
                        var7_10 = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof KubernetesContextServiceViewContributor)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        $i$f$filterIsInstance = this.$apiModel;
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            it = (KubernetesContextServiceViewContributor)element$iv;
                            $i$a$-firstOrNull-PodStatusesInlayCollector$openPodsServiceView$1$ctx$1 = false;
                            if (!(it.getApiModel() == $i$f$filterIsInstance)) continue;
                            v1 = element$iv;
                            ** GOTO lbl30
                        }
                        v1 = null;
lbl30:
                        // 2 sources

                        v2 = v1;
                        if (v2 == null) {
                            return Unit.INSTANCE;
                        }
                        ctx = v2;
                        $this$filterIsInstance$iv = ctx.getServices(this.$project);
                        $i$f$filterIsInstance = false;
                        destination$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof KubernetesWorkloadsServiceViewContributor)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        v3 = (KubernetesWorkloadsServiceViewContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv /* !! */ ));
                        if (v3 == null) {
                            return Unit.INSTANCE;
                        }
                        workloads = v3;
                        $this$filterIsInstance$iv = workloads.getServices(this.$project);
                        $i$f$filterIsInstance = false;
                        destination$iv$iv /* !! */  = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterIsInstanceTo = false;
                        for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof KubernetesPodsServiceViewContributor)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        v4 = (KubernetesPodsServiceViewContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                        if (v4 == null) {
                            return Unit.INSTANCE;
                        }
                        pods = v4;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)root);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)ctx);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)workloads);
                        this.L$3 = pods;
                        this.label = 1;
                        v5 = pods.refresh((Continuation)this);
                        if (v5 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl78
                    }
                    case 1: {
                        pods = (KubernetesPodsServiceViewContributor)this.L$3;
                        workloads = (KubernetesWorkloadsServiceViewContributor)this.L$2;
                        ctx = (KubernetesContextServiceViewContributor)this.L$1;
                        root = (KubernetesServiceViewContributor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl78:
                        // 2 sources

                        v6 = this.$findDescriptor;
                        if (v6 == null) ** GOTO lbl95
                        var8_15 = v6;
                        var9_18 = this.$project;
                        predicate = var8_15;
                        $i$a$-let-PodStatusesInlayCollector$openPodsServiceView$1$descriptor$1 = false;
                        var12_28 = pods.getServices(var9_18);
                        var13_31 = var12_28.iterator();
                        while (var13_31.hasNext()) {
                            var14_32 = var13_31.next();
                            if (!((Boolean)predicate.invoke(var14_32)).booleanValue()) continue;
                            v7 = var14_32;
                            ** GOTO lbl92
                        }
                        v7 = null;
lbl92:
                        // 2 sources

                        v8 = v7;
                        ** GOTO lbl96
lbl95:
                        // 1 sources

                        v8 = null;
lbl96:
                        // 2 sources

                        descriptor = v8;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)root);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)ctx);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)workloads);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)pods);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                        this.label = 2;
                        v9 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, this.$project, pods, null){
                            int label;
                            final /* synthetic */ KubernetesPodServiceViewContributorDescriptor $descriptor;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ KubernetesPodsServiceViewContributor $pods;
                            {
                                this.$descriptor = $descriptor;
                                this.$project = $project;
                                this.$pods = $pods;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Promise promise = this.$descriptor != null ? KubernetesServiceViewContributorKt.selectKubernetesService((Project)this.$project, (Object)this.$descriptor) : KubernetesServiceViewContributorKt.selectKubernetesService((Project)this.$project, (Object)this.$pods);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v9 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl115
                    }
                    case 2: {
                        descriptor = (KubernetesPodServiceViewContributorDescriptor)this.L$4;
                        pods = (KubernetesPodsServiceViewContributor)this.L$3;
                        workloads = (KubernetesWorkloadsServiceViewContributor)this.L$2;
                        ctx = (KubernetesContextServiceViewContributor)this.L$1;
                        root = (KubernetesServiceViewContributor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl115:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void openPodsServiceView$default(PodStatusesInlayCollector podStatusesInlayCollector, Project project, KubernetesApiModelInterface kubernetesApiModelInterface, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        podStatusesInlayCollector.openPodsServiceView(project, kubernetesApiModelInterface, (Function1<? super KubernetesPodServiceViewContributorDescriptor, Boolean>)function1);
    }

    private final void openPodsLogs(Project project, KubernetesApiModelInterface apiModel2, Function1<? super List<? extends V1Pod>, ? extends List<? extends V1Pod>> podFilter) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesInlayHintsService> serviceClass$iv = KubernetesInlayHintsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((KubernetesInlayHintsService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(apiModel2, podFilter, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KubernetesApiModelInterface $apiModel;
            final /* synthetic */ Function1<List<? extends V1Pod>, List<V1Pod>> $podFilter;
            {
                this.$apiModel = $apiModel;
                this.$podFilter = $podFilter;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var20_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 = $this$launch;
                        var4_5 = this.$apiModel;
                        var5_6 = this.$podFilter;
                        $this$invokeSuspend_u24lambda_u240 = var3_4;
                        $i$a$-runCatching-PodStatusesInlayCollector$openPodsLogs$1$1 = 0;
                        podWatcher = var4_5.getResource(KubernetesEntity.Pod);
                        podWatcher.scheduleStartWatchingIfAllowed();
                        var9_12 = var5_6;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = var4_5;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)podWatcher);
                        this.L$4 = var9_12;
                        this.I$0 = $i$a$-runCatching-PodStatusesInlayCollector$openPodsLogs$1$1;
                        this.label = 1;
                        v0 = podWatcher.getValueOrEmptyList((Continuation)this);
                        ** if (v0 != var20_3) goto lbl27
lbl26:
                        // 1 sources

                        return var20_3;
lbl27:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 1: {
                        $i$a$-runCatching-PodStatusesInlayCollector$openPodsLogs$1$1 = this.I$0;
                        var9_12 = (Function1<List<? extends V1Pod>, List<V1Pod>>)this.L$4;
                        podWatcher = (KubernetesStateWatcher)this.L$3;
                        $this$invokeSuspend_u24lambda_u240 = (CoroutineScope)this.L$2;
                        var4_5 = (KubernetesApiModelInterface)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl38:
                        // 2 sources

                        $this$flatMap$iv = (Iterable)var9_12.invoke(v0);
                        $i$f$flatMap = false;
                        var12_15 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            p = (V1Pod)element$iv$iv;
                            $i$a$-flatMap-PodStatusesInlayCollector$openPodsLogs$1$1$containers$1 = false;
                            list$iv$iv = KubernetesPodServiceViewContributorDescriptorKt.getPodContainers((Context)var4_5.getCurrentContextObject(), (V1Pod)p);
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        containers = (List)destination$iv$iv;
                        if (!(((Collection)containers).isEmpty() == false)) ** GOTO lbl72
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)podWatcher);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)containers);
                        this.L$4 = null;
                        this.I$0 = $i$a$-runCatching-PodStatusesInlayCollector$openPodsLogs$1$1;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KubernetesContextLogsManager>, Object>(var4_5, (List<? extends KubernetesContainerObject>)containers, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ KubernetesApiModelInterface $apiModel;
                            final /* synthetic */ List<KubernetesContainerObject> $containers;
                            {
                                this.$apiModel = $apiModel;
                                this.$containers = $containers;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$withContext;
                                        ResultKt.throwOnFailure((Object)$result);
                                        return BackendKubernetesLogUtilsKt.openLogsInEditor$default(this.$apiModel, this.$containers, $this$withContext, null, 8, null);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super KubernetesContextLogsManager> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        ** if (v1 != var20_3) goto lbl62
lbl61:
                        // 1 sources

                        return var20_3;
lbl62:
                        // 1 sources

                        ** GOTO lbl72
                    }
                    case 2: {
                        $i$a$-runCatching-PodStatusesInlayCollector$openPodsLogs$1$1 = this.I$0;
                        containers = (List)this.L$3;
                        podWatcher = (KubernetesStateWatcher)this.L$2;
                        $this$invokeSuspend_u24lambda_u240 = (CoroutineScope)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl72:
                            // 3 sources

                            var6_7 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var7_9) {
                            var6_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_9));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void openJobPodsLogs(Project project, KubernetesApiModelInterface apiModel2, String jobName, String namespace) {
        this.openPodsLogs(project, apiModel2, (Function1<? super List<? extends V1Pod>, ? extends List<? extends V1Pod>>)((Function1)arg_0 -> PodStatusesInlayCollector.openJobPodsLogs$lambda$0(namespace, jobName, arg_0)));
    }

    private final void openPodLogs(Project project, KubernetesApiModelInterface apiModel2, String name, String namespace) {
        this.openPodsLogs(project, apiModel2, (Function1<? super List<? extends V1Pod>, ? extends List<? extends V1Pod>>)((Function1)arg_0 -> PodStatusesInlayCollector.openPodLogs$lambda$0(name, namespace, arg_0)));
    }

    private final void openDeploymentPodsLogs(Project project, KubernetesApiModelInterface apiModel2, V1Deployment deployment) {
        Object selector;
        Object object = deployment.getSpec();
        if (object == null || (object = object.getSelector()) == null || (object = object.getMatchLabels()) == null) {
            object = MapsKt.emptyMap();
        }
        if ((selector = object).isEmpty()) {
            return;
        }
        Object object2 = deployment.getMetadata();
        if (object2 == null || (object2 = object2.getNamespace()) == null) {
            object2 = apiModel2.getNamespace();
        }
        Object namespace = object2;
        this.openPodsLogs(project, apiModel2, (Function1<? super List<? extends V1Pod>, ? extends List<? extends V1Pod>>)((Function1)arg_0 -> PodStatusesInlayCollector.openDeploymentPodsLogs$lambda$0((String)namespace, this, (Map)selector, arg_0)));
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSupportedMetatype(YAMLKeyValue element) {
        block3: {
            v0 = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)element);
            typeName = v0 != null ? v0.getTypeName() : null;
            v1 = KubernetesUtilKt.getValueK8sMetaTypeProxy(element);
            v2 = v1 != null && (v1 = v1.getField()) != null ? v1.getName() : (fieldName = null);
            if (Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.apps.v1.DeploymentSpec") && Intrinsics.areEqual((Object)fieldName, (Object)"replicas")) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta") || !Intrinsics.areEqual((Object)fieldName, (Object)"name")) break block3;
            v3 = YamlUtilKt.getTopLevelMapping((PsiElement)((PsiElement)element));
            if (v3 == null || (v3 = YamlUtilKt.get((YAMLMapping)v3, (String)"kind")) == null) ** GOTO lbl-1000
            it = v3;
            $i$a$-let-PodStatusesInlayCollector$isSupportedMetatype$kind$1 = false;
            v4 = it instanceof YAMLScalar ? (YAMLScalar)it : null;
            v3 = v4;
            if (v4 != null) {
                v5 = v3.getTextValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = null;
            }
            kind = v5;
            return Intrinsics.areEqual(kind, (Object)"Pod") != false || Intrinsics.areEqual(kind, (Object)"Job") != false || Intrinsics.areEqual(kind, (Object)"Deployment") != false;
        }
        return false;
    }

    private final KubernetesApiModelInterface currentApiModel(Project project) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = KubernetesApiProvider.Companion.getInstance(project).getApiModels();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KubernetesApiModelInterface it = (KubernetesApiModelInterface)element$iv;
                boolean bl = false;
                if (!it.isSelectedAsCurrentCluster()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Pair<String, String> resourceNameAndNamespace(KubernetesObject obj, KubernetesApiModelInterface apiModel2) {
        Object object = obj.getMetadata();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object name = object;
        Object object2 = obj.getMetadata();
        if (object2 == null || (object2 = object2.getNamespace()) == null) {
            object2 = apiModel2.getNamespace();
        }
        Object namespace = object2;
        return TuplesKt.to((Object)name, (Object)namespace);
    }

    private final boolean labelsMatch(Map<String, String> labels, Map<String, String> selector) {
        boolean bl;
        block3: {
            Map<String, String> $this$all$iv = selector;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<String, String>> iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String k = entry.getKey();
                    String v = entry.getValue();
                    if (Intrinsics.areEqual((Object)labels.get(k), (Object)v)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T extends KubernetesObject> T findByNameAndNamespace(List<? extends T> items, String name, String namespace) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = items;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return (T)((KubernetesObject)v0);
            }
            element$iv = iterator.next();
            KubernetesObject it = (KubernetesObject)element$iv;
            boolean bl2 = false;
            V1ObjectMeta v1ObjectMeta = it.getMetadata();
            if (Intrinsics.areEqual((Object)(v1ObjectMeta != null ? v1ObjectMeta.getName() : null), (Object)name)) {
                Object object = it.getMetadata();
                if (object == null || (object = object.getNamespace()) == null) {
                    object = "default";
                }
                if (Intrinsics.areEqual((Object)object, (Object)namespace)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return (T)((KubernetesObject)v0);
    }

    private final boolean isTerminating(KubernetesObject obj) {
        V1ObjectMeta v1ObjectMeta = obj.getMetadata();
        return (v1ObjectMeta != null ? v1ObjectMeta.getDeletionTimestamp() : null) != null;
    }

    private final boolean podHasIssues(V1Pod pod) {
        PodState state = KubernetesPodStateKt.detectPodState((V1Pod)pod);
        return Intrinsics.areEqual((Object)state.getPodPhase().name(), (Object)"FAILED") || !Intrinsics.areEqual((Object)state.getPodStatus().name(), (Object)"OK");
    }

    private final KubeStatus computePodStatus(KubernetesApiModelInterface apiModel2, String name, String namespace) {
        KubeStatus kubeStatus;
        KubernetesStateWatcher watcher = apiModel2.getResource(KubernetesEntity.Pod);
        watcher.scheduleStartWatchingIfAllowed();
        V1Pod v1Pod = (V1Pod)this.findByNameAndNamespace((List)watcher.getValues().getValue(), name, namespace);
        if (v1Pod == null) {
            return null;
        }
        V1Pod pod = v1Pod;
        if (this.isTerminating((KubernetesObject)pod)) {
            return KubeStatus.TERMINATING;
        }
        if (this.podHasIssues(pod)) {
            kubeStatus = KubeStatus.ERROR;
        } else {
            V1PodStatus v1PodStatus = pod.getStatus();
            kubeStatus = KubeStatus.Companion.fromPodPhase(v1PodStatus != null ? v1PodStatus.getPhase() : null);
        }
        return kubeStatus;
    }

    private final boolean hasIssuesForJobPods(KubernetesApiModelInterface apiModel2, String name, String namespace) {
        Object object;
        Object object2 = this;
        try {
            boolean bl;
            block6: {
                PodStatusesInlayCollector $this$hasIssuesForJobPods_u24lambda_u240 = object2;
                boolean bl2 = false;
                KubernetesStateWatcher podWatcher = apiModel2.getResource(KubernetesEntity.Pod);
                podWatcher.scheduleStartWatchingIfAllowed();
                Iterable $this$any$iv = (Iterable)podWatcher.getValues().getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Object object3;
                        Object podNamespace;
                        V1Pod p = (V1Pod)element$iv;
                        boolean bl3 = false;
                        Object object4 = p.getMetadata();
                        if (object4 == null || (object4 = object4.getNamespace()) == null) {
                            object4 = "default";
                        }
                        if (!(!Intrinsics.areEqual((Object)(podNamespace = object4), (Object)namespace) || !Intrinsics.areEqual((object3 = p.getMetadata()) != null && (object3 = object3.getLabels()) != null ? (String)object3.get("job-name") : null, (Object)name) ? false : $this$hasIssuesForJobPods_u24lambda_u240.podHasIssues(p))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            object = Result.constructor-impl((Object)bl);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final KubeStatus computeJobStatus(KubernetesApiModelInterface apiModel2, String name, String namespace) {
        KubeStatus kubeStatus;
        boolean bl;
        boolean failedCond;
        V1JobStatus jobStatus;
        block16: {
            boolean bl2;
            List conditions;
            block15: {
                KubernetesStateWatcher watcher = apiModel2.getResource(KubernetesEntity.Job);
                watcher.scheduleStartWatchingIfAllowed();
                V1Job v1Job = (V1Job)this.findByNameAndNamespace((List)watcher.getValues().getValue(), name, namespace);
                if (v1Job == null) {
                    return null;
                }
                V1Job job2 = v1Job;
                if (this.isTerminating((KubernetesObject)job2)) {
                    return KubeStatus.TERMINATING;
                }
                V1JobStatus v1JobStatus = jobStatus = job2.getStatus();
                List list = v1JobStatus != null ? v1JobStatus.getConditions() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                conditions = list;
                Iterable $this$any$iv = conditions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        V1JobCondition it = (V1JobCondition)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"Failed") && StringsKt.equals((String)it.getStatus(), (String)"true", (boolean)true))) continue;
                        bl2 = true;
                        break block15;
                    }
                    bl2 = false;
                }
            }
            failedCond = bl2;
            Iterable $this$any$iv = conditions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    V1JobCondition it = (V1JobCondition)element$iv;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"Complete") && StringsKt.equals((String)it.getStatus(), (String)"true", (boolean)true))) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        boolean completeCond = bl;
        if (failedCond) {
            kubeStatus = KubeStatus.FAILED;
        } else if (completeCond) {
            kubeStatus = KubeStatus.SUCCEEDED;
        } else if (this.hasIssuesForJobPods(apiModel2, name, namespace)) {
            kubeStatus = KubeStatus.FAILED;
        } else {
            Object object = jobStatus;
            int failed = object != null && (object = object.getFailed()) != null ? (Integer)object : 0;
            Object object2 = jobStatus;
            int succeeded = object2 != null && (object2 = object2.getSucceeded()) != null ? (Integer)object2 : 0;
            Object object3 = jobStatus;
            int active = object3 != null && (object3 = object3.getActive()) != null ? (Integer)object3 : 0;
            kubeStatus = failed > 0 ? KubeStatus.FAILED : (succeeded > 0 ? KubeStatus.SUCCEEDED : (active > 0 ? KubeStatus.RUNNING : KubeStatus.PENDING));
        }
        return kubeStatus;
    }

    private final DeploymentStatus computeDeploymentCounts(KubernetesApiModelInterface apiModel2, V1Deployment deployment) {
        Object selector;
        Object object = deployment.getSpec();
        if (object == null || (object = object.getSelector()) == null || (object = object.getMatchLabels()) == null) {
            object = MapsKt.emptyMap();
        }
        if ((selector = object).isEmpty()) {
            return new DeploymentStatus(0, 0, 0, 0, new LinkedHashMap());
        }
        Object object2 = deployment.getMetadata();
        if (object2 == null || (object2 = object2.getNamespace()) == null) {
            object2 = apiModel2.getNamespace();
        }
        Object namespace = object2;
        KubernetesStateWatcher podWatcher = apiModel2.getResource(KubernetesEntity.Pod);
        podWatcher.scheduleStartWatchingIfAllowed();
        DeploymentStatus status = new DeploymentStatus(0, 0, 0, 0, new LinkedHashMap());
        for (V1Pod pod : (List)podWatcher.getValues().getValue()) {
            Object object3;
            Object object4 = pod.getMetadata();
            if (object4 == null || (object4 = object4.getNamespace()) == null) {
                object4 = "default";
            }
            if (!Intrinsics.areEqual((Object)object4, (Object)namespace)) continue;
            Object object5 = pod.getMetadata();
            if (object5 == null || (object5 = object5.getLabels()) == null) {
                object5 = MapsKt.emptyMap();
            }
            if (!this.labelsMatch((Map<String, String>)object5, (Map<String, String>)selector)) continue;
            V1ObjectMeta v1ObjectMeta = pod.getMetadata();
            if ((v1ObjectMeta != null ? v1ObjectMeta.getDeletionTimestamp() : null) != null) {
                int n = status.getTerminating();
                status.setTerminating(n + 1);
                continue;
            }
            PodState state = KubernetesPodStateKt.detectPodState((V1Pod)pod);
            if (Intrinsics.areEqual((Object)state.getPodPhase().name(), (Object)"FAILED") || !Intrinsics.areEqual((Object)state.getPodStatus().name(), (Object)"OK")) {
                int n = status.getError();
                status.setError(n + 1);
                object3 = status.getErrorBreakdown();
                String string = state.getPodStatus().getLabel();
                Integer n2 = status.getErrorBreakdown().get(state.getPodStatus().getLabel());
                Integer n3 = (n2 != null ? n2 : 0) + 1;
                object3.put(string, n3);
                continue;
            }
            V1PodStatus v1PodStatus = pod.getStatus();
            object3 = v1PodStatus != null ? v1PodStatus.getPhase() : null;
            if (object3 == null) continue;
            int n = -1;
            switch (((String)object3).hashCode()) {
                case 2096857181: {
                    if (((String)object3).equals("Failed")) {
                        n = 1;
                    }
                    break;
                }
                case -1079530081: {
                    if (((String)object3).equals("Running")) {
                        n = 2;
                    }
                    break;
                }
                case 982065527: {
                    if (((String)object3).equals("Pending")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    int n4 = status.getRunning();
                    status.setRunning(n4 + 1);
                    break;
                }
                case 3: {
                    int n5 = status.getPending();
                    status.setPending(n5 + 1);
                    break;
                }
                case 1: {
                    int n6 = status.getError();
                    status.setError(n6 + 1);
                }
            }
        }
        return status;
    }

    private final InlayPresentation asK8sInlay(Editor editor, InlayPresentation base, TextAttributesKey attributesKey) {
        return (InlayPresentation)new WithAttributesPresentation(base, attributesKey, editor, new WithAttributesPresentation.AttributesFlags().withIsDefault(true));
    }

    private final InlayPresentation buildLogsButtonPresentation(Editor editor, String text, Function0<Unit> onClick) {
        Ui ui = new Ui(editor);
        InlayTextMetricsStorage metrics = InlayHintsUtils.INSTANCE.getTextMetricStorage(editor);
        InsetPresentation bare = new InsetPresentation((InlayPresentation)new TextInlayPresentation(metrics, true, text), 0, 0, 1, 1, 6, null);
        InlayPresentation centered = ui.getScale().lineCentered((InlayPresentation)bare);
        InlayPresentation spaced = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)ui.getScale(), (InlayPresentation)centered, (int)6, (int)0, (int)0, (int)0, (int)28, null);
        TextAttributesKey textAttributesKey = EditorColors.REFERENCE_HYPERLINK_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"REFERENCE_HYPERLINK_COLOR");
        WithAttributesPresentation blueText = new WithAttributesPresentation(spaced, textAttributesKey, editor, new WithAttributesPresentation.AttributesFlags().withSkipEffects(true));
        InlayPresentation clickable = ui.getFactory().onClick((InlayPresentation)blueText, MouseButton.Left, (arg_0, arg_1) -> PodStatusesInlayCollector.buildLogsButtonPresentation$lambda$0(onClick, arg_0, arg_1));
        PresentationFactory presentationFactory = ui.getFactory();
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        InlayPresentation withCursor = presentationFactory.withCursorOnHover(clickable, cursor);
        return ui.withDefaultContextMenu(withCursor);
    }

    private final InlayPresentation buildPillFromContent(Editor editor, InlayPresentation content, TextAttributesKey attributesKey, Function0<Unit> onClick, String tooltip) {
        Ui ui = new Ui(editor);
        InlayPresentation padded = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)ui.getScale(), (InlayPresentation)content, (int)7, (int)7, (int)0, (int)0, (int)24, null);
        RoundWithBackgroundPresentation pill = new RoundWithBackgroundPresentation(padded, 8, 8, null, 0.0f, 24, null);
        InlayPresentation centered = ui.getScale().lineCentered((InlayPresentation)pill);
        InlayPresentation pres = this.asK8sInlay(editor, centered, attributesKey);
        if (tooltip != null) {
            pres = ui.getFactory().withTooltip(tooltip, pres);
        }
        InlayPresentation clickable = onClick != null ? ui.getFactory().referenceOnHover(pres, (arg_0, arg_1) -> PodStatusesInlayCollector.buildPillFromContent$lambda$0(onClick, arg_0, arg_1)) : pres;
        return ui.withDefaultContextMenu(clickable);
    }

    static /* synthetic */ InlayPresentation buildPillFromContent$default(PodStatusesInlayCollector podStatusesInlayCollector, Editor editor, InlayPresentation inlayPresentation, TextAttributesKey textAttributesKey, Function0 function0, String string, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        return podStatusesInlayCollector.buildPillFromContent(editor, inlayPresentation, textAttributesKey, (Function0<Unit>)function0, string);
    }

    private final InlayPresentation buildStatusPill(Editor editor, String text, TextAttributesKey attributesKey, Function0<Unit> onClick, String tooltip) {
        Ui ui = new Ui(editor);
        InlayTextMetricsStorage metrics = InlayHintsUtils.INSTANCE.getTextMetricStorage(editor);
        InsetPresentation textInset = new InsetPresentation((InlayPresentation)new TextInlayPresentation(metrics, true, text), 0, 0, 1, 1, 6, null);
        InlayPresentation content = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)ui.getScale(), (InlayPresentation)((InlayPresentation)textInset), (int)0, (int)0, (int)2, (int)2, (int)6, null);
        return this.buildPillFromContent(editor, content, attributesKey, onClick, tooltip);
    }

    static /* synthetic */ InlayPresentation buildStatusPill$default(PodStatusesInlayCollector podStatusesInlayCollector, Editor editor, String string, TextAttributesKey textAttributesKey, Function0 function0, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return podStatusesInlayCollector.buildStatusPill(editor, string, textAttributesKey, (Function0<Unit>)function0, string2);
    }

    private final InlayPresentation buildIconNumberPill(Editor editor, Icon icon, int number, TextAttributesKey attributesKey, Function0<Unit> onClick, String tooltip) {
        Ui ui = new Ui(editor);
        InlayTextMetricsStorage metrics = InlayHintsUtils.INSTANCE.getTextMetricStorage(editor);
        InlayPresentation iconPres = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)ui.getScale(), (InlayPresentation)((InlayPresentation)ui.getFactory().icon(icon)), (int)0, (int)0, (int)2, (int)2, (int)6, null);
        InsetPresentation numberBare = new InsetPresentation((InlayPresentation)new TextInlayPresentation(metrics, true, String.valueOf(number)), 0, 0, 1, 1, 6, null);
        InlayPresentation numberPres = ui.getScale().lineCentered(ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)ui.getScale(), (InlayPresentation)((InlayPresentation)numberBare), (int)0, (int)0, (int)2, (int)2, (int)6, null));
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{iconPres, numberPres};
        InlayPresentation content = ui.seq(inlayPresentationArray);
        return this.buildPillFromContent(editor, content, attributesKey, onClick, tooltip);
    }

    static /* synthetic */ InlayPresentation buildIconNumberPill$default(PodStatusesInlayCollector podStatusesInlayCollector, Editor editor, Icon icon, int n, TextAttributesKey textAttributesKey, Function0 function0, String string, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function0 = null;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        return podStatusesInlayCollector.buildIconNumberPill(editor, icon, n, textAttributesKey, (Function0<Unit>)function0, string);
    }

    private final InlayPresentation buildPodOrJobPresentation(Editor editor, Project project, String kind, KubernetesObject obj) {
        Function0 function0;
        String string;
        KubernetesApiModelInterface kubernetesApiModelInterface = this.currentApiModel(project);
        if (kubernetesApiModelInterface == null) {
            return null;
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        Pair<String, String> pair = this.resourceNameAndNamespace(obj, apiModel2);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String name = (String)pair2.component1();
        String namespace = (String)pair2.component2();
        String string2 = kind;
        KubeStatus kubeStatus = Intrinsics.areEqual((Object)string2, (Object)"Pod") ? this.computePodStatus(apiModel2, name, namespace) : (Intrinsics.areEqual((Object)string2, (Object)"Job") ? this.computeJobStatus(apiModel2, name, namespace) : null);
        if (kubeStatus == null) {
            return null;
        }
        KubeStatus status = kubeStatus;
        String statusText = status.presentationText();
        if (status.isIssue()) {
            String string3 = KubernetesBundle.message((String)"KubernetesResourceStatusInlayProvider.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            String string5 = statusText.toLowerCase(Locale.ROOT);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        }
        String tooltipStatus = string;
        String string6 = kind.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        String tooltip = "The " + string6 + " is " + tooltipStatus;
        TextAttributesKey attributesKey = status.toAttributesKey();
        String string7 = kind;
        Function0 onOpenList = Intrinsics.areEqual((Object)string7, (Object)"Pod") ? () -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$0(this, project, apiModel2, name, namespace) : (Intrinsics.areEqual((Object)string7, (Object)"Job") ? () -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$1(this, project, apiModel2, namespace, name) : null);
        InlayPresentation statusPill = this.buildStatusPill(editor, statusText, attributesKey, (Function0<Unit>)onOpenList, tooltip);
        if (!status.isIssue()) {
            return statusPill;
        }
        String string8 = KubernetesBundle.message((String)"KubernetesResourceStatusInlayProvider.open.logs", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        String logsText = string8;
        String string9 = kind;
        if (Intrinsics.areEqual((Object)string9, (Object)"Pod")) {
            function0 = () -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$2(this, project, apiModel2, name, namespace);
        } else if (Intrinsics.areEqual((Object)string9, (Object)"Job")) {
            function0 = () -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$3(this, project, apiModel2, name, namespace);
        } else {
            return statusPill;
        }
        Function0 logsAction = function0;
        InlayPresentation logsBtn = this.buildLogsButtonPresentation(editor, logsText, (Function0<Unit>)logsAction);
        Ui ui = new Ui(editor);
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{statusPill, logsBtn};
        return ui.seq(inlayPresentationArray);
    }

    private final InlayPresentation buildDeploymentPresentation(Editor editor, Project project, V1Deployment deployment) {
        InlayPresentation inlayPresentation;
        int n;
        Object selector;
        KubernetesApiModelInterface kubernetesApiModelInterface = this.currentApiModel(project);
        if (kubernetesApiModelInterface == null) {
            return null;
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        Object object = deployment.getSpec();
        if (object == null || (object = object.getSelector()) == null || (object = object.getMatchLabels()) == null) {
            object = MapsKt.emptyMap();
        }
        if ((selector = object).isEmpty()) {
            return null;
        }
        DeploymentStatus counts = this.computeDeploymentCounts(apiModel2, deployment);
        int running = counts.component1();
        int pending = counts.component2();
        int terminating = counts.component3();
        int error = counts.component4();
        String string = KubeStatus.RUNNING.presentationText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String runningTextLower = string;
        String string2 = KubeStatus.PENDING.presentationText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String pendingTextLower = string2;
        String string3 = KubeStatus.TERMINATING.presentationText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String terminatingTextLower = string3;
        String string4 = KubeStatus.FAILED.presentationText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String failedTextLower = string4;
        Object[] objectArray = new Integer[]{running, pending, terminating, error};
        List buckets = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$count$iv = buckets;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it > 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        boolean allSame = n == 1;
        Function0 openPodsList = () -> PodStatusesInlayCollector.buildDeploymentPresentation$lambda$1(this, project, apiModel2);
        List parts = new ArrayList();
        if (running > 0) {
            Collection count$iv = parts;
            Icon icon = KubernetesIcons.Succeeded;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Succeeded");
            count$iv.add(this.buildIconNumberPill(editor, icon, running, KubeStatus.RUNNING.toAttributesKey(), (Function0<Unit>)openPodsList, PodStatusesInlayCollector.buildDeploymentPresentation$countTooltip(running, allSame, runningTextLower)));
        }
        if (pending > 0) {
            Collection count$iv = parts;
            Icon icon = KubernetesIcons.ToolWindowTimer;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowTimer");
            count$iv.add(this.buildIconNumberPill(editor, icon, pending, KubeStatus.PENDING.toAttributesKey(), (Function0<Unit>)openPodsList, PodStatusesInlayCollector.buildDeploymentPresentation$countTooltip(pending, allSame, pendingTextLower)));
        }
        if (terminating > 0) {
            Collection count$iv = parts;
            Icon icon = KubernetesIcons.Close;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Close");
            count$iv.add(this.buildIconNumberPill(editor, icon, terminating, KubeStatus.TERMINATING.toAttributesKey(), (Function0<Unit>)openPodsList, PodStatusesInlayCollector.buildDeploymentPresentation$countTooltip(terminating, allSame, terminatingTextLower)));
        }
        if (error > 0) {
            Object object2;
            String string5;
            if (counts.getErrorBreakdown().isEmpty()) {
                string5 = PodStatusesInlayCollector.buildDeploymentPresentation$countTooltip(error, allSame, failedTextLower);
            } else {
                object2 = new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
                    }
                };
                string5 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)counts.getErrorBreakdown().entrySet(), (Comparator)new Comparator((Comparator)object2){
                    final /* synthetic */ Comparator $this_thenBy;
                    {
                        this.$this_thenBy = $receiver;
                    }

                    public final int compare(T a, T b) {
                        int n;
                        int previousCompare = this.$this_thenBy.compare(a, b);
                        if (previousCompare != 0) {
                            n = previousCompare;
                        } else {
                            Map.Entry it = (Map.Entry)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)it.getKey();
                            it = (Map.Entry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
                        }
                        return n;
                    }
                }), (CharSequence)"\n", null, null, (int)0, null, PodStatusesInlayCollector::buildDeploymentPresentation$lambda$4, (int)30, null);
            }
            String tooltip = string5;
            object2 = parts;
            Icon icon = KubernetesIcons.Failed;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Failed");
            object2.add(this.buildIconNumberPill(editor, icon, error, KubeStatus.FAILED.toAttributesKey(), (Function0<Unit>)openPodsList, tooltip));
            String string6 = KubernetesBundle.message((String)"KubernetesResourceStatusInlayProvider.open.logs", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            String logsText = string6;
            ((Collection)parts).add(this.buildLogsButtonPresentation(editor, logsText, (Function0<Unit>)((Function0)() -> PodStatusesInlayCollector.buildDeploymentPresentation$lambda$5(this, project, apiModel2, deployment))));
        }
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            inlayPresentation = (InlayPresentation)CollectionsKt.first((List)parts);
        } else {
            Collection $this$toTypedArray$iv = parts;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            InlayPresentation[] inlayPresentationArray = thisCollection$iv.toArray(new InlayPresentation[0]);
            inlayPresentation = new Ui(editor).seq(Arrays.copyOf(inlayPresentationArray, inlayPresentationArray.length));
        }
        return inlayPresentation;
    }

    private static final CachedValueProvider.Result getCachedKubernetesObject$lambda$0(CoroutineScope $scope, YAMLDocument $document, Project $project) {
        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KubernetesObject>, Object>($scope, $document, $project, null){
            int label;
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ YAMLDocument $document;
            final /* synthetic */ Project $project;
            {
                this.$scope = $scope;
                this.$document = $document;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(org.jetbrains.yaml.psi.YAMLDocument ), ()Ljava/lang/String;)((YAMLDocument)this.$document), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        text = (String)v0;
                        Intrinsics.checkNotNull((Object)text);
                        obj = KubernetesResourceMapperKt.yamlToKubernetesObject((String)text);
                        BuildersKt.launch$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                            int label;
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            {
                                                this.$project = $project;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        InlayHintsPassFactoryInternal.Companion.restartDaemonUpdatingHints(this.$project, "KubernetesPodStatusesInlayProvider.kubernetesObjectComputed");
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return obj;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super KubernetesObject> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(YAMLDocument $document) {
                return $document.getText();
            }
        }), (int)3, null);
        Object[] objectArray = new Object[]{$document};
        return CachedValueProvider.Result.create((Object)deferred2, (Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final List openJobPodsLogs$lambda$0(String $namespace, String $jobName, List pods2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pods2, (String)"pods");
        Iterable $this$filter$iv = pods2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object object;
            Object podNamespace;
            V1Pod p = (V1Pod)element$iv$iv;
            boolean bl = false;
            Object object2 = p.getMetadata();
            if (object2 == null || (object2 = object2.getNamespace()) == null) {
                object2 = "default";
            }
            if (!(Intrinsics.areEqual((Object)(podNamespace = object2), (Object)$namespace) && Intrinsics.areEqual((object = p.getMetadata()) != null && (object = object.getLabels()) != null ? (String)object.get("job-name") : null, (Object)$jobName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final List openPodLogs$lambda$0(String $name, String $namespace, List pods) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)pods, (String)"pods");
            $this$firstOrNull$iv = pods;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (V1Pod)element$iv;
                $i$a$-firstOrNull-PodStatusesInlayCollector$openPodLogs$1$1 = false;
                v0 = it.getMetadata();
                if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getName() : null), (Object)$name)) ** GOTO lbl-1000
                v1 /* !! */  = it.getMetadata();
                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getNamespace()) == null) {
                    v1 /* !! */  = "default";
                }
                if (Intrinsics.areEqual((Object)v1 /* !! */ , (Object)$namespace)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        var3_10 = v3;
        if (var3_10 == null) ** GOTO lbl-1000
        p0 = var3_10;
        $i$a$-let-PodStatusesInlayCollector$openPodLogs$1$2 = false;
        var4_3 = CollectionsKt.listOf((Object)p0);
        if (var4_3 != null) {
            v4 = var4_3;
        } else lbl-1000:
        // 2 sources

        {
            v4 = CollectionsKt.emptyList();
        }
        return v4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final List openDeploymentPodsLogs$lambda$0(String $namespace, PodStatusesInlayCollector this$0, Map $selector, List pods) {
        Intrinsics.checkNotNullParameter((Object)pods, (String)"pods");
        $this$filter$iv = pods;
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            p = (V1Pod)element$iv$iv;
            $i$a$-filter-PodStatusesInlayCollector$openDeploymentPodsLogs$1$1 = false;
            v0 /* !! */  = p.getMetadata();
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getNamespace()) == null) {
                v0 /* !! */  = "default";
            }
            if (!Intrinsics.areEqual((Object)(podNamespace /* !! */  = v0 /* !! */ ), (Object)$namespace)) ** GOTO lbl-1000
            v1 /* !! */  = p.getMetadata();
            if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getLabels()) == null) {
                v1 /* !! */  = MapsKt.emptyMap();
            }
            if (this$0.labelsMatch((Map<String, String>)v1 /* !! */ , $selector)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit buildLogsButtonPresentation$lambda$0(Function0 $onClick, MouseEvent mouseEvent, Point point) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        $onClick.invoke();
        return Unit.INSTANCE;
    }

    private static final void buildPillFromContent$lambda$0(Function0 $onClick, MouseEvent mouseEvent, Point point) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        $onClick.invoke();
    }

    private static final Unit buildPodOrJobPresentation$lambda$0(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel, String $name, String $namespace) {
        this$0.openPodsServiceView($project, $apiModel, (Function1<? super KubernetesPodServiceViewContributorDescriptor, Boolean>)((Function1)arg_0 -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$0$0($name, $namespace, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean buildPodOrJobPresentation$lambda$0$0(String $name, String $namespace, KubernetesPodServiceViewContributorDescriptor d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        V1ObjectMeta v1ObjectMeta = ((V1Pod)d.getResource()).getMetadata();
        if (!Intrinsics.areEqual((Object)(v1ObjectMeta != null ? v1ObjectMeta.getName() : null), (Object)$name)) return false;
        Object object = ((V1Pod)d.getResource()).getMetadata();
        if (object == null || (object = object.getNamespace()) == null) {
            object = "default";
        }
        if (!Intrinsics.areEqual((Object)object, (Object)$namespace)) return false;
        return true;
    }

    private static final Unit buildPodOrJobPresentation$lambda$1(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel, String $namespace, String $name) {
        this$0.openPodsServiceView($project, $apiModel, (Function1<? super KubernetesPodServiceViewContributorDescriptor, Boolean>)((Function1)arg_0 -> PodStatusesInlayCollector.buildPodOrJobPresentation$lambda$1$0($namespace, $name, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean buildPodOrJobPresentation$lambda$1$0(String $namespace, String $name, KubernetesPodServiceViewContributorDescriptor d) {
        Object object;
        Object pNs;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        V1Pod pod = (V1Pod)d.getResource();
        Object object2 = pod.getMetadata();
        if (object2 == null || (object2 = object2.getNamespace()) == null) {
            object2 = "default";
        }
        return Intrinsics.areEqual((Object)(pNs = object2), (Object)$namespace) && Intrinsics.areEqual((object = pod.getMetadata()) != null && (object = object.getLabels()) != null ? (String)object.get("job-name") : null, (Object)$name);
    }

    private static final Unit buildPodOrJobPresentation$lambda$2(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel, String $name, String $namespace) {
        this$0.openPodLogs($project, $apiModel, $name, $namespace);
        return Unit.INSTANCE;
    }

    private static final Unit buildPodOrJobPresentation$lambda$3(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel, String $name, String $namespace) {
        this$0.openJobPodsLogs($project, $apiModel, $name, $namespace);
        return Unit.INSTANCE;
    }

    private static final String buildDeploymentPresentation$countTooltip(int number, boolean allSame, String text) {
        return allSame ? "All pods are " + text : number + " pods are " + text;
    }

    private static final Unit buildDeploymentPresentation$lambda$1(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel) {
        PodStatusesInlayCollector.openPodsServiceView$default(this$0, $project, $apiModel, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence buildDeploymentPresentation$lambda$4(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue() + " " + it.getKey();
    }

    private static final Unit buildDeploymentPresentation$lambda$5(PodStatusesInlayCollector this$0, Project $project, KubernetesApiModelInterface $apiModel, V1Deployment $deployment) {
        this$0.openDeploymentPodsLogs($project, $apiModel, $deployment);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\"\u001a\u00020\tH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$DeploymentStatus;", "", "running", "", "pending", "terminating", "error", "errorBreakdown", "", "", "<init>", "(IIIILjava/util/Map;)V", "getRunning", "()I", "setRunning", "(I)V", "getPending", "setPending", "getTerminating", "setTerminating", "getError", "setError", "getErrorBreakdown", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.kubernetes.backend"})
    public static final class DeploymentStatus {
        private int running;
        private int pending;
        private int terminating;
        private int error;
        @NotNull
        private final Map<String, Integer> errorBreakdown;

        public DeploymentStatus(int running, int pending, int terminating, int error, @NotNull Map<String, Integer> errorBreakdown) {
            Intrinsics.checkNotNullParameter(errorBreakdown, (String)"errorBreakdown");
            this.running = running;
            this.pending = pending;
            this.terminating = terminating;
            this.error = error;
            this.errorBreakdown = errorBreakdown;
        }

        public final int getRunning() {
            return this.running;
        }

        public final void setRunning(int n) {
            this.running = n;
        }

        public final int getPending() {
            return this.pending;
        }

        public final void setPending(int n) {
            this.pending = n;
        }

        public final int getTerminating() {
            return this.terminating;
        }

        public final void setTerminating(int n) {
            this.terminating = n;
        }

        public final int getError() {
            return this.error;
        }

        public final void setError(int n) {
            this.error = n;
        }

        @NotNull
        public final Map<String, Integer> getErrorBreakdown() {
            return this.errorBreakdown;
        }

        public final int component1() {
            return this.running;
        }

        public final int component2() {
            return this.pending;
        }

        public final int component3() {
            return this.terminating;
        }

        public final int component4() {
            return this.error;
        }

        @NotNull
        public final Map<String, Integer> component5() {
            return this.errorBreakdown;
        }

        @NotNull
        public final DeploymentStatus copy(int running, int pending, int terminating, int error, @NotNull Map<String, Integer> errorBreakdown) {
            Intrinsics.checkNotNullParameter(errorBreakdown, (String)"errorBreakdown");
            return new DeploymentStatus(running, pending, terminating, error, errorBreakdown);
        }

        public static /* synthetic */ DeploymentStatus copy$default(DeploymentStatus deploymentStatus, int n, int n2, int n3, int n4, Map map2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = deploymentStatus.running;
            }
            if ((n5 & 2) != 0) {
                n2 = deploymentStatus.pending;
            }
            if ((n5 & 4) != 0) {
                n3 = deploymentStatus.terminating;
            }
            if ((n5 & 8) != 0) {
                n4 = deploymentStatus.error;
            }
            if ((n5 & 0x10) != 0) {
                map2 = deploymentStatus.errorBreakdown;
            }
            return deploymentStatus.copy(n, n2, n3, n4, map2);
        }

        @NotNull
        public String toString() {
            return "DeploymentStatus(running=" + this.running + ", pending=" + this.pending + ", terminating=" + this.terminating + ", error=" + this.error + ", errorBreakdown=" + this.errorBreakdown + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.running);
            result2 = result2 * 31 + Integer.hashCode(this.pending);
            result2 = result2 * 31 + Integer.hashCode(this.terminating);
            result2 = result2 * 31 + Integer.hashCode(this.error);
            result2 = result2 * 31 + ((Object)this.errorBreakdown).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeploymentStatus)) {
                return false;
            }
            DeploymentStatus deploymentStatus = (DeploymentStatus)other;
            if (this.running != deploymentStatus.running) {
                return false;
            }
            if (this.pending != deploymentStatus.pending) {
                return false;
            }
            if (this.terminating != deploymentStatus.terminating) {
                return false;
            }
            if (this.error != deploymentStatus.error) {
                return false;
            }
            return Intrinsics.areEqual(this.errorBreakdown, deploymentStatus.errorBreakdown);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$KubeStatus;", "", "messageKey", "", "isIssue", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getMessageKey", "()Ljava/lang/String;", "()Z", "RUNNING", "PENDING", "SUCCEEDED", "FAILED", "ERROR", "TERMINATING", "UNKNOWN", "presentationText", "toAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.clouds.kubernetes.backend"})
    private static final class KubeStatus
    extends Enum<KubeStatus> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String messageKey;
        private final boolean isIssue;
        public static final /* enum */ KubeStatus RUNNING;
        public static final /* enum */ KubeStatus PENDING;
        public static final /* enum */ KubeStatus SUCCEEDED;
        public static final /* enum */ KubeStatus FAILED;
        public static final /* enum */ KubeStatus ERROR;
        public static final /* enum */ KubeStatus TERMINATING;
        public static final /* enum */ KubeStatus UNKNOWN;
        private static final /* synthetic */ KubeStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KubeStatus(String messageKey, boolean isIssue) {
            this.messageKey = messageKey;
            this.isIssue = isIssue;
        }

        @NotNull
        public final String getMessageKey() {
            return this.messageKey;
        }

        public final boolean isIssue() {
            return this.isIssue;
        }

        @NotNull
        public final String presentationText() {
            String string = KubernetesBundle.message((String)this.messageKey, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public final TextAttributesKey toAttributesKey() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1, 2 -> KubernetesInlayKeys.INSTANCE.getERROR();
                case 3, 4 -> KubernetesInlayKeys.INSTANCE.getSUCCESS();
                case 5, 6, 7 -> KubernetesInlayKeys.INSTANCE.getOTHER();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static KubeStatus[] values() {
            return (KubeStatus[])$VALUES.clone();
        }

        public static KubeStatus valueOf(String value) {
            return Enum.valueOf(KubeStatus.class, value);
        }

        @NotNull
        public static EnumEntries<KubeStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            RUNNING = new KubeStatus("KubernetesResourceStatusInlayProvider.running", false);
            PENDING = new KubeStatus("KubernetesResourceStatusInlayProvider.pending", false);
            SUCCEEDED = new KubeStatus("KubernetesResourceStatusInlayProvider.succeeded", false);
            FAILED = new KubeStatus("KubernetesResourceStatusInlayProvider.failed", true);
            ERROR = new KubeStatus("KubernetesResourceStatusInlayProvider.error", true);
            TERMINATING = new KubeStatus("KubernetesResourceStatusInlayProvider.terminating", false);
            UNKNOWN = new KubeStatus("KubernetesResourceStatusInlayProvider.unknown", false);
            $VALUES = kubeStatusArray = new KubeStatus[]{KubeStatus.RUNNING, KubeStatus.PENDING, KubeStatus.SUCCEEDED, KubeStatus.FAILED, KubeStatus.ERROR, KubeStatus.TERMINATING, KubeStatus.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$KubeStatus$Companion;", "", "<init>", "()V", "fromPodPhase", "Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$KubeStatus;", "phase", "", "intellij.clouds.kubernetes.backend"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final KubeStatus fromPodPhase(@Nullable String phase) {
                KubeStatus kubeStatus;
                String string = phase;
                if (string != null) {
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1345265087: {
                            if (!string.equals("Succeeded")) break;
                            n = 1;
                            break;
                        }
                        case 2096857181: {
                            if (!string.equals("Failed")) break;
                            n = 2;
                            break;
                        }
                        case -1079530081: {
                            if (!string.equals("Running")) break;
                            n = 3;
                            break;
                        }
                        case 982065527: {
                            if (!string.equals("Pending")) break;
                            n = 4;
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            kubeStatus = RUNNING;
                            return kubeStatus;
                        }
                        case 4: {
                            kubeStatus = PENDING;
                            return kubeStatus;
                        }
                        case 1: {
                            kubeStatus = SUCCEEDED;
                            return kubeStatus;
                        }
                        case 2: {
                            kubeStatus = ERROR;
                            return kubeStatus;
                        }
                    }
                }
                kubeStatus = UNKNOWN;
                return kubeStatus;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KubeStatus.values().length];
                try {
                    nArray[KubeStatus.FAILED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.SUCCEEDED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.RUNNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.PENDING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.TERMINATING.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KubeStatus.UNKNOWN.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/inlays/PodStatusesInlayCollector$Ui;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "getFactory", "()Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "scale", "Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "getScale", "()Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "seq", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "parts", "", "([Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "withDefaultContextMenu", "p", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clouds.kubernetes.backend"})
    private static final class Ui {
        @NotNull
        private final Editor editor;
        @NotNull
        private final PresentationFactory factory;
        @NotNull
        private final ScaleAwarePresentationFactory scale;

        public Ui(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.factory = new PresentationFactory(this.editor);
            this.scale = new ScaleAwarePresentationFactory(this.editor, this.factory);
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final PresentationFactory getFactory() {
            return this.factory;
        }

        @NotNull
        public final ScaleAwarePresentationFactory getScale() {
            return this.scale;
        }

        @NotNull
        public final InlayPresentation seq(InlayPresentation ... parts) {
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            InlayPresentation combined = (InlayPresentation)ArraysKt.first((Object[])parts);
            int n = parts.length;
            for (int i = 1; i < n; ++i) {
                InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{combined, parts[i]};
                combined = this.scale.seq(inlayPresentationArray);
            }
            return combined;
        }

        @NotNull
        public final InlayPresentation withDefaultContextMenu(@NotNull InlayPresentation p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Project project = this.editor.getProject();
            if (project == null) {
                return p;
            }
            Project project2 = project;
            List actions = InlayHintsUtils.INSTANCE.getDefaultInlayHintsProviderPopupActions(KubernetesPodStatusesInlayProviderKt.access$getKEY$p(), Ui::withDefaultContextMenu$lambda$0);
            return (InlayPresentation)new MenuOnClickPresentation(p, project2, () -> Ui.withDefaultContextMenu$lambda$1(actions));
        }

        @NotNull
        public final Editor component1() {
            return this.editor;
        }

        @NotNull
        public final Ui copy(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new Ui(editor);
        }

        public static /* synthetic */ Ui copy$default(Ui ui, Editor editor, int n, Object object) {
            if ((n & 1) != 0) {
                editor = ui.editor;
            }
            return ui.copy(editor);
        }

        @NotNull
        public String toString() {
            return "Ui(editor=" + this.editor + ")";
        }

        public int hashCode() {
            return this.editor.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ui)) {
                return false;
            }
            Ui ui = (Ui)other;
            return Intrinsics.areEqual((Object)this.editor, (Object)ui.editor);
        }

        private static final String withDefaultContextMenu$lambda$0() {
            return new KubernetesPodStatusesInlayProvider().getName();
        }

        private static final List withDefaultContextMenu$lambda$1(List $actions) {
            return $actions;
        }
    }
}

