/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.ProxyCommandImpl;
import com.intellij.ssh.ProxyCommandKt;
import com.intellij.util.EnvironmentUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0017\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0082\bJ\u0006\u0010\u001f\u001a\u00020\rJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/intellij/ssh/ProxyCommandImpl;", "", "command", "", "ProxyCommandImpl", "(Ljava/lang/String;)V", "process", "Ljava/lang/Process;", "watcher", "Ljava/lang/Thread;", "processMonitor", "Ljava/lang/Object;", "connect", "", "host", "port", "", "M", "block", "Lkotlin/Function0;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "inputStream$delegate", "Lkotlin/Lazy;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "outputStream$delegate", "close", "M", "Ljava/lang/ProcessBuilder;", "M", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nProxyCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyCommand.kt\ncom/intellij/ssh/ProxyCommandImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1#2:284\n*E\n"})
final class ProxyCommandImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String command;
    @Nullable
    private Process process;
    @Nullable
    private Thread watcher;
    @NotNull
    private final Object processMonitor;
    @NotNull
    private final Lazy inputStream$delegate;
    @NotNull
    private final Lazy outputStream$delegate;
    @NotNull
    private static final String HOST = "%h";
    @NotNull
    private static final String PORT = "%p";
    @NotNull
    private static final String USERNAME = "%r";
    @NotNull
    private static final Regex SPACES = new Regex("\\s+");
    @NotNull
    private static final String SHELL_ENV_VAR = "SHELL";
    @NotNull
    private static final String PATH_BSHELL = "/bin/sh";

    public ProxyCommandImpl(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.command = command;
        this.processMonitor = new Object();
        this.inputStream$delegate = LazyKt.lazy(() -> ProxyCommandImpl.M(this));
        this.outputStream$delegate = LazyKt.lazy(() -> ProxyCommandImpl.M(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(@Nullable String host, int port) throws IOException {
        ProxyCommandKt.access$getLOG$p().info("ProxyCommand for " + host + ":" + port + ": " + this.command);
        try {
            Process process;
            Object object = this.M(this.command);
            boolean bl = false;
            ((ProcessBuilder)object).redirectError(ProcessBuilder.Redirect.PIPE);
            Object object2 = this.processMonitor;
            synchronized (object2) {
                Process process2;
                boolean bl2 = false;
                if (this.process != null) {
                    throw new IOException("Already connected");
                }
                Process process3 = process2 = ((ProcessBuilder)object).start();
                boolean bl3 = false;
                this.process = process3;
                process = process2;
            }
            Process process4 = process;
            ProxyCommandKt.access$getLOG$p().info("Started ProxyCommand for " + host + ":" + port + ": " + this.process);
            Thread thread = new Thread(() -> ProxyCommandImpl.M(process4));
            object = thread;
            ProxyCommandImpl proxyCommandImpl = this;
            bl = false;
            ((Thread)object).setName("Error stream logger of " + process4);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            proxyCommandImpl.watcher = thread;
        }
        catch (ExecutionException executionException) {
            IOException iOException = executionException.toIOException();
            Intrinsics.checkNotNullExpressionValue((Object)iOException, (String)"toIOException(...)");
            throw (Throwable)iOException;
        }
    }

    private final void M(Function0<Unit> function0) {
        block4: {
            boolean bl = false;
            try {
                function0.invoke();
            }
            catch (IOException iOException) {
                String string;
                String string2 = iOException.getMessage();
                if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                    String string3 = string2;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string4 = string3.toLowerCase(locale);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    string = null;
                }
                if (Intrinsics.areEqual(string, (Object)"stream closed")) break block4;
                throw iOException;
            }
        }
    }

    @NotNull
    public final InputStream getInputStream() {
        Lazy lazy = this.inputStream$delegate;
        return (InputStream)lazy.getValue();
    }

    @NotNull
    public final OutputStream getOutputStream() {
        Lazy lazy = this.outputStream$delegate;
        return (OutputStream)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Process process;
        Process process2;
        Object object = this.processMonitor;
        synchronized (object) {
            boolean bl = false;
            Process process3 = this.process;
            this.process = null;
            process2 = process3;
        }
        Process process4 = process = process2;
        if (process4 != null) {
            process4.destroy();
        }
        try {
            Thread thread = this.watcher;
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            ProxyCommandKt.access$getLOG$p().info("Got InterruptedException when tried to join " + this.watcher);
        }
    }

    private final ProcessBuilder M(String string) {
        if (!SystemInfo.isWindows) {
            String string2 = System.getenv(SHELL_ENV_VAR);
            if (string2 == null) {
                string2 = PATH_BSHELL;
            }
            String string3 = string2;
            Object object = new String[]{string3, "-c", "exec " + string};
            ProcessBuilder processBuilder = new ProcessBuilder((String)object);
            try {
                Map map = EnvironmentUtil.getEnvironmentMap();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
                object = map;
                processBuilder.environment().putAll((Map<String, String>)object);
            }
            catch (IOException iOException) {
                ProxyCommandKt.access$getLOG$p().warn("Failed to read environment variables from the new Shell process:\n " + iOException);
            }
            return processBuilder;
        }
        CharSequence charSequence = string;
        Regex regex = SPACES;
        int n = 0;
        return new ProcessBuilder(regex.split(charSequence, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Process M() {
        Process process;
        Object object = this.processMonitor;
        synchronized (object) {
            boolean bl = false;
            Process process2 = this.process;
            if (process2 == null) {
                throw new IOException("Not connected");
            }
            process = process2;
        }
        return process;
    }

    private static final void M(Process process) {
        Intrinsics.checkNotNull((Object)process);
        ProxyCommandKt.watchProxyCommandProcess(process, ProxyCommandKt.access$getLOG$p());
    }

    private static final inputStream.2.1 M(ProxyCommandImpl proxyCommandImpl) {
        ProxyCommandImpl proxyCommandImpl2 = proxyCommandImpl;
        InputStream inputStream2 = proxyCommandImpl.M().getInputStream();
        return new FilterInputStream(proxyCommandImpl, proxyCommandImpl2, inputStream2){
            final /* synthetic */ ProxyCommandImpl this$0;
            final /* synthetic */ ProxyCommandImpl $self;
            {
                this.this$0 = $receiver;
                this.$self = $self;
                super($super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                block7: {
                    ProxyCommandImpl proxyCommandImpl = this.this$0;
                    ProxyCommandImpl proxyCommandImpl2 = this.this$0;
                    ProxyCommandImpl proxyCommandImpl3 = this.$self;
                    boolean bl = false;
                    try {
                        boolean bl2 = false;
                        Object object = ProxyCommandImpl.access$getProcessMonitor$p(proxyCommandImpl2);
                        synchronized (object) {
                            boolean bl3 = false;
                            proxyCommandImpl3.close();
                            super.close();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    catch (IOException iOException) {
                        String string;
                        String string2 = iOException.getMessage();
                        if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                            String string3 = string2;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                            String string4 = string3.toLowerCase(locale);
                            string = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        if (Intrinsics.areEqual(string, (Object)"stream closed")) break block7;
                        throw iOException;
                    }
                }
            }
        };
    }

    private static final outputStream.2.1 M(ProxyCommandImpl proxyCommandImpl) {
        ProxyCommandImpl proxyCommandImpl2 = proxyCommandImpl;
        OutputStream outputStream2 = proxyCommandImpl.M().getOutputStream();
        return new OutputStream(outputStream2, proxyCommandImpl, proxyCommandImpl2){
            final /* synthetic */ OutputStream $delegate;
            final /* synthetic */ ProxyCommandImpl this$0;
            final /* synthetic */ ProxyCommandImpl $self;
            {
                this.$delegate = $delegate;
                this.this$0 = $receiver;
                this.$self = $self;
            }

            public void flush() {
                this.$delegate.flush();
            }

            public void write(int p0) {
                this.$delegate.write(p0);
                this.$delegate.flush();
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.$delegate.write(b, off, len);
                this.$delegate.flush();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                block7: {
                    ProxyCommandImpl proxyCommandImpl = this.this$0;
                    ProxyCommandImpl proxyCommandImpl2 = this.this$0;
                    ProxyCommandImpl proxyCommandImpl3 = this.$self;
                    OutputStream outputStream2 = this.$delegate;
                    boolean bl = false;
                    try {
                        boolean bl2 = false;
                        Object object = ProxyCommandImpl.access$getProcessMonitor$p(proxyCommandImpl2);
                        synchronized (object) {
                            boolean bl3 = false;
                            proxyCommandImpl3.close();
                            outputStream2.close();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    catch (IOException iOException) {
                        String string;
                        String string2 = iOException.getMessage();
                        if (string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null) {
                            String string3 = string2;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                            String string4 = string3.toLowerCase(locale);
                            string = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        if (Intrinsics.areEqual(string, (Object)"stream closed")) break block7;
                        throw iOException;
                    }
                }
            }
        };
    }

    public static final /* synthetic */ Object access$getProcessMonitor$p(ProxyCommandImpl $this) {
        return $this.processMonitor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ssh/ProxyCommandImpl$Companion;", "", "ProxyCommandImpl$Companion", "()V", "HOST", "", "PORT", "USERNAME", "SPACES", "Lkotlin/text/Regex;", "SHELL_ENV_VAR", "PATH_BSHELL", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

