/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.util.registry.Registry;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PlatformAuthGssApiWithMic
extends AbstractAuthMethod {
    private final LoginContext loginContext;
    private final List<Oid> mechanismOids;
    private final GSSManager manager;
    private GSSContext secContext;

    public PlatformAuthGssApiWithMic(LoginContext loginContext, List<Oid> mechanismOids) {
        this(loginContext, mechanismOids, GSSManager.getInstance());
    }

    public PlatformAuthGssApiWithMic(LoginContext loginContext, List<Oid> mechanismOids, GSSManager manager) {
        super("gssapi-with-mic");
        this.loginContext = loginContext;
        this.mechanismOids = mechanismOids;
        this.manager = manager;
        this.secContext = null;
    }

    public SSHPacket buildReq() throws UserAuthException {
        SSHPacket sSHPacket = (SSHPacket)super.buildReq().putUInt32((long)this.mechanismOids.size());
        for (Oid oid : this.mechanismOids) {
            try {
                sSHPacket.putString(oid.getDER());
            }
            catch (GSSException gSSException) {
                throw new UserAuthException("Mechanism OID could not be encoded: " + oid.toString(), (Throwable)gSSException);
            }
        }
        return sSHPacket;
    }

    private void M(byte[] byArray) throws TransportException {
        SSHPacket sSHPacket = (SSHPacket)new SSHPacket(Message.USERAUTH_INFO_RESPONSE).putString(byArray);
        this.params.getTransport().write(sSHPacket);
    }

    private void M(SSHPacket sSHPacket) throws UserAuthException, TransportException {
        Oid oid;
        byte[] byArray;
        try {
            byArray = sSHPacket.readBytes();
        }
        catch (Buffer.BufferException bufferException) {
            throw new UserAuthException("Failed to read byte array from message buffer", (Throwable)bufferException);
        }
        try {
            oid = new Oid(byArray);
        }
        catch (GSSException gSSException) {
            throw new UserAuthException("Exception constructing OID from server response", (Throwable)gSSException);
        }
        this.log.debug("Server selected OID: {}", (Object)oid.toString());
        this.log.debug("Initializing GSSAPI context");
        Subject subject = this.loginContext.getSubject();
        try {
            this.secContext = Subject.doAs(subject, new InitializeContextAction(oid));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new UserAuthException("Exception during context initialization", (Throwable)privilegedActionException);
        }
        this.log.debug("Sending initial token");
        byte[] byArray2 = new byte[]{};
        try {
            byte[] byArray3 = this.secContext.initSecContext(byArray2, 0, byArray2.length);
            this.M(byArray3);
        }
        catch (GSSException gSSException) {
            throw new UserAuthException("Exception sending initial token", (Throwable)gSSException);
        }
    }

    private byte[] M(SSHPacket sSHPacket) throws UserAuthException {
        byte[] byArray;
        try {
            byArray = sSHPacket.readStringAsBytes();
        }
        catch (Buffer.BufferException bufferException) {
            throw new UserAuthException("Failed to read string from message buffer", (Throwable)bufferException);
        }
        try {
            return this.secContext.initSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            throw new UserAuthException("Exception during token exchange", (Throwable)gSSException);
        }
    }

    private byte[] M() throws UserAuthException {
        byte[] byArray = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putByte(Message.USERAUTH_REQUEST.toByte())).putString(this.params.getUsername())).putString(this.params.getNextServiceName())).putString(this.getName())).getCompactData();
        try {
            return this.secContext.getMIC(byArray, 0, byArray.length, null);
        }
        catch (GSSException gSSException) {
            throw new UserAuthException("Exception getting message integrity code", (Throwable)gSSException);
        }
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.M(buf);
        } else if (cmd == Message.USERAUTH_INFO_RESPONSE) {
            byte[] byArray = this.M(buf);
            if (!this.secContext.isEstablished()) {
                this.log.debug("Sending token");
                this.M(byArray);
            } else if (this.secContext.getIntegState()) {
                this.log.debug("Per-message integrity protection available: finalizing authentication with message integrity code");
                this.params.getTransport().write((SSHPacket)new SSHPacket(Message.USERAUTH_GSSAPI_MIC).putString(this.M()));
            } else {
                this.log.debug("Per-message integrity protection unavailable: finalizing authentication");
                this.params.getTransport().write(new SSHPacket(Message.USERAUTH_GSSAPI_EXCHANGE_COMPLETE));
            }
        } else {
            super.handle(cmd, buf);
        }
    }

    private class InitializeContextAction
    implements PrivilegedExceptionAction<GSSContext> {
        private final Oid selectedOid;

        public InitializeContextAction(Oid selectedOid) {
            this.selectedOid = selectedOid;
        }

        @Override
        public GSSContext run() throws GSSException {
            GSSName gSSName;
            GSSCredential gSSCredential;
            if (Registry.is((String)"ssh.kerberos.use.default.credential")) {
                gSSCredential = PlatformAuthGssApiWithMic.this.manager.createCredential(1);
            } else {
                gSSName = PlatformAuthGssApiWithMic.this.manager.createName(PlatformAuthGssApiWithMic.this.params.getUsername(), GSSName.NT_USER_NAME);
                gSSCredential = PlatformAuthGssApiWithMic.this.manager.createCredential(gSSName, 0, this.selectedOid, 1);
            }
            gSSName = PlatformAuthGssApiWithMic.this.manager.createName("host@" + PlatformAuthGssApiWithMic.this.params.getTransport().getRemoteHost(), GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gSSContext = PlatformAuthGssApiWithMic.this.manager.createContext(gSSName, this.selectedOid, gSSCredential, 0);
            gSSContext.requestMutualAuth(true);
            gSSContext.requestInteg(true);
            return gSSContext;
        }
    }
}

