/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.SshTunnelListener;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.EofSendingOutputStream;
import com.intellij.ssh.impl.sshj.tunnels.ShutdowningSocketInputStream;
import com.intellij.ssh.impl.sshj.tunnels.ShutdowningSocketOutputStream;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\u001a6\u0010\u0011\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0017\u001a\u00020\u0001\"\b\b\u0000\u0010\u0018*\u00020\u0019*\u0002H\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00010\u001bH\u0082\b\u00a2\u0006\u0002\u0010\u001c\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0018\u0010'\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002\"\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010#\u001a\u00020$*\u00020\u001e8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u000e\u0010*\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"singleTunnelBroker", "", "brokerName", "", "sshjTransport", "Lnet/schmizz/sshj/transport/Transport;", "socketSupplier", "Lkotlin/Function0;", "Ljava/net/Socket;", "channelSupplier", "Lnet/schmizz/sshj/connection/channel/Channel;", "soTimeout", "", "threadSocketExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "getThreadSocketExceptionHandler", "()Ljava/lang/Thread$UncaughtExceptionHandler;", "M", "threads", "", "Ljava/lang/Thread;", "socket", "channel", "M", "T", "Ljava/io/Closeable;", "handler", "Lkotlin/Function1;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)V", "M", "Ljava/io/IOException;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "causedByConnectionLoss", "", "getCausedByConnectionLoss", "(Ljava/io/IOException;)Z", "M", "buffer", "", "successMarker", "SO_TIMEOUT_MILLIS", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSingleTunnelBroker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleTunnelBroker.kt\ncom/intellij/ssh/impl/sshj/tunnels/SingleTunnelBrokerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n134#1,2:264\n134#1,16:266\n138#1,12:282\n1869#2,2:294\n1869#2,2:296\n1869#2,2:298\n67#3,4:300\n*S KotlinDebug\n*F\n+ 1 SingleTunnelBroker.kt\ncom/intellij/ssh/impl/sshj/tunnels/SingleTunnelBrokerKt\n*L\n43#1:264,2\n59#1:266,16\n43#1:282,12\n67#1:294,2\n116#1:296,2\n130#1:298,2\n163#1:300,4\n*E\n"})
public final class SingleTunnelBrokerKt {
    @NotNull
    private static final Thread.UncaughtExceptionHandler threadSocketExceptionHandler = SingleTunnelBrokerKt::M;
    @NotNull
    private static final IOException successMarker = new IOException("<success singleton>");
    private static final int SO_TIMEOUT_MILLIS = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void singleTunnelBroker(@NotNull String brokerName, @NotNull Transport sshjTransport, @NotNull Function0<? extends Socket> socketSupplier, @NotNull Function0<? extends Channel> channelSupplier, int soTimeout) {
        block25: {
            Object object;
            Object object2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)brokerName, (String)"brokerName");
            Intrinsics.checkNotNullParameter((Object)sshjTransport, (String)"sshjTransport");
            Intrinsics.checkNotNullParameter(socketSupplier, (String)"socketSupplier");
            Intrinsics.checkNotNullParameter(channelSupplier, (String)"channelSupplier");
            List list = new ArrayList();
            try {
                Socket socket;
                try {
                    object3 = (Socket)socketSupplier.invoke();
                }
                catch (SocketException socketException) {
                    UtilKt.getSSHJ_LOG().warn("Error in `" + Thread.currentThread().getName() + "`", (Throwable)socketException);
                    object3 = null;
                }
                Socket socket2 = socket = object3;
                if (socket2 == null) break block25;
                object3 = socket2;
                boolean bl = false;
                try {
                    Thread thread;
                    object2 = (Socket)object3;
                    boolean bl2 = false;
                    socket.setSoTimeout(soTimeout);
                    try {
                        object = (Channel)channelSupplier.invoke();
                    }
                    catch (IOException iOException) {
                        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                        Topic<SshTunnelListener> topic = SshTunnelListener.TOPIC;
                        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                        ((SshTunnelListener)messageBus.syncPublisher(topic)).onError(socket.getLocalPort(), iOException);
                        if (!SingleTunnelBrokerKt.getCausedByConnectionLoss(iOException)) {
                            throw iOException;
                        }
                        UtilKt.getSSHJ_LOG().info("Error in `" + Thread.currentThread().getName() + "`: " + iOException.getClass().getName() + ": " + iOException.getMessage());
                        object = null;
                    }
                    Thread thread2 = thread = object;
                    if (thread2 == null) break block25;
                    object = (Closeable)((Object)thread2);
                    boolean bl3 = false;
                    try {
                        Channel channel2 = (Channel)object;
                        boolean bl4 = false;
                        socket.setSendBufferSize(thread.getLocalMaxPacketSize());
                        socket.setReceiveBufferSize(thread.getRemoteMaxPacketSize());
                        SingleTunnelBrokerKt.M(list, socket, (Channel)thread, sshjTransport, brokerName);
                    }
                    finally {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)throwable)) {
                                UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + (Closeable)object, throwable);
                            }
                            UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), throwable);
                        }
                    }
                }
                finally {
                    try {
                        object3.close();
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)throwable)) {
                            UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + (Closeable)object3, throwable);
                        }
                        UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), throwable);
                    }
                }
            }
            finally {
                object3 = list;
                boolean bl = false;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    object = (Thread)e;
                    boolean bl5 = false;
                    ((Thread)object).join();
                }
                UtilKt.getSSHJ_LOG().debug("Finished " + Thread.currentThread().getName());
            }
        }
    }

    public static /* synthetic */ void singleTunnelBroker$default(String string, Transport transport, Function0 function0, Function0 function02, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 20000;
        }
        SingleTunnelBrokerKt.singleTunnelBroker(string, transport, (Function0<? extends Socket>)function0, (Function0<? extends Channel>)function02, n);
    }

    @NotNull
    public static final Thread.UncaughtExceptionHandler getThreadSocketExceptionHandler() {
        return threadSocketExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void M(List<Thread> list, Socket socket, Channel channel2, Transport transport, String string) {
        boolean bl;
        try {
            Object object;
            Iterable iterable = new ArrayBlockingQueue(2);
            Object object2 = new Thread(() -> SingleTunnelBrokerKt.M(socket, transport, channel2, iterable));
            Thread thread = object2;
            List<Thread> list2 = list;
            boolean bl2 = false;
            thread.setName(string + ": local to remote copier");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(threadSocketExceptionHandler);
            list2.add((Thread)object2);
            object2 = new Thread(() -> SingleTunnelBrokerKt.M(channel2, socket, iterable));
            thread = object2;
            list2 = list;
            bl2 = false;
            thread.setName(string + ": remote to local copier");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(threadSocketExceptionHandler);
            list2.add((Thread)object2);
            object2 = list;
            boolean bl3 = false;
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                Thread thread2 = (Thread)object;
                boolean bl4 = false;
                thread2.start();
            }
            for (int i = 0; i < 2; ++i) {
                Pair pair = (Pair)((ArrayBlockingQueue)iterable).take();
                object3 = (Thread)pair.component1();
                object = (IOException)pair.component2();
                if (object == successMarker) continue;
                UtilKt.getSSHJ_LOG().error("Error from " + ((Thread)object3).getName(), (Throwable)object);
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            boolean bl5 = bl = !Thread.currentThread().isInterrupted();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
            }
        }
        finally {
            Iterable iterable = list;
            bl = false;
            for (Object t : iterable) {
                Thread thread = (Thread)t;
                boolean bl6 = false;
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T extends Closeable> void M(T t, Function1<? super T, Unit> function1) {
        boolean bl = false;
        try {
            function1.invoke(t);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            try {
                t.close();
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)throwable)) {
                    UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + t, throwable);
                }
                UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), throwable);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IOException M(InputStream inputStream2, OutputStream outputStream2) {
        Object object;
        try {
            Object object2;
            object = inputStream2;
            Throwable throwable = null;
            try {
                Object object3;
                object2 = (InputStream)object;
                boolean bl = false;
                Closeable closeable = outputStream2;
                Throwable throwable2 = null;
                try {
                    object3 = (OutputStream)closeable;
                    boolean bl2 = false;
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    n = SingleTunnelBrokerKt.M(inputStream2, byArray);
                    while (n >= 0 && !Thread.currentThread().isInterrupted()) {
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl3 = false;
                        if (logger.isTraceEnabled()) {
                            Logger logger2 = logger;
                            boolean bl4 = false;
                            logger2.trace("Copier: " + inputStream2 + " -> " + outputStream2 + ": `" + UtilKt.escapeLikeStrace$default(byArray, 0, n, 1, null) + "`");
                        }
                        outputStream2.write(byArray, 0, n);
                        if (inputStream2.available() == 0) {
                            outputStream2.flush();
                        }
                        n = SingleTunnelBrokerKt.M(inputStream2, byArray);
                    }
                    object3 = successMarker;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                object2 = object3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = object2;
        }
        catch (IOException iOException) {
            IOException iOException2;
            if (SingleTunnelBrokerKt.getCausedByConnectionLoss(iOException)) {
                UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
                iOException2 = successMarker;
            } else {
                iOException2 = iOException;
            }
            object = iOException2;
        }
        catch (Throwable throwable) {
            object = new IOException(throwable);
        }
        finally {
            UtilKt.getSSHJ_LOG().debug("Finished " + Thread.currentThread().getName());
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static final boolean getCausedByConnectionLoss(@NotNull IOException $this$causedByConnectionLoss) {
        Intrinsics.checkNotNullParameter((Object)$this$causedByConnectionLoss, (String)"<this>");
        if (ExceptionUtil.causedBy((Throwable)$this$causedByConnectionLoss, SocketException.class)) return true;
        if ($this$causedByConnectionLoss instanceof ConnectionException) return true;
        TransportException transportException = (TransportException)((Object)ExceptionUtil.findCause((Throwable)$this$causedByConnectionLoss, TransportException.class));
        String string = transportException != null ? transportException.getMessage() : null;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)string, (Object)"Broken transport; encountered EOF")) return true;
        if (Intrinsics.areEqual((Object)string, (Object)"Stream Closed")) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!Intrinsics.areEqual((Object)$this$causedByConnectionLoss.getMessage(), (Object)"Stream closed.")) return false;
        return true;
    }

    private static final int M(InputStream inputStream2, byte[] byArray) {
        int n;
        try {
            n = inputStream2.read(byArray);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            n = 0;
        }
        return n;
    }

    private static final void M(Thread thread, Throwable throwable) {
        if (throwable instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)throwable)) {
            UtilKt.getSSHJ_LOG().info("Error from `" + thread.getName() + "``: " + throwable.getClass().getName() + ": " + ((IOException)throwable).getMessage());
        } else {
            UtilKt.getSSHJ_LOG().error("Error from `" + thread.getName() + "`", throwable);
        }
    }

    private static final void M(Socket socket, Transport transport, Channel channel2, ArrayBlockingQueue arrayBlockingQueue) {
        ShutdowningSocketInputStream shutdowningSocketInputStream = new ShutdowningSocketInputStream(socket);
        OutputStream outputStream2 = channel2.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"getOutputStream(...)");
        EofSendingOutputStream eofSendingOutputStream = new EofSendingOutputStream(transport, channel2, outputStream2);
        arrayBlockingQueue.add(TuplesKt.to((Object)Thread.currentThread(), (Object)SingleTunnelBrokerKt.M((InputStream)shutdowningSocketInputStream, eofSendingOutputStream)));
    }

    private static final void M(Channel channel2, Socket socket, ArrayBlockingQueue arrayBlockingQueue) {
        InputStream inputStream2 = channel2.getInputStream();
        ShutdowningSocketOutputStream shutdowningSocketOutputStream = new ShutdowningSocketOutputStream(socket);
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNull((Object)inputStream2);
        arrayBlockingQueue.add(TuplesKt.to((Object)thread, (Object)SingleTunnelBrokerKt.M(inputStream2, shutdowningSocketOutputStream)));
    }
}

