/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.database.extensions.DataConsumer;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.impl.RestrictedScriptRunnerService;
import com.intellij.grid.scripting.impl.RestrictedScriptRunnerServiceKt;
import com.intellij.grid.scripting.rt.RemoteLoaderScript;
import com.intellij.grid.scripting.rt.RemoteLoaderSession;
import com.intellij.grid.scripting.rt.RemoteScriptService;
import com.intellij.grid.scripting.rt.RemoteScriptServiceServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "remote", "com/intellij/grid/scripting/impl/RestrictedScriptRunnerService$remote$1", "Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$remote$1;", "cleanup", "", "dispose", "createLoaderScriptRunner", "Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$LoaderScriptRunner;", "scriptPath", "Ljava/nio/file/Path;", "createFailsafeLoaderScript", "Lkotlin/Function0;", "Lcom/intellij/grid/scripting/rt/RemoteLoaderScript;", "isValid", "", "service", "Lcom/intellij/grid/scripting/rt/RemoteScriptService;", "LoaderScriptRunner", "RestrictedLoaderScriptRunner", "intellij.grid.scripting.impl"})
public final class RestrictedScriptRunnerService
implements Disposable {
    @NotNull
    private final remote.1 remote;

    public RestrictedScriptRunnerService() {
        Class<RemoteScriptService> clazz = RemoteScriptService.class;
        this.remote = new RemoteProcessSupport<Unit, RemoteScriptService, Object>(clazz){

            protected void fireModificationCountChanged() {
            }

            protected String getName(Unit target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return "IsolatedScriptRunner";
            }

            private final SimpleJavaParameters createJavaParameters() {
                SimpleJavaParameters params = new SimpleJavaParameters();
                params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                params.setMainClass(RemoteScriptServiceServer.class.getName());
                PathsList pathsList = params.getClassPath();
                Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"getClassPath(...)");
                Class<?> clazz = ((Object)((Object)this)).getClass();
                String string = params.getMainClass();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMainClass(...)");
                RestrictedScriptRunnerServiceKt.access$addClassJar(pathsList, clazz, string);
                PathsList pathsList2 = params.getClassPath();
                Intrinsics.checkNotNullExpressionValue((Object)pathsList2, (String)"getClassPath(...)");
                Class<?> clazz2 = ((Object)((Object)this)).getClass();
                String string2 = RemoteServer.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                RestrictedScriptRunnerServiceKt.access$addClassJar(pathsList2, clazz2, string2);
                PathsList pathsList3 = params.getClassPath();
                Intrinsics.checkNotNullExpressionValue((Object)pathsList3, (String)"getClassPath(...)");
                RestrictedScriptRunnerServiceKt.access$addClassJar(pathsList3, ((Object)((Object)this)).getClass(), "groovy.lang.GroovyShell");
                PathsList pathsList4 = params.getClassPath();
                Intrinsics.checkNotNullExpressionValue((Object)pathsList4, (String)"getClassPath(...)");
                RestrictedScriptRunnerServiceKt.access$addClassJar(pathsList4, ((Object)((Object)this)).getClass(), "org.codehaus.groovy.jsr223.GroovyScriptEngineFactory");
                PathsList pathsList5 = params.getClassPath();
                Intrinsics.checkNotNullExpressionValue((Object)pathsList5, (String)"getClassPath(...)");
                RestrictedScriptRunnerServiceKt.access$addClassJar(pathsList5, ((Object)((Object)this)).getClass(), "org.apache.ivy.Ivy");
                params.getVMParametersList().addProperty("grape.root", ((Object)DataLoaderManager.Companion.getGrapeDir$intellij_grid_scripting_impl()).toString());
                return params;
            }

            protected RunProfileState getRunProfileState(Unit target, Object configuration, Executor executor) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                return (RunProfileState)new CommandLineState(this){
                    final /* synthetic */ remote.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(null);
                    }

                    protected ProcessHandler startProcess() {
                        SimpleJavaParameters params = remote.1.access$createJavaParameters(this.this$0);
                        GeneralCommandLine generalCommandLine = params.toCommandLine();
                        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"toCommandLine(...)");
                        GeneralCommandLine commandLine = generalCommandLine;
                        OSProcessHandler.Silent processHandler = new OSProcessHandler.Silent(commandLine);
                        return (ProcessHandler)processHandler;
                    }
                };
            }

            public static final /* synthetic */ SimpleJavaParameters access$createJavaParameters(remote.1 $this) {
                return $this.createJavaParameters();
            }
        };
    }

    @TestOnly
    public final void cleanup() {
        this.remote.release(Unit.INSTANCE, Unit.INSTANCE);
    }

    public void dispose() {
        this.remote.stopAll();
    }

    @NotNull
    public final LoaderScriptRunner createLoaderScriptRunner(@NotNull Path scriptPath) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Function0<RemoteLoaderScript> remoteLoader = this.createFailsafeLoaderScript(scriptPath);
        return new RestrictedLoaderScriptRunner(remoteLoader);
    }

    private final Function0<RemoteLoaderScript> createFailsafeLoaderScript(Path scriptPath) {
        Ref.ObjectRef service = new Ref.ObjectRef();
        Ref.ObjectRef cache = new Ref.ObjectRef();
        return () -> RestrictedScriptRunnerService.createFailsafeLoaderScript$lambda$0(this, service, cache, scriptPath);
    }

    private final boolean isValid(RemoteScriptService service) {
        try {
            RemoteScriptService remoteScriptService = service;
            if (remoteScriptService != null) {
                remoteScriptService.ping();
            }
            return true;
        }
        catch (Throwable th) {
            RestrictedScriptRunnerServiceKt.access$getLogger$p().warn("Service is dead", th);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RemoteLoaderScript createFailsafeLoaderScript$lambda$0(RestrictedScriptRunnerService this$0, Ref.ObjectRef $service, Ref.ObjectRef $cache, Path $scriptPath) {
        RemoteLoaderScript remoteLoaderScript;
        RemoteScriptService current = (RemoteScriptService)this$0.remote.acquire(Unit.INSTANCE, Unit.INSTANCE, null);
        RestrictedScriptRunnerService restrictedScriptRunnerService = this$0;
        synchronized (restrictedScriptRunnerService) {
            boolean bl = false;
            if (!this$0.isValid((RemoteScriptService)$service.element)) {
                $service.element = null;
            }
            if ($service.element == null || !Intrinsics.areEqual((Object)$service.element, (Object)current)) {
                $service.element = current;
                $cache.element = null;
            }
            if ($cache.element == null) {
                Object object = $service.element;
                Intrinsics.checkNotNull((Object)object);
                $cache.element = ((RemoteScriptService)object).createLoaderScript(((Object)$scriptPath).toString());
            }
            Object object = $cache.element;
            Intrinsics.checkNotNull((Object)object);
            remoteLoaderScript = (RemoteLoaderScript)object;
        }
        return remoteLoaderScript;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$LoaderScriptRunner;", "", "runLoad", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "dataConsumer", "Lcom/intellij/database/extensions/DataConsumer;", "cleanup", "intellij.grid.scripting.impl"})
    public static interface LoaderScriptRunner {
        public void runLoad(@NotNull Project var1, @NotNull Map<String, ? extends Object> var2, @NotNull DataConsumer var3);

        public void cleanup();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u0010\u0013\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0015H\u0082\bJ\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$RestrictedLoaderScriptRunner;", "Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$LoaderScriptRunner;", "remoteLoader", "Lkotlin/Function0;", "Lcom/intellij/grid/scripting/rt/RemoteLoaderScript;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getRemoteLoader", "()Lkotlin/jvm/functions/Function0;", "runLoad", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "", "dataConsumer", "Lcom/intellij/database/extensions/DataConsumer;", "startLoading", "block", "Lkotlin/Function1;", "Lcom/intellij/grid/scripting/rt/RemoteLoaderSession;", "dispatch", "e", "Lcom/intellij/grid/scripting/rt/RemoteLoaderSession$Event;", "cleanup", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nRestrictedScriptRunnerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictedScriptRunnerService.kt\ncom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$RestrictedLoaderScriptRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n137#1,10:174\n149#1,4:186\n1869#2,2:184\n1869#2,2:190\n*S KotlinDebug\n*F\n+ 1 RestrictedScriptRunnerService.kt\ncom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$RestrictedLoaderScriptRunner\n*L\n124#1:174,10\n124#1:186,4\n128#1:184,2\n156#1:190,2\n*E\n"})
    private static final class RestrictedLoaderScriptRunner
    implements LoaderScriptRunner {
        @NotNull
        private final Function0<RemoteLoaderScript> remoteLoader;

        public RestrictedLoaderScriptRunner(@NotNull Function0<? extends RemoteLoaderScript> remoteLoader) {
            Intrinsics.checkNotNullParameter(remoteLoader, (String)"remoteLoader");
            this.remoteLoader = remoteLoader;
        }

        @NotNull
        public final Function0<RemoteLoaderScript> getRemoteLoader() {
            return this.remoteLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void runLoad(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull DataConsumer dataConsumer) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)dataConsumer, (String)"dataConsumer");
            RestrictedLoaderScriptRunner restrictedLoaderScriptRunner = this;
            Map<String, ? extends Object> parameters$iv = parameters;
            boolean $i$f$startLoading = false;
            AutoCloseable autoCloseable = (AutoCloseable)((RemoteLoaderScript)this_$iv.remoteLoader.invoke()).startLoading(parameters$iv);
            Throwable throwable = null;
            try {
                Unit unit;
                Job job$iv;
                RemoteLoaderSession session$iv = (RemoteLoaderSession)autoCloseable;
                boolean bl = false;
                Job job = job$iv = (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
                DisposableHandle listener$iv = job != null ? job.invokeOnCompletion(true, true, (Function1)new Function1<Throwable, Unit>(session$iv){
                    final /* synthetic */ RemoteLoaderSession $session;
                    {
                        this.$session = $session;
                    }

                    public final void invoke(Throwable cause) {
                        if (cause instanceof CancellationException) {
                            this.$session.close();
                        }
                    }
                }) : null;
                try {
                    Intrinsics.checkNotNull((Object)session$iv);
                    RemoteLoaderSession session = session$iv;
                    boolean bl2 = false;
                    int blockingLimit = 0;
                    blockingLimit = 1;
                    while (session.fetch(blockingLimit, 100) != null) {
                        List events;
                        Iterable $this$forEach$iv = events;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            RemoteLoaderSession.Event e = (RemoteLoaderSession.Event)element$iv;
                            boolean bl3 = false;
                            this.dispatch(e, dataConsumer);
                            if (!(e instanceof RemoteLoaderSession.Event.Data)) continue;
                            blockingLimit = 100;
                        }
                    }
                    unit = Unit.INSTANCE;
                }
                finally {
                    DisposableHandle disposableHandle = listener$iv;
                    if (disposableHandle != null) {
                        disposableHandle.dispose();
                    }
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void startLoading(Map<String, ? extends Object> parameters, Function1<? super RemoteLoaderSession, Unit> block) {
            boolean $i$f$startLoading = false;
            AutoCloseable autoCloseable = (AutoCloseable)((RemoteLoaderScript)this.remoteLoader.invoke()).startLoading(parameters);
            Throwable throwable = null;
            try {
                Unit unit;
                Job job;
                RemoteLoaderSession session = (RemoteLoaderSession)autoCloseable;
                boolean bl = false;
                Job job2 = job = (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
                DisposableHandle listener2 = job2 != null ? job2.invokeOnCompletion(true, true, (Function1)new /* invalid duplicate definition of identical inner class */) : null;
                try {
                    Intrinsics.checkNotNull((Object)session);
                    unit = (Unit)block.invoke((Object)session);
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    DisposableHandle disposableHandle = listener2;
                    if (disposableHandle != null) {
                        disposableHandle.dispose();
                    }
                    InlineMarker.finallyEnd((int)1);
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
        }

        private final void dispatch(RemoteLoaderSession.Event e, DataConsumer dataConsumer) {
            RemoteLoaderSession.Event event = e;
            if (event instanceof RemoteLoaderSession.Event.Data) {
                List list = ((RemoteLoaderSession.Event.Data)e).data;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"data");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object[] it = (Object[])element$iv;
                    boolean bl = false;
                    dataConsumer.consume(Arrays.copyOf(it, it.length));
                }
            } else if (event instanceof RemoteLoaderSession.Event.Columns) {
                dataConsumer.consumeColumns(((RemoteLoaderSession.Event.Columns)e).names, ((RemoteLoaderSession.Event.Columns)e).types);
            } else {
                if (event instanceof RemoteLoaderSession.Event.Error) {
                    Throwable throwable = ((RemoteLoaderSession.Event.Error)e).throwable;
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
                    throw throwable;
                }
                if (event instanceof RemoteLoaderSession.Event.Progress) {
                    dataConsumer.consumeMessage(((RemoteLoaderSession.Event.Progress)e).message);
                }
            }
        }

        @Override
        public void cleanup() {
        }
    }
}

