/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.status.bean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.intellij.stats.completion.network.status.bean.AnalyticsPlatformSettings;
import java.lang.reflect.Type;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/stats/completion/network/status/bean/AnalyticsPlatformSettingsDeserializer;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGSON", "()Lcom/google/gson/Gson;", "GSON$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "deserialize", "Lcom/intellij/stats/completion/network/status/bean/AnalyticsPlatformSettings;", "json", "", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nAnalyticsPlatformSettingsDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsPlatformSettingsDeserializer.kt\ncom/intellij/stats/completion/network/status/bean/AnalyticsPlatformSettingsDeserializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n13#2:46\n*S KotlinDebug\n*F\n+ 1 AnalyticsPlatformSettingsDeserializer.kt\ncom/intellij/stats/completion/network/status/bean/AnalyticsPlatformSettingsDeserializer\n*L\n30#1:46\n*E\n"})
public final class AnalyticsPlatformSettingsDeserializer {
    @NotNull
    public static final AnalyticsPlatformSettingsDeserializer INSTANCE = new AnalyticsPlatformSettingsDeserializer();
    @NotNull
    private static final Lazy GSON$delegate = LazyKt.lazy(AnalyticsPlatformSettingsDeserializer::GSON_delegate$lambda$0);
    @NotNull
    private static final Logger LOG;

    private AnalyticsPlatformSettingsDeserializer() {
    }

    private final Gson getGSON() {
        Lazy lazy = GSON$delegate;
        return (Gson)lazy.getValue();
    }

    @Nullable
    public final AnalyticsPlatformSettings deserialize(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            return (AnalyticsPlatformSettings)this.getGSON().fromJson(json, AnalyticsPlatformSettings.class);
        }
        catch (JsonSyntaxException e) {
            if (StringsKt.contains((CharSequence)json, (CharSequence)"Authentication", (boolean)true)) {
                LOG.warn("Could not get Analytics Platform settings due to authentication problems", (Throwable)e);
            } else {
                LOG.error("Could not parse Analytics Platform settings: " + json, (Throwable)e);
            }
            return null;
        }
    }

    private static final Gson GSON_delegate$lambda$0() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Language.class), (Object)new JsonDeserializer<Language>(){

            public Language deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!json.isJsonPrimitive()) {
                    throw new JsonSyntaxException("No string field \"language\"");
                }
                String value = json.getAsString();
                if (Intrinsics.areEqual((Object)value, (Object)"ANY")) {
                    Language language = Language.ANY;
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"ANY");
                    return language;
                }
                Language language = Language.findLanguageByID((String)value);
                if (language == null) {
                    throw new JsonSyntaxException("No language with id: " + value);
                }
                return language;
            }
        }).registerTypeAdapter((Type)((Object)Version.class), (Object)new JsonDeserializer<Version>(){

            public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!json.isJsonPrimitive()) {
                    throw new JsonSyntaxException("No string field for major version");
                }
                String value = json.getAsString();
                Version version = Version.parseVersion((String)value);
                if (version == null) {
                    throw new JsonSyntaxException("Couldn't parse major version: " + value);
                }
                return version;
            }
        }).create();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnalyticsPlatformSettingsDeserializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

