/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupUsageTracker;
import com.intellij.completion.ml.experiments.ExperimentInfo;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.tracker.CompletionActionsListener;
import com.intellij.stats.completion.tracker.CompletionLogger;
import com.intellij.stats.completion.tracker.DeferredLog;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/stats/completion/tracker/CompletionActionsTracker;", "Lcom/intellij/stats/completion/tracker/CompletionActionsListener;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/completion/ml/storage/LookupStorage;", "logger", "Lcom/intellij/stats/completion/tracker/CompletionLogger;", "experimentInfo", "Lcom/intellij/completion/ml/experiments/ExperimentInfo;", "<init>", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/completion/ml/storage/LookupStorage;Lcom/intellij/stats/completion/tracker/CompletionLogger;Lcom/intellij/completion/ml/experiments/ExperimentInfo;)V", "completionStarted", "", "selectedByDotTyping", "prefixLength", "", "deferredLog", "Lcom/intellij/stats/completion/tracker/DeferredLog;", "isCompletionActive", "lookupCanceled", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "currentItemChanged", "itemSelected", "beforeDownPressed", "downPressed", "beforeUpPressed", "upPressed", "beforeBackspacePressed", "afterBackspacePressed", "beforeCharTyped", "c", "", "afterAppend", "intellij.statsCollector"})
public final class CompletionActionsTracker
implements CompletionActionsListener {
    @NotNull
    private final LookupImpl lookup;
    @NotNull
    private final LookupStorage lookupStorage;
    @NotNull
    private final CompletionLogger logger;
    @NotNull
    private final ExperimentInfo experimentInfo;
    private boolean completionStarted;
    private boolean selectedByDotTyping;
    private int prefixLength;
    @NotNull
    private final DeferredLog deferredLog;

    public CompletionActionsTracker(@NotNull LookupImpl lookup, @NotNull LookupStorage lookupStorage, @NotNull CompletionLogger logger, @NotNull ExperimentInfo experimentInfo) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)experimentInfo, (String)"experimentInfo");
        this.lookup = lookup;
        this.lookupStorage = lookupStorage;
        this.logger = logger;
        this.experimentInfo = experimentInfo;
        this.deferredLog = new DeferredLog();
    }

    private final boolean isCompletionActive() {
        return this.completionStarted && !this.lookup.isLookupDisposed() || ApplicationManager.getApplication().isUnitTestMode();
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        LookupElement currentItem = this.lookup.getCurrentItem();
        Map performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (currentItem != null && LookupUsageTracker.isSelectedByTyping((LookupImpl)this.lookup, (LookupElement)currentItem) || this.selectedByDotTyping) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.completionCancelled(event.isCanceledExplicitly(), performance, timestamp);
        }
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.completionStarted = true;
        this.prefixLength = LookupExtensionsKt.prefix((Lookup)((Lookup)this.lookup)).length();
        this.deferredLog.defer((Function0<Unit>)((Function0)() -> CompletionActionsTracker.currentItemChanged$lambda$0(this, timestamp)));
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        LookupElement currentItem = this.lookup.getCurrentItem();
        Map performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (currentItem != null && LookupUsageTracker.isSelectedByTyping((LookupImpl)this.lookup, (LookupElement)currentItem)) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.itemSelectedCompletionFinished(this.lookup, event.getCompletionChar(), performance, timestamp);
        }
    }

    @Override
    public void beforeDownPressed() {
        this.deferredLog.log();
    }

    @Override
    public void downPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)() -> CompletionActionsTracker.downPressed$lambda$0(this, timestamp)));
    }

    @Override
    public void beforeUpPressed() {
        this.deferredLog.log();
    }

    @Override
    public void upPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)() -> CompletionActionsTracker.upPressed$lambda$0(this, timestamp)));
    }

    @Override
    public void beforeBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        this.deferredLog.log();
    }

    @Override
    public void afterBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        int n = this.prefixLength;
        this.prefixLength = n + -1;
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)() -> CompletionActionsTracker.afterBackspacePressed$lambda$0(this, timestamp)));
    }

    @Override
    public void beforeCharTyped(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        if (c == '.') {
            LookupElement item = this.lookup.getCurrentItem();
            if (item == null) {
                this.logger.customMessage("Before typed " + c + " lookup.currentItem is null; lookup size: " + this.lookup.getItems().size(), timestamp);
                return;
            }
            String string = this.lookup.itemPattern(item);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
            String text = string;
            if (Intrinsics.areEqual((Object)item.getLookupString(), (Object)text)) {
                this.selectedByDotTyping = true;
            }
        }
    }

    public void afterAppend(char c) {
        if (!this.isCompletionActive() || !Character.isJavaIdentifierPart(c)) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        int n = this.prefixLength;
        this.prefixLength = n + 1;
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)() -> CompletionActionsTracker.afterAppend$lambda$0(this, c, timestamp)));
    }

    private static final Unit currentItemChanged$lambda$0(CompletionActionsTracker this$0, long $timestamp) {
        this$0.logger.completionStarted(this$0.lookup, this$0.prefixLength, this$0.experimentInfo.getInExperiment(), this$0.experimentInfo.getVersion(), $timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit downPressed$lambda$0(CompletionActionsTracker this$0, long $timestamp) {
        this$0.logger.downPressed(this$0.lookup, $timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit upPressed$lambda$0(CompletionActionsTracker this$0, long $timestamp) {
        this$0.logger.upPressed(this$0.lookup, $timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit afterBackspacePressed$lambda$0(CompletionActionsTracker this$0, long $timestamp) {
        this$0.logger.afterBackspacePressed(this$0.lookup, this$0.prefixLength, $timestamp);
        return Unit.INSTANCE;
    }

    private static final Unit afterAppend$lambda$0(CompletionActionsTracker this$0, char $c, long $timestamp) {
        this$0.logger.afterCharTyped($c, this$0.lookup, this$0.prefixLength, $timestamp);
        return Unit.INSTANCE;
    }
}

