/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.platform.ide.productMode.IdeProductMode;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0003\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\b\u0010\u000f\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00010\u0014H\u0007\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\"\u001b\u0010\u0007\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u001b\u0010\f\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0019"}, d2={"shouldEnableServicesViewInCurrentEnvironment", "", "isNewFrontendServiceViewEnabled", "isOldMonolithServiceViewEnabled", "isSplitDebuggerEnabledInTestsCopyPaste", "isSplitServicesRegistryFlagOn", "isShowLuxedRunToolwindowInServicesView", "shouldEnableSplitServiceViewCachedRegistryValue", "getShouldEnableSplitServiceViewCachedRegistryValue", "()Z", "shouldEnableSplitServiceViewCachedRegistryValue$delegate", "Lkotlin/Lazy;", "shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue", "getShouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue", "shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue$delegate", "isCurrentProductSupportSplitServiceView", "setServiceViewImplementationForNextIdeRun", "", "shouldEnableSplitImplementation", "getServiceViewRegistryFlagsState", "", "", "getValueIfExists", "Lcom/intellij/openapi/util/registry/RegistryValue;", "key", "intellij.platform.execution.serviceView"})
@SourceDebugExtension(value={"SMAP\nserviceViewImplementationChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n57#2:116\n35#2,2:117\n*S KotlinDebug\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n*L\n23#1:116\n23#1:117,2\n*E\n"})
public final class ServiceViewImplementationChooserKt {
    @NotNull
    private static final Lazy shouldEnableSplitServiceViewCachedRegistryValue$delegate = LazyKt.lazy(ServiceViewImplementationChooserKt::shouldEnableSplitServiceViewCachedRegistryValue_delegate$lambda$0);
    @NotNull
    private static final Lazy shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue$delegate = LazyKt.lazy(ServiceViewImplementationChooserKt::shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue_delegate$lambda$0);

    @ApiStatus.Internal
    public static final boolean shouldEnableServicesViewInCurrentEnvironment() {
        boolean isServicesEnabled = IdeProductMode.Companion.isMonolith() ? true : (IdeProductMode.Companion.isFrontend() && ServiceViewImplementationChooserKt.isNewFrontendServiceViewEnabled() ? true : IdeProductMode.Companion.isBackend() && ServiceViewImplementationChooserKt.isOldMonolithServiceViewEnabled());
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Services implementation is " + (isServicesEnabled ? "enabled" : "disabled") + " in current environment. Is frontend: " + IdeProductMode.Companion.isFrontend() + ", is monolith: " + IdeProductMode.Companion.isMonolith() + ", is backend: " + IdeProductMode.Companion.isBackend() + ".");
        return isServicesEnabled;
    }

    @ApiStatus.Internal
    public static final boolean isNewFrontendServiceViewEnabled() {
        if (ServiceViewImplementationChooserKt.isSplitDebuggerEnabledInTestsCopyPaste()) {
            return true;
        }
        if (IdeProductMode.Companion.isMonolith()) {
            return false;
        }
        return ServiceViewImplementationChooserKt.isSplitServicesRegistryFlagOn() && ServiceViewImplementationChooserKt.isCurrentProductSupportSplitServiceView();
    }

    @ApiStatus.Internal
    public static final boolean isOldMonolithServiceViewEnabled() {
        if (ServiceViewImplementationChooserKt.isSplitDebuggerEnabledInTestsCopyPaste()) {
            return false;
        }
        return IdeProductMode.Companion.isMonolith() || !ServiceViewImplementationChooserKt.isSplitServicesRegistryFlagOn();
    }

    private static final boolean isSplitDebuggerEnabledInTestsCopyPaste() {
        String testProperty;
        String string = testProperty = System.getProperty("xdebugger.toolwindow.split.for.tests");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private static final boolean isSplitServicesRegistryFlagOn() {
        return ServiceViewImplementationChooserKt.getShouldEnableSplitServiceViewCachedRegistryValue();
    }

    @ApiStatus.Internal
    public static final boolean isShowLuxedRunToolwindowInServicesView() {
        return ServiceViewImplementationChooserKt.getShouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue();
    }

    private static final boolean getShouldEnableSplitServiceViewCachedRegistryValue() {
        Lazy lazy = shouldEnableSplitServiceViewCachedRegistryValue$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final boolean getShouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue() {
        Lazy lazy = shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue$delegate;
        return (Boolean)lazy.getValue();
    }

    @ApiStatus.Internal
    public static final boolean isCurrentProductSupportSplitServiceView() {
        Object object = ServiceViewImplementationChooserKt.getValueIfExists("services.view.split.products");
        if (object == null || (object = object.asString()) == null) {
            return false;
        }
        Object value = object;
        String[] stringArray = new String[]{","};
        Set productCodes = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)((CharSequence)value), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String currentProductCode = IdeProductMode.Companion.isFrontend() ? ApplicationInfoEx.getInstanceEx().getFullIdeProductCode() : ApplicationInfoImpl.getShadowInstanceImpl().getBuild().getProductCode();
        return CollectionsKt.contains((Iterable)productCodes, (Object)currentProductCode);
    }

    @ApiStatus.Internal
    public static final void setServiceViewImplementationForNextIdeRun(boolean shouldEnableSplitImplementation) {
        block5: {
            RegistryValue registryValue = ServiceViewImplementationChooserKt.getValueIfExists("services.view.split.enabled");
            if (registryValue != null) {
                registryValue.setValue(shouldEnableSplitImplementation);
            }
            RegistryValue registryValue2 = ServiceViewImplementationChooserKt.getValueIfExists("services.view.split.run.luxing.enabled");
            if (registryValue2 != null) {
                registryValue2.setValue(shouldEnableSplitImplementation);
            }
            if (shouldEnableSplitImplementation) {
                RegistryValue registryValue3 = ServiceViewImplementationChooserKt.getValueIfExists("xdebugger.toolwindow.split.remdev");
                if (registryValue3 != null) {
                    registryValue3.setValue(true);
                }
            }
            RegistryValue registryValue4 = ServiceViewImplementationChooserKt.getValueIfExists("docker.split.service.view.enabled");
            if (registryValue4 != null) {
                registryValue4.setValue(shouldEnableSplitImplementation);
            }
            RegistryValue registryValue5 = ServiceViewImplementationChooserKt.getValueIfExists("docker.registry.split.service.view.enabled");
            if (registryValue5 == null) break block5;
            registryValue5.setValue(shouldEnableSplitImplementation);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final Map<String, Boolean> getServiceViewRegistryFlagsState() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"services.view.split.enabled", (Object)Registry.Companion.is("services.view.split.enabled", true)), TuplesKt.to((Object)"services.view.split.run.luxing.enabled", (Object)Registry.Companion.is("services.view.split.run.luxing.enabled", true)), TuplesKt.to((Object)"xdebugger.toolwindow.split.remdev", (Object)Registry.Companion.is("xdebugger.toolwindow.split.remdev", true)), TuplesKt.to((Object)"docker.split.service.view.enabled", (Object)Registry.Companion.is("docker.split.service.view.enabled", true)), TuplesKt.to((Object)"docker.registry.split.service.view.enabled", (Object)Registry.Companion.is("docker.registry.split.service.view.enabled", true))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final RegistryValue getValueIfExists(String key) {
        RegistryValue registryValue;
        RegistryValue maybeMissingValue = Registry.Companion.get(key);
        try {
            maybeMissingValue.asString();
            registryValue = maybeMissingValue;
        }
        catch (MissingResourceException missingResourceException) {
            registryValue = null;
        }
        return registryValue;
    }

    private static final boolean shouldEnableSplitServiceViewCachedRegistryValue_delegate$lambda$0() {
        return Registry.Companion.is("services.view.split.enabled", true);
    }

    private static final boolean shouldEnableLuxedRunToolwindowInServiceViewCachedRegistryValue_delegate$lambda$0() {
        return Registry.Companion.is("services.view.split.run.luxing.enabled", true);
    }
}

