/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.CreateEdgeMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGraphEdgeCreationMode<N, E>
extends CreateEdgeMode {
    @NotNull
    private static final Logger LOG = Logger.getInstance(BaseGraphEdgeCreationMode.class);
    @Nullable
    private final EdgeCreationPolicy<? super N> myPolicy;
    @NotNull
    private final GraphBuilder<N, E> myBuilder;

    public BaseGraphEdgeCreationMode(@Nullable EdgeCreationPolicy<? super N> policy, @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            BaseGraphEdgeCreationMode.$$$reportNull$$$0(0);
        }
        this.myPolicy = policy;
        this.myBuilder = builder;
    }

    @Override
    @Nullable
    public Edge createEdge(Graph2D graph2D, Node from, Node to, EdgeRealizer edgeRealizer) {
        N n1 = this.myBuilder.getNodeObject(from);
        N n2 = this.myBuilder.getNodeObject(to);
        if (n1 != null && n2 != null) {
            try {
                this.myBuilder.getGraphDataModel().createEdge(n1, n2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean acceptSourceNode(Node source, double x, double y) {
        if (this.myPolicy == null) {
            return true;
        }
        N n = this.myBuilder.getNodeObject(source);
        return n != null && this.myPolicy.acceptSource(n);
    }

    @Override
    public void targetNodeDeclined(Node target, double x, double y) {
    }

    @Override
    public boolean acceptTargetNode(Node target, double x, double y) {
        if (this.myPolicy == null) {
            return true;
        }
        N n = this.myBuilder.getNodeObject(target);
        return n != null && this.myPolicy.acceptTarget(n);
    }

    @Override
    public void sourceNodeDeclined(Node target, double x, double y) {
        this.cancelEdgeCreation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/graph/view/BaseGraphEdgeCreationMode", "<init>"));
    }
}

